/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widget.curved;

import android.content.Context;
import android.util.AttributeSet;
import com.aigestudio.wheelpicker.view.WheelCurvedPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class WheelDayPicker
extends WheelCurvedPicker {
    private static final HashMap<Integer, List<String>> DAYS = new HashMap();
    private static final Calendar C = Calendar.getInstance();
    private List<String> days = new ArrayList<String>();
    private int day = C.get(5);
    private int month = C.get(2) + 1;
    private int year = C.get(1);
    private int maxDay;

    public WheelDayPicker(Context context) {
        super(context);
        this.init();
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.initData();
        this.setCurrentDay();
    }

    private void initData() {
        ArrayList<String> days;
        int maxDay = C.getActualMaximum(5);
        if (maxDay == this.maxDay) {
            return;
        }
        this.maxDay = maxDay;
        if (DAYS.containsKey(maxDay)) {
            days = DAYS.get(maxDay);
        } else {
            days = new ArrayList();
            for (int i = 1; i <= maxDay; ++i) {
                days.add(String.valueOf(i));
            }
            DAYS.put(maxDay, days);
        }
        this.days = days;
        super.setData(days);
    }

    @Override
    public void setData(List<String> data) {
        throw new RuntimeException("Set data will not allow here!");
    }

    public void setCurrentDay(int day) {
        day = Math.max(day, 1);
        this.day = day = Math.min(day, this.maxDay);
        this.setCurrentDay();
    }

    private void setCurrentDay() {
        this.setItemIndex(this.day - 1);
    }

    public void setCurrentMonth(int month) {
        this.setMonth(month);
        this.initData();
    }

    private void setMonth(int month) {
        month = Math.max(month, 1);
        this.month = month = Math.min(month, 12);
        C.set(2, month - 1);
    }

    public void setCurrentYear(int year) {
        this.setYear(year);
        this.initData();
    }

    private void setYear(int year) {
        year = Math.max(year, 1);
        this.year = year = Math.min(year, 0x7FFFFFFE);
        C.set(1, year);
    }

    public void setCurrentYearAndMonth(int year, int month) {
        this.setYear(year);
        this.setMonth(month);
        this.initData();
        this.checkScrollState();
    }
}

