/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.aigestudio.wheelpicker.core.AbstractWheelDecor;
import com.aigestudio.wheelpicker.core.AbstractWheelPicker;
import com.aigestudio.wheelpicker.view.CrossHorImpl;
import com.aigestudio.wheelpicker.view.CrossVerImpl;
import com.aigestudio.wheelpicker.view.ICrossOrientation;
import com.aigestudio.wheelpicker.view.IWheelCrossPicker;
import java.util.List;

public abstract class WheelCrossPicker
extends AbstractWheelPicker
implements IWheelCrossPicker,
Runnable {
    private static final int TIME_REFRESH = 16;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected ICrossOrientation mOrientation;
    protected Rect rectCurDecor;
    protected Rect rectCurItem;
    protected Rect rectLast;
    protected Rect rectNext;
    protected int unit;
    protected int unitDeltaTotal;
    protected int unitDeltaMin;
    protected int unitDeltaMax;
    protected int unitDisplayMin;
    protected int unitDisplayMax;

    public WheelCrossPicker(Context context) {
        super(context);
    }

    public WheelCrossPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void instantiation() {
        super.instantiation();
        this.mOrientation = new CrossVerImpl();
        this.rectCurDecor = new Rect();
        this.rectCurItem = new Rect();
        this.rectLast = new Rect();
        this.rectNext = new Rect();
    }

    @Override
    public void setOrientation(int orientation) {
        this.mOrientation = orientation == 0 ? new CrossHorImpl() : new CrossVerImpl();
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.mOrientation.computeCurItemRect(this.rectCurItem, this.itemSpace, w, h, this.maxTextWidth, this.maxTextHeight, this.wheelCenterX, this.wheelCenterY, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.mOrientation.computeRectPadding(this.rectLast, this.rectNext, this.rectCurItem, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.rectCurDecor.set(this.rectCurItem);
        if (!this.ignorePadding) {
            this.mOrientation.removePadding(this.rectCurDecor, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    @Override
    protected void drawBackground(Canvas canvas) {
    }

    @Override
    protected void drawForeground(Canvas canvas) {
        if (null != this.mWheelDecor) {
            canvas.save();
            canvas.clipRect(this.rectCurDecor);
            this.mWheelDecor.drawDecor(canvas, this.rectLast, this.rectNext, this.mPaint);
            canvas.restore();
        }
    }

    @Override
    protected void onTouchDown(MotionEvent event) {
    }

    @Override
    protected void onTouchMove(MotionEvent event) {
        this.onWheelScrollStateChanged(1);
        this.onWheelScrolling(this.disTotalMoveX + this.diSingleMoveX, this.disTotalMoveY + this.diSingleMoveY);
        this.invalidate();
    }

    @Override
    protected void onTouchUp(MotionEvent event) {
        this.mOrientation.fling(this.mScroller, this.mTracker, this.unitDeltaTotal, this.unitDeltaMin, this.unitDeltaMax, this.unitDisplayMax);
        this.onWheelScrollStateChanged(2);
        this.mHandler.post((Runnable)this);
    }

    @Override
    public void run() {
        if (this.mScroller.isFinished()) {
            this.onWheelScrollStateChanged(0);
            this.correctLocation();
            this.confirmData();
        }
        if (this.mScroller.computeScrollOffset()) {
            this.disTotalMoveX = this.mScroller.getCurrX();
            this.disTotalMoveY = this.mScroller.getCurrY();
            this.unitDeltaTotal = this.mOrientation.getUnitDeltaTotal(this.mScroller);
            this.onWheelScrolling(this.disTotalMoveX, this.disTotalMoveY);
            this.postInvalidate();
            this.mHandler.postDelayed((Runnable)this, 16L);
        }
    }

    private void confirmData() {
        if (this.state != 0) {
            return;
        }
        int curIndex = this.itemIndex - this.unitDeltaTotal / this.unit;
        curIndex = Math.max(0, curIndex);
        curIndex = Math.min(this.data.size() - 1, curIndex);
        String curData = (String)this.data.get(curIndex);
        if (!this.curData.equals(curData)) {
            this.curData = curData;
            this.onWheelSelected(curIndex, curData);
        }
    }

    private void correctLocation() {
        int remainder = Math.abs(this.unitDeltaTotal % this.unit);
        if (remainder != 0) {
            if ((float)remainder >= (float)this.unit / 2.0f) {
                this.correctScroll(remainder - this.unit, this.unit - remainder);
            } else {
                this.correctScroll(remainder, -remainder);
            }
            this.postInvalidate();
            this.mHandler.postDelayed((Runnable)this, 16L);
        }
    }

    private void correctScroll(int endBack, int endForward) {
        if (this.unitDeltaTotal < 0) {
            this.mOrientation.startScroll(this.mScroller, this.unitDeltaTotal, endBack);
        } else {
            this.mOrientation.startScroll(this.mScroller, this.unitDeltaTotal, endForward);
        }
        this.onWheelScrollStateChanged(2);
    }

    public void checkScrollState() {
        if (this.unitDeltaTotal > this.unitDeltaMax) {
            this.mOrientation.startScroll(this.mScroller, this.unitDeltaTotal, this.unitDeltaMax - this.unitDeltaTotal);
        }
        if (this.unitDeltaTotal < this.unitDeltaMin) {
            this.mOrientation.startScroll(this.mScroller, this.unitDeltaTotal, this.unitDeltaMin - this.unitDeltaTotal);
        }
        this.mHandler.post((Runnable)this);
    }

    @Override
    public void setCurrentTextColor(int color) {
        super.setCurrentTextColor(color);
        this.invalidate(this.rectCurItem);
    }

    @Override
    public void setWheelDecor(boolean ignorePadding, AbstractWheelDecor decor) {
        super.setWheelDecor(ignorePadding, decor);
        this.invalidate(this.rectCurItem);
    }

    @Override
    public void setTextSize(int size) {
        super.setTextSize(size);
        this.clearCache();
    }

    @Override
    public void setItemSpace(int space) {
        super.setItemSpace(space);
        this.clearCache();
    }

    @Override
    public void setItemCount(int count) {
        super.setItemCount(count);
        this.clearCache();
    }

    @Override
    public void setData(List<String> data) {
        super.setData(data);
        this.clearCache();
    }

    @Override
    public void clearCache() {
    }
}

