/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widget.curved;

import android.content.Context;
import android.util.AttributeSet;
import com.aigestudio.wheelpicker.view.WheelCurvedPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WheelYearPicker
extends WheelCurvedPicker {
    private static final List<String> YEARS = new ArrayList<String>();
    private static final int FROM = 1900;
    private static final int TO = 2100;
    private List<String> years = YEARS;
    private int from = 1900;
    private int to = 2100;
    private int year;

    public WheelYearPicker(Context context) {
        super(context);
        this.init();
    }

    public WheelYearPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        super.setData(this.years);
        this.setCurrentYear(Calendar.getInstance().get(1));
    }

    @Override
    public void setData(List<String> data) {
        throw new RuntimeException("Set data will not allow here!");
    }

    public void setYearRange(int yearFrom, int yearTo) {
        this.from = yearFrom;
        this.to = yearTo;
        this.years.clear();
        for (int i = yearFrom; i <= yearTo; ++i) {
            this.years.add(String.valueOf(i));
        }
        super.setData(this.years);
    }

    public void setCurrentYear(int year) {
        year = Math.max(year, this.from);
        this.year = year = Math.min(year, this.to);
        int d = year - this.from;
        this.setItemIndex(d);
    }

    static {
        for (int i = 1900; i <= 2100; ++i) {
            YEARS.add(String.valueOf(i));
        }
    }
}

