/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Region;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.aigestudio.wheelpicker.view.WheelCrossPicker;

public class WheelStraightPicker
extends WheelCrossPicker {
    public WheelStraightPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WheelStraightPicker(Context context) {
        super(context);
    }

    @Override
    public void computeWheelSizes() {
        super.computeWheelSizes();
        this.wheelContentWidth = this.mOrientation.getStraightWidth(this.itemCount, this.itemSpace, this.maxTextWidth, this.maxTextHeight);
        this.wheelContentHeight = this.mOrientation.getStraightHeight(this.itemCount, this.itemSpace, this.maxTextWidth, this.maxTextHeight);
        this.unit = this.mOrientation.getStraightUnit(this.itemSpace, this.maxTextWidth, this.maxTextHeight);
        int disDisplay = this.mOrientation.getDisplay(this.itemCount, this.itemSpace, this.maxTextWidth, this.maxTextHeight);
        this.unitDisplayMin = -disDisplay;
        this.unitDisplayMax = disDisplay;
        this.unitDeltaMin = -this.unit * (this.data.size() - this.itemIndex - 1);
        this.unitDeltaMax = this.unit * this.itemIndex;
    }

    @Override
    protected void drawItems(Canvas canvas) {
        for (int i = -this.itemIndex; i < this.data.size() - this.itemIndex; ++i) {
            int curDis = this.mOrientation.computeStraightUnit(this.unit, i, this.disTotalMoveX, this.disTotalMoveY, this.diSingleMoveX, this.diSingleMoveY);
            if (curDis > this.unitDisplayMax || curDis < this.unitDisplayMin) continue;
            canvas.save();
            canvas.clipRect(this.rectCurItem, Region.Op.DIFFERENCE);
            this.mTextPaint.setColor(this.textColor);
            this.mTextPaint.setAlpha(255 - 255 * Math.abs(curDis) / this.unitDisplayMax);
            this.mOrientation.draw(canvas, this.mTextPaint, (String)this.data.get(i + this.itemIndex), curDis, this.wheelCenterX, this.wheelCenterTextY);
            canvas.restore();
            canvas.save();
            canvas.clipRect(this.rectCurItem);
            this.mTextPaint.setColor(this.curTextColor);
            this.mOrientation.draw(canvas, this.mTextPaint, (String)this.data.get(i + this.itemIndex), curDis, this.wheelCenterX, this.wheelCenterTextY);
            canvas.restore();
        }
    }

    @Override
    protected void onTouchMove(MotionEvent event) {
        super.onTouchMove(event);
    }

    @Override
    protected void onTouchUp(MotionEvent event) {
        this.unitDeltaTotal = this.mOrientation.getUnitDeltaTotal(this.disTotalMoveX, this.disTotalMoveY);
        super.onTouchUp(event);
    }
}

