/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.core;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.aigestudio.wheelpicker.R;
import com.aigestudio.wheelpicker.core.AbstractWheelDecor;
import com.aigestudio.wheelpicker.core.IWheelPicker;
import com.aigestudio.wheelpicker.core.OverScrollerCompat;
import com.aigestudio.wheelpicker.core.ScrollerCompat;
import com.aigestudio.wheelpicker.core.WheelScroller;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractWheelPicker
extends View
implements IWheelPicker {
    private static final int TOUCH_DISTANCE_MINIMUM = 8;
    private static final int VELOCITY_TRACKER_UNITS = 150;
    protected VelocityTracker mTracker;
    protected WheelScroller mScroller;
    protected TextPaint mTextPaint;
    protected Paint mPaint;
    protected Rect mTextBound;
    protected Rect mDrawBound;
    protected Handler mHandler;
    protected OnWheelChangeListener mListener;
    protected AbstractWheelDecor mWheelDecor;
    protected List<String> data;
    protected String curData;
    protected int state = 0;
    protected int itemCount;
    protected int itemIndex;
    protected int itemSpace;
    protected int textSize;
    protected int textColor;
    protected int curTextColor;
    protected int maxTextWidth;
    protected int maxTextHeight;
    protected int wheelContentWidth;
    protected int wheelContentHeight;
    protected int wheelCenterX;
    protected int wheelCenterY;
    protected int wheelCenterTextY;
    protected int lastX;
    protected int lastY;
    protected int diSingleMoveX;
    protected int diSingleMoveY;
    protected int disTotalMoveX;
    protected int disTotalMoveY;
    protected boolean ignorePadding;
    protected boolean hasSameSize;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;

    public AbstractWheelPicker(Context context) {
        super(context);
        this.init(null);
    }

    public AbstractWheelPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.obtainAttrs(attrs);
        this.instantiation();
        this.assignment();
        this.computeWheelSizes();
    }

    protected void obtainAttrs(AttributeSet attrs) {
        int defDataID = R.array.WheelArrayDefault;
        int defItemIndex = 0;
        int defItemCount = 7;
        int defItemSpace = this.getResources().getDimensionPixelSize(R.dimen.WheelItemSpace);
        int defTextSize = this.getResources().getDimensionPixelSize(R.dimen.WheelTextSize);
        int defTextColor = -16777216;
        int defCurTextColor = -16777216;
        if (null != attrs) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.AbstractWheelPicker);
            int idData = a.getResourceId(R.styleable.AbstractWheelPicker_wheel_data, 0);
            if (idData == 0) {
                idData = defDataID;
            }
            this.data = Arrays.asList(this.getContext().getResources().getStringArray(idData));
            this.itemIndex = a.getInt(R.styleable.AbstractWheelPicker_wheel_item_index, defItemIndex);
            this.itemCount = a.getInt(R.styleable.AbstractWheelPicker_wheel_item_count, defItemCount);
            this.itemSpace = a.getDimensionPixelSize(R.styleable.AbstractWheelPicker_wheel_item_space, defItemSpace);
            this.textSize = a.getDimensionPixelSize(R.styleable.AbstractWheelPicker_wheel_text_size, defTextSize);
            this.textColor = a.getColor(R.styleable.AbstractWheelPicker_wheel_text_color, defTextColor);
            this.curTextColor = a.getColor(R.styleable.AbstractWheelPicker_wheel_text_color_current, defCurTextColor);
            this.hasSameSize = a.getBoolean(R.styleable.AbstractWheelPicker_wheel_item_same_size, false);
            a.recycle();
        } else {
            this.data = Arrays.asList(this.getContext().getResources().getStringArray(defDataID));
            this.itemIndex = defItemIndex;
            this.itemCount = defItemCount;
            this.itemSpace = defItemSpace;
            this.textSize = defTextSize;
            this.curTextColor = defCurTextColor;
        }
    }

    protected void instantiation() {
        this.mTextPaint = new TextPaint(69);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setTextSize((float)this.textSize);
        this.mPaint = new Paint(5);
        this.mTextBound = new Rect();
        this.mDrawBound = new Rect();
        this.mHandler = new Handler();
        this.mScroller = Build.VERSION.SDK_INT >= 9 ? new OverScrollerCompat(this.getContext(), (Interpolator)new DecelerateInterpolator()) : new ScrollerCompat(this.getContext(), (Interpolator)new DecelerateInterpolator());
        if (Build.VERSION.SDK_INT >= 11) {
            this.mScroller.setFriction(ViewConfiguration.getScrollFriction() / 25.0f);
        }
    }

    protected void assignment() {
        this.curData = "";
    }

    protected void computeWheelSizes() {
        this.maxTextWidth = 0;
        this.maxTextHeight = 0;
        if (this.hasSameSize) {
            String text = this.data.get(0);
            this.mTextPaint.getTextBounds(text, 0, text.length(), this.mTextBound);
            this.maxTextWidth = Math.max(this.maxTextWidth, this.mTextBound.width());
            this.maxTextHeight = Math.max(this.maxTextHeight, this.mTextBound.height());
        } else {
            for (String text : this.data) {
                this.mTextPaint.getTextBounds(text, 0, text.length(), this.mTextBound);
                this.maxTextWidth = Math.max(this.maxTextWidth, this.mTextBound.width());
                this.maxTextHeight = Math.max(this.maxTextHeight, this.mTextBound.height());
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultWidth = this.wheelContentWidth;
        int resultHeight = this.wheelContentHeight;
        resultWidth += this.getPaddingLeft() + this.getPaddingRight();
        resultHeight += this.getPaddingTop() + this.getPaddingBottom();
        resultWidth = this.measureSize(modeWidth, sizeWidth, resultWidth);
        resultHeight = this.measureSize(modeHeight, sizeHeight, resultHeight);
        this.setMeasuredDimension(resultWidth, resultHeight);
    }

    private int measureSize(int mode, int sizeExpect, int sizeActual) {
        int realSize;
        if (mode == 0x40000000) {
            realSize = sizeExpect;
        } else {
            realSize = sizeActual;
            if (mode == Integer.MIN_VALUE) {
                realSize = Math.min(realSize, sizeExpect);
            }
        }
        return realSize;
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.onWheelSelected(this.itemIndex, this.data.get(this.itemIndex));
        this.mDrawBound.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
        this.wheelCenterX = this.mDrawBound.centerX();
        this.wheelCenterY = this.mDrawBound.centerY();
        this.wheelCenterTextY = (int)((float)this.wheelCenterY - (this.mTextPaint.ascent() + this.mTextPaint.descent()) / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBackground(canvas);
        canvas.save();
        canvas.clipRect(this.mDrawBound);
        this.drawItems(canvas);
        canvas.restore();
        this.drawForeground(canvas);
    }

    protected abstract void drawBackground(Canvas var1);

    protected abstract void drawItems(Canvas var1);

    protected abstract void drawForeground(Canvas var1);

    public boolean onTouchEvent(MotionEvent event) {
        if (null == this.mTracker) {
            this.mTracker = VelocityTracker.obtain();
        }
        this.mTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.lastX = (int)event.getX();
                this.lastY = (int)event.getY();
                this.onTouchDown(event);
                break;
            }
            case 2: {
                this.diSingleMoveX = (int)((float)this.diSingleMoveX + (event.getX() - (float)this.lastX));
                this.diSingleMoveY = (int)((float)this.diSingleMoveY + (event.getY() - (float)this.lastY));
                this.lastX = (int)event.getX();
                this.lastY = (int)event.getY();
                this.onTouchMove(event);
                break;
            }
            case 1: {
                this.disTotalMoveX += this.diSingleMoveX;
                this.disTotalMoveY += this.diSingleMoveY;
                this.diSingleMoveX = 0;
                this.diSingleMoveY = 0;
                this.mTracker.computeCurrentVelocity(150);
                this.onTouchUp(event);
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.mTracker.recycle();
                this.mTracker = null;
                break;
            }
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.mScroller.abortAnimation();
                this.mTracker.recycle();
                this.mTracker = null;
            }
        }
        return true;
    }

    protected abstract void onTouchDown(MotionEvent var1);

    protected abstract void onTouchMove(MotionEvent var1);

    protected abstract void onTouchUp(MotionEvent var1);

    protected boolean isEventValid() {
        return this.isEventValidVer() || this.isEventValidHor();
    }

    protected boolean isEventValidHor() {
        return Math.abs(this.diSingleMoveX) > 8;
    }

    protected boolean isEventValidVer() {
        return Math.abs(this.diSingleMoveY) > 8;
    }

    protected void onWheelScrolling(float deltaX, float deltaY) {
        if (null != this.mListener) {
            this.mListener.onWheelScrolling(deltaX, deltaY);
        }
    }

    protected void onWheelSelected(int index, String data) {
        if (null != this.mListener) {
            this.mListener.onWheelSelected(index, data);
        }
    }

    protected void onWheelScrollStateChanged(int state) {
        if (this.state != state) {
            this.state = state;
            if (null != this.mListener) {
                this.mListener.onWheelScrollStateChanged(state);
            }
        }
    }

    @Override
    public void setData(List<String> data) {
        this.data = data;
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    public void setOnWheelChangeListener(OnWheelChangeListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setItemIndex(int index) {
        this.itemIndex = index;
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    public void setItemSpace(int space) {
        this.itemSpace = space;
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    public void setItemCount(int count) {
        this.itemCount = count;
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    public void setTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    @Override
    public void setTextSize(int size) {
        this.textSize = size;
        this.mTextPaint.setTextSize((float)size);
        this.computeWheelSizes();
        this.requestLayout();
    }

    @Override
    public void setCurrentTextColor(int color) {
        this.curTextColor = color;
    }

    @Override
    public void setWheelDecor(boolean ignorePadding, AbstractWheelDecor decor) {
        this.ignorePadding = ignorePadding;
        this.mWheelDecor = decor;
    }

    public static class SimpleWheelChangeListener
    implements OnWheelChangeListener {
        @Override
        public void onWheelScrolling(float deltaX, float deltaY) {
        }

        @Override
        public void onWheelSelected(int index, String data) {
        }

        @Override
        public void onWheelScrollStateChanged(int state) {
        }
    }

    public static interface OnWheelChangeListener {
        public void onWheelScrolling(float var1, float var2);

        public void onWheelSelected(int var1, String var2);

        public void onWheelScrollStateChanged(int var1);
    }
}

