/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.Scroller;
import cn.aigestudio.datepicker.bizs.calendars.DPCManager;
import cn.aigestudio.datepicker.bizs.decors.DPDecor;
import cn.aigestudio.datepicker.bizs.themes.DPTManager;
import cn.aigestudio.datepicker.cons.DPMode;
import cn.aigestudio.datepicker.entities.DPInfo;
import cn.aigestudio.datepicker.views.DatePicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonthView
extends View {
    private final Region[][] MONTH_REGIONS_4 = new Region[4][7];
    private final Region[][] MONTH_REGIONS_5 = new Region[5][7];
    private final Region[][] MONTH_REGIONS_6 = new Region[6][7];
    private final DPInfo[][] INFO_4 = new DPInfo[4][7];
    private final DPInfo[][] INFO_5 = new DPInfo[5][7];
    private final DPInfo[][] INFO_6 = new DPInfo[6][7];
    private final Map<String, List<Region>> REGION_SELECTED = new HashMap<String, List<Region>>();
    private DPCManager mCManager = DPCManager.getInstance();
    private DPTManager mTManager = DPTManager.getInstance();
    protected Paint mPaint = new Paint(69);
    private Scroller mScroller;
    private DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
    private AccelerateInterpolator accelerateInterpolator = new AccelerateInterpolator();
    private OnDateChangeListener onDateChangeListener;
    private DatePicker.OnDatePickedListener onDatePickedListener;
    private ScaleAnimationListener scaleAnimationListener;
    private DPMode mDPMode = DPMode.MULTIPLE;
    private SlideMode mSlideMode;
    private DPDecor mDPDecor;
    private int circleRadius;
    private int indexYear;
    private int indexMonth;
    private int centerYear;
    private int centerMonth;
    private int leftYear;
    private int leftMonth;
    private int rightYear;
    private int rightMonth;
    private int topYear;
    private int topMonth;
    private int bottomYear;
    private int bottomMonth;
    private int width;
    private int height;
    private int sizeDecor;
    private int sizeDecor2x;
    private int sizeDecor3x;
    private int lastPointX;
    private int lastPointY;
    private int lastMoveX;
    private int lastMoveY;
    private int criticalWidth;
    private int criticalHeight;
    private int animZoomOut1;
    private int animZoomIn1;
    private int animZoomOut2;
    private float sizeTextGregorian;
    private float sizeTextFestival;
    private float offsetYFestival1;
    private float offsetYFestival2;
    private boolean isNewEvent;
    private boolean isFestivalDisplay = true;
    private boolean isHolidayDisplay = true;
    private boolean isTodayDisplay = true;
    private boolean isDeferredDisplay = true;
    private Map<String, BGCircle> cirApr = new HashMap<String, BGCircle>();
    private Map<String, BGCircle> cirDpr = new HashMap<String, BGCircle>();
    private List<String> dateSelected = new ArrayList<String>();

    public MonthView(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT >= 11) {
            this.scaleAnimationListener = new ScaleAnimationListener();
        }
        this.mScroller = new Scroller(context);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.invalidate();
        } else {
            this.requestLayout();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mScroller.forceFinished(true);
                this.mSlideMode = null;
                this.isNewEvent = true;
                this.lastPointX = (int)event.getX();
                this.lastPointY = (int)event.getY();
                break;
            }
            case 2: {
                if (this.isNewEvent) {
                    if (Math.abs((float)this.lastPointX - event.getX()) > 100.0f) {
                        this.mSlideMode = SlideMode.HOR;
                        this.isNewEvent = false;
                    } else if (Math.abs((float)this.lastPointY - event.getY()) > 50.0f) {
                        this.mSlideMode = SlideMode.VER;
                        this.isNewEvent = false;
                    }
                }
                if (this.mSlideMode == SlideMode.HOR) {
                    int totalMoveX = (int)((float)this.lastPointX - event.getX()) + this.lastMoveX;
                    this.smoothScrollTo(totalMoveX, this.indexYear * this.height);
                    break;
                }
                if (this.mSlideMode != SlideMode.VER) break;
                int totalMoveY = (int)((float)this.lastPointY - event.getY()) + this.lastMoveY;
                this.smoothScrollTo(this.width * this.indexMonth, totalMoveY);
                break;
            }
            case 1: {
                if (this.mSlideMode == SlideMode.VER) {
                    if (Math.abs((float)this.lastPointY - event.getY()) > 25.0f) {
                        if ((float)this.lastPointY < event.getY()) {
                            if (Math.abs((float)this.lastPointY - event.getY()) >= (float)this.criticalHeight) {
                                --this.indexYear;
                                --this.centerYear;
                            }
                        } else if ((float)this.lastPointY > event.getY() && Math.abs((float)this.lastPointY - event.getY()) >= (float)this.criticalHeight) {
                            ++this.indexYear;
                            ++this.centerYear;
                        }
                        this.buildRegion();
                        this.computeDate();
                        this.smoothScrollTo(this.width * this.indexMonth, this.height * this.indexYear);
                        this.lastMoveY = this.height * this.indexYear;
                        break;
                    }
                    this.defineRegion((int)event.getX(), (int)event.getY());
                    break;
                }
                if (this.mSlideMode == SlideMode.HOR) {
                    if (Math.abs((float)this.lastPointX - event.getX()) > 25.0f) {
                        if ((float)this.lastPointX > event.getX() && Math.abs((float)this.lastPointX - event.getX()) >= (float)this.criticalWidth) {
                            ++this.indexMonth;
                            this.centerMonth = (this.centerMonth + 1) % 13;
                            if (this.centerMonth == 0) {
                                this.centerMonth = 1;
                                ++this.centerYear;
                            }
                        } else if ((float)this.lastPointX < event.getX() && Math.abs((float)this.lastPointX - event.getX()) >= (float)this.criticalWidth) {
                            --this.indexMonth;
                            this.centerMonth = (this.centerMonth - 1) % 12;
                            if (this.centerMonth == 0) {
                                this.centerMonth = 12;
                                --this.centerYear;
                            }
                        }
                        this.buildRegion();
                        this.computeDate();
                        this.smoothScrollTo(this.width * this.indexMonth, this.indexYear * this.height);
                        this.lastMoveX = this.width * this.indexMonth;
                        break;
                    }
                    this.defineRegion((int)event.getX(), (int)event.getY());
                    break;
                }
                this.defineRegion((int)event.getX(), (int)event.getY());
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(measureWidth, (int)((float)measureWidth * 6.0f / 7.0f));
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        Region region;
        int j;
        int i;
        this.width = w;
        this.height = h;
        this.criticalWidth = (int)(0.2f * (float)this.width);
        this.criticalHeight = (int)(0.2f * (float)this.height);
        int cellW = (int)((float)w / 7.0f);
        int cellH4 = (int)((float)h / 4.0f);
        int cellH5 = (int)((float)h / 5.0f);
        int cellH6 = (int)((float)h / 6.0f);
        this.circleRadius = cellW;
        this.animZoomOut1 = (int)((float)cellW * 1.2f);
        this.animZoomIn1 = (int)((float)cellW * 0.8f);
        this.animZoomOut2 = (int)((float)cellW * 1.1f);
        this.sizeDecor = (int)((float)cellW / 3.0f);
        this.sizeDecor2x = this.sizeDecor * 2;
        this.sizeDecor3x = this.sizeDecor * 3;
        this.sizeTextGregorian = (float)this.width / 20.0f;
        this.mPaint.setTextSize(this.sizeTextGregorian);
        float heightGregorian = this.mPaint.getFontMetrics().bottom - this.mPaint.getFontMetrics().top;
        this.sizeTextFestival = (float)this.width / 40.0f;
        this.mPaint.setTextSize(this.sizeTextFestival);
        float heightFestival = this.mPaint.getFontMetrics().bottom - this.mPaint.getFontMetrics().top;
        this.offsetYFestival1 = (Math.abs(this.mPaint.ascent() + this.mPaint.descent()) / 2.0f + heightFestival / 2.0f + heightGregorian / 2.0f) / 2.0f;
        this.offsetYFestival2 = this.offsetYFestival1 * 2.0f;
        for (i = 0; i < this.MONTH_REGIONS_4.length; ++i) {
            for (j = 0; j < this.MONTH_REGIONS_4[i].length; ++j) {
                region = new Region();
                region.set(j * cellW, i * cellH4, cellW + j * cellW, cellW + i * cellH4);
                this.MONTH_REGIONS_4[i][j] = region;
            }
        }
        for (i = 0; i < this.MONTH_REGIONS_5.length; ++i) {
            for (j = 0; j < this.MONTH_REGIONS_5[i].length; ++j) {
                region = new Region();
                region.set(j * cellW, i * cellH5, cellW + j * cellW, cellW + i * cellH5);
                this.MONTH_REGIONS_5[i][j] = region;
            }
        }
        for (i = 0; i < this.MONTH_REGIONS_6.length; ++i) {
            for (j = 0; j < this.MONTH_REGIONS_6[i].length; ++j) {
                region = new Region();
                region.set(j * cellW, i * cellH6, cellW + j * cellW, cellW + i * cellH6);
                this.MONTH_REGIONS_6[i][j] = region;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(this.mTManager.colorBG());
        this.draw(canvas, this.width * this.indexMonth, (this.indexYear - 1) * this.height, this.topYear, this.topMonth);
        this.draw(canvas, this.width * (this.indexMonth - 1), this.height * this.indexYear, this.leftYear, this.leftMonth);
        this.draw(canvas, this.width * this.indexMonth, this.indexYear * this.height, this.centerYear, this.centerMonth);
        this.draw(canvas, this.width * (this.indexMonth + 1), this.height * this.indexYear, this.rightYear, this.rightMonth);
        this.draw(canvas, this.width * this.indexMonth, (this.indexYear + 1) * this.height, this.bottomYear, this.bottomMonth);
        this.drawBGCircle(canvas);
    }

    private void drawBGCircle(Canvas canvas) {
        BGCircle circle;
        if (Build.VERSION.SDK_INT >= 11) {
            for (String s : this.cirDpr.keySet()) {
                circle = this.cirDpr.get(s);
                this.drawBGCircle(canvas, circle);
            }
        }
        for (String s : this.cirApr.keySet()) {
            circle = this.cirApr.get(s);
            this.drawBGCircle(canvas, circle);
        }
    }

    private void drawBGCircle(Canvas canvas, BGCircle circle) {
        canvas.save();
        canvas.translate(circle.getX() - (float)(circle.getRadius() / 2), circle.getY() - (float)(circle.getRadius() / 2));
        circle.getShape().getShape().resize((float)circle.getRadius(), (float)circle.getRadius());
        circle.getShape().draw(canvas);
        canvas.restore();
    }

    private void draw(Canvas canvas, int x, int y, int year, int month) {
        DPInfo[][] result;
        Region[][] tmp;
        canvas.save();
        canvas.translate((float)x, (float)y);
        DPInfo[][] info = this.mCManager.obtainDPInfo(year, month);
        if (TextUtils.isEmpty((CharSequence)info[4][0].strG)) {
            tmp = this.MONTH_REGIONS_4;
            this.arrayClear(this.INFO_4);
            result = this.arrayCopy(info, this.INFO_4);
        } else if (TextUtils.isEmpty((CharSequence)info[5][0].strG)) {
            tmp = this.MONTH_REGIONS_5;
            this.arrayClear(this.INFO_5);
            result = this.arrayCopy(info, this.INFO_5);
        } else {
            tmp = this.MONTH_REGIONS_6;
            this.arrayClear(this.INFO_6);
            result = this.arrayCopy(info, this.INFO_6);
        }
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                this.draw(canvas, tmp[i][j].getBounds(), info[i][j]);
            }
        }
        canvas.restore();
    }

    private void draw(Canvas canvas, Rect rect, DPInfo info) {
        this.drawBG(canvas, rect, info);
        this.drawGregorian(canvas, rect, info.strG, info.isWeekend);
        if (this.isFestivalDisplay) {
            this.drawFestival(canvas, rect, info.strF, info.isFestival);
        }
        this.drawDecor(canvas, rect, info);
    }

    private void drawBG(Canvas canvas, Rect rect, DPInfo info) {
        if (null != this.mDPDecor && info.isDecorBG) {
            this.mDPDecor.drawDecorBG(canvas, rect, this.mPaint, this.centerYear + "-" + this.centerMonth + "-" + info.strG);
        }
        if (info.isToday && this.isTodayDisplay) {
            this.drawBGToday(canvas, rect);
        } else {
            if (this.isHolidayDisplay) {
                this.drawBGHoliday(canvas, rect, info.isHoliday);
            }
            if (this.isDeferredDisplay) {
                this.drawBGDeferred(canvas, rect, info.isDeferred);
            }
        }
    }

    private void drawBGToday(Canvas canvas, Rect rect) {
        this.mPaint.setColor(this.mTManager.colorToday());
        canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), (float)this.circleRadius / 2.0f, this.mPaint);
    }

    private void drawBGHoliday(Canvas canvas, Rect rect, boolean isHoliday) {
        this.mPaint.setColor(this.mTManager.colorHoliday());
        if (isHoliday) {
            canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), (float)this.circleRadius / 2.0f, this.mPaint);
        }
    }

    private void drawBGDeferred(Canvas canvas, Rect rect, boolean isDeferred) {
        this.mPaint.setColor(this.mTManager.colorDeferred());
        if (isDeferred) {
            canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), (float)this.circleRadius / 2.0f, this.mPaint);
        }
    }

    private void drawGregorian(Canvas canvas, Rect rect, String str, boolean isWeekend) {
        this.mPaint.setTextSize(this.sizeTextGregorian);
        if (isWeekend) {
            this.mPaint.setColor(this.mTManager.colorWeekend());
        } else {
            this.mPaint.setColor(this.mTManager.colorG());
        }
        float y = rect.centerY();
        if (!this.isFestivalDisplay) {
            y = (float)rect.centerY() + Math.abs(this.mPaint.ascent()) - (this.mPaint.descent() - this.mPaint.ascent()) / 2.0f;
        }
        canvas.drawText(str, (float)rect.centerX(), y, this.mPaint);
    }

    private void drawFestival(Canvas canvas, Rect rect, String str, boolean isFestival) {
        this.mPaint.setTextSize(this.sizeTextFestival);
        if (isFestival) {
            this.mPaint.setColor(this.mTManager.colorF());
        } else {
            this.mPaint.setColor(this.mTManager.colorL());
        }
        if (str.contains("&")) {
            String[] s = str.split("&");
            String str1 = s[0];
            if (this.mPaint.measureText(str1) > (float)rect.width()) {
                float ch = this.mPaint.measureText(str1, 0, 1);
                int length = (int)((float)rect.width() / ch);
                canvas.drawText(str1.substring(0, length), (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival1, this.mPaint);
                canvas.drawText(str1.substring(length), (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival2, this.mPaint);
            } else {
                canvas.drawText(str1, (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival1, this.mPaint);
                String str2 = s[1];
                if (this.mPaint.measureText(str2) < (float)rect.width()) {
                    canvas.drawText(str2, (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival2, this.mPaint);
                }
            }
        } else if (this.mPaint.measureText(str) > (float)rect.width()) {
            float ch = 0.0f;
            for (char c : str.toCharArray()) {
                float tmp = this.mPaint.measureText(String.valueOf(c));
                if (!(tmp > ch)) continue;
                ch = tmp;
            }
            int length = (int)((float)rect.width() / ch);
            canvas.drawText(str.substring(0, length), (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival1, this.mPaint);
            canvas.drawText(str.substring(length), (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival2, this.mPaint);
        } else {
            canvas.drawText(str, (float)rect.centerX(), (float)rect.centerY() + this.offsetYFestival1, this.mPaint);
        }
    }

    private void drawDecor(Canvas canvas, Rect rect, DPInfo info) {
        if (!TextUtils.isEmpty((CharSequence)info.strG)) {
            String data = this.centerYear + "-" + this.centerMonth + "-" + info.strG;
            if (null != this.mDPDecor && info.isDecorTL) {
                canvas.save();
                canvas.clipRect(rect.left, rect.top, rect.left + this.sizeDecor, rect.top + this.sizeDecor);
                this.mDPDecor.drawDecorTL(canvas, canvas.getClipBounds(), this.mPaint, data);
                canvas.restore();
            }
            if (null != this.mDPDecor && info.isDecorT) {
                canvas.save();
                canvas.clipRect(rect.left + this.sizeDecor, rect.top, rect.left + this.sizeDecor2x, rect.top + this.sizeDecor);
                this.mDPDecor.drawDecorT(canvas, canvas.getClipBounds(), this.mPaint, data);
                canvas.restore();
            }
            if (null != this.mDPDecor && info.isDecorTR) {
                canvas.save();
                canvas.clipRect(rect.left + this.sizeDecor2x, rect.top, rect.left + this.sizeDecor3x, rect.top + this.sizeDecor);
                this.mDPDecor.drawDecorTR(canvas, canvas.getClipBounds(), this.mPaint, data);
                canvas.restore();
            }
            if (null != this.mDPDecor && info.isDecorL) {
                canvas.save();
                canvas.clipRect(rect.left, rect.top + this.sizeDecor, rect.left + this.sizeDecor, rect.top + this.sizeDecor2x);
                this.mDPDecor.drawDecorL(canvas, canvas.getClipBounds(), this.mPaint, data);
                canvas.restore();
            }
            if (null != this.mDPDecor && info.isDecorR) {
                canvas.save();
                canvas.clipRect(rect.left + this.sizeDecor2x, rect.top + this.sizeDecor, rect.left + this.sizeDecor3x, rect.top + this.sizeDecor2x);
                this.mDPDecor.drawDecorR(canvas, canvas.getClipBounds(), this.mPaint, data);
                canvas.restore();
            }
        }
    }

    List<String> getDateSelected() {
        return this.dateSelected;
    }

    void setOnDateChangeListener(OnDateChangeListener onDateChangeListener) {
        this.onDateChangeListener = onDateChangeListener;
    }

    public void setOnDatePickedListener(DatePicker.OnDatePickedListener onDatePickedListener) {
        this.onDatePickedListener = onDatePickedListener;
    }

    void setDPMode(DPMode mode) {
        this.mDPMode = mode;
    }

    void setDPDecor(DPDecor decor) {
        this.mDPDecor = decor;
    }

    DPMode getDPMode() {
        return this.mDPMode;
    }

    void setDate(int year, int month) {
        this.centerYear = year;
        this.centerMonth = month;
        this.indexYear = 0;
        this.indexMonth = 0;
        this.buildRegion();
        this.computeDate();
        this.requestLayout();
        this.invalidate();
    }

    void setFestivalDisplay(boolean isFestivalDisplay) {
        this.isFestivalDisplay = isFestivalDisplay;
    }

    void setTodayDisplay(boolean isTodayDisplay) {
        this.isTodayDisplay = isTodayDisplay;
    }

    void setHolidayDisplay(boolean isHolidayDisplay) {
        this.isHolidayDisplay = isHolidayDisplay;
    }

    void setDeferredDisplay(boolean isDeferredDisplay) {
        this.isDeferredDisplay = isDeferredDisplay;
    }

    private void smoothScrollTo(int fx, int fy) {
        int dx = fx - this.mScroller.getFinalX();
        int dy = fy - this.mScroller.getFinalY();
        this.smoothScrollBy(dx, dy);
    }

    private void smoothScrollBy(int dx, int dy) {
        this.mScroller.startScroll(this.mScroller.getFinalX(), this.mScroller.getFinalY(), dx, dy, 500);
        this.invalidate();
    }

    private BGCircle createCircle(float x, float y) {
        OvalShape circle = new OvalShape();
        circle.resize(0.0f, 0.0f);
        ShapeDrawable drawable = new ShapeDrawable((Shape)circle);
        BGCircle circle1 = new BGCircle(drawable);
        circle1.setX(x);
        circle1.setY(y);
        if (Build.VERSION.SDK_INT < 11) {
            circle1.setRadius(this.circleRadius);
        }
        drawable.getPaint().setColor(this.mTManager.colorBGCircle());
        return circle1;
    }

    private void buildRegion() {
        String key = this.indexYear + ":" + this.indexMonth;
        if (!this.REGION_SELECTED.containsKey(key)) {
            this.REGION_SELECTED.put(key, new ArrayList());
        }
    }

    private void arrayClear(DPInfo[][] info) {
        for (Object[] objectArray : info) {
            Arrays.fill(objectArray, null);
        }
    }

    private DPInfo[][] arrayCopy(DPInfo[][] src, DPInfo[][] dst) {
        for (int i = 0; i < dst.length; ++i) {
            System.arraycopy(src[i], 0, dst[i], 0, dst[i].length);
        }
        return dst;
    }

    private void defineRegion(int x, int y) {
        DPInfo[][] info = this.mCManager.obtainDPInfo(this.centerYear, this.centerMonth);
        Region[][] tmp = TextUtils.isEmpty((CharSequence)info[4][0].strG) ? this.MONTH_REGIONS_4 : (TextUtils.isEmpty((CharSequence)info[5][0].strG) ? this.MONTH_REGIONS_5 : this.MONTH_REGIONS_6);
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[i].length; ++j) {
                AnimatorSet animSet;
                ObjectAnimator animScale4;
                ObjectAnimator animScale3;
                ObjectAnimator animScale2;
                ObjectAnimator animScale1;
                BGCircle circle;
                String date;
                Region region = tmp[i][j];
                if (TextUtils.isEmpty((CharSequence)this.mCManager.obtainDPInfo((int)this.centerYear, (int)this.centerMonth)[i][j].strG) || !region.contains(x, y)) continue;
                List<Region> regions = this.REGION_SELECTED.get(this.indexYear + ":" + this.indexMonth);
                if (this.mDPMode == DPMode.SINGLE) {
                    this.cirApr.clear();
                    regions.add(region);
                    date = this.centerYear + "-" + this.centerMonth + "-" + this.mCManager.obtainDPInfo((int)this.centerYear, (int)this.centerMonth)[i][j].strG;
                    circle = this.createCircle(region.getBounds().centerX() + this.indexMonth * this.width, region.getBounds().centerY() + this.indexYear * this.height);
                    if (Build.VERSION.SDK_INT >= 11) {
                        animScale1 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{0, this.animZoomOut1});
                        animScale1.setDuration(250L);
                        animScale1.setInterpolator((TimeInterpolator)this.decelerateInterpolator);
                        animScale1.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale2 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut1, this.animZoomIn1});
                        animScale2.setDuration(100L);
                        animScale2.setInterpolator((TimeInterpolator)this.accelerateInterpolator);
                        animScale2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale3 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomIn1, this.animZoomOut2});
                        animScale3.setDuration(150L);
                        animScale3.setInterpolator((TimeInterpolator)this.decelerateInterpolator);
                        animScale3.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale4 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut2, this.circleRadius});
                        animScale4.setDuration(50L);
                        animScale4.setInterpolator((TimeInterpolator)this.accelerateInterpolator);
                        animScale4.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animSet = new AnimatorSet();
                        animSet.playSequentially(new Animator[]{animScale1, animScale2, animScale3, animScale4});
                        animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                if (null != MonthView.this.onDatePickedListener) {
                                    MonthView.this.onDatePickedListener.onDatePicked(date);
                                }
                            }
                        });
                        animSet.start();
                    }
                    this.cirApr.put(date, circle);
                    if (Build.VERSION.SDK_INT >= 11) continue;
                    this.invalidate();
                    if (null == this.onDatePickedListener) continue;
                    this.onDatePickedListener.onDatePicked(date);
                    continue;
                }
                if (this.mDPMode == DPMode.MULTIPLE) {
                    if (regions.contains(region)) {
                        regions.remove(region);
                    } else {
                        regions.add(region);
                    }
                    date = this.centerYear + "-" + this.centerMonth + "-" + this.mCManager.obtainDPInfo((int)this.centerYear, (int)this.centerMonth)[i][j].strG;
                    if (this.dateSelected.contains(date)) {
                        this.dateSelected.remove(date);
                        circle = this.cirApr.get(date);
                        if (Build.VERSION.SDK_INT >= 11) {
                            ObjectAnimator animScale = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.circleRadius, 0});
                            animScale.setDuration(250L);
                            animScale.setInterpolator((TimeInterpolator)this.accelerateInterpolator);
                            animScale.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                            animScale.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    MonthView.this.cirDpr.remove(date);
                                }
                            });
                            animScale.start();
                            this.cirDpr.put(date, circle);
                        }
                        this.cirApr.remove(date);
                        if (Build.VERSION.SDK_INT >= 11) continue;
                        this.invalidate();
                        continue;
                    }
                    this.dateSelected.add(date);
                    circle = this.createCircle(region.getBounds().centerX() + this.indexMonth * this.width, region.getBounds().centerY() + this.indexYear * this.height);
                    if (Build.VERSION.SDK_INT >= 11) {
                        animScale1 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{0, this.animZoomOut1});
                        animScale1.setDuration(250L);
                        animScale1.setInterpolator((TimeInterpolator)this.decelerateInterpolator);
                        animScale1.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale2 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut1, this.animZoomIn1});
                        animScale2.setDuration(100L);
                        animScale2.setInterpolator((TimeInterpolator)this.accelerateInterpolator);
                        animScale2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale3 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomIn1, this.animZoomOut2});
                        animScale3.setDuration(150L);
                        animScale3.setInterpolator((TimeInterpolator)this.decelerateInterpolator);
                        animScale3.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animScale4 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut2, this.circleRadius});
                        animScale4.setDuration(50L);
                        animScale4.setInterpolator((TimeInterpolator)this.accelerateInterpolator);
                        animScale4.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.scaleAnimationListener);
                        animSet = new AnimatorSet();
                        animSet.playSequentially(new Animator[]{animScale1, animScale2, animScale3, animScale4});
                        animSet.start();
                    }
                    this.cirApr.put(date, circle);
                    if (Build.VERSION.SDK_INT >= 11) continue;
                    this.invalidate();
                    continue;
                }
                if (this.mDPMode != DPMode.NONE) continue;
                if (regions.contains(region)) {
                    regions.remove(region);
                } else {
                    regions.add(region);
                }
                date = this.centerYear + "-" + this.centerMonth + "-" + this.mCManager.obtainDPInfo((int)this.centerYear, (int)this.centerMonth)[i][j].strG;
                if (this.dateSelected.contains(date)) {
                    this.dateSelected.remove(date);
                    continue;
                }
                this.dateSelected.add(date);
            }
        }
    }

    private void computeDate() {
        this.rightYear = this.leftYear = this.centerYear;
        this.topYear = this.centerYear - 1;
        this.bottomYear = this.centerYear + 1;
        this.topMonth = this.centerMonth;
        this.bottomMonth = this.centerMonth;
        this.rightMonth = this.centerMonth + 1;
        this.leftMonth = this.centerMonth - 1;
        if (this.centerMonth == 12) {
            ++this.rightYear;
            this.rightMonth = 1;
        }
        if (this.centerMonth == 1) {
            --this.leftYear;
            this.leftMonth = 12;
        }
        if (null != this.onDateChangeListener) {
            this.onDateChangeListener.onYearChange(this.centerYear);
            this.onDateChangeListener.onMonthChange(this.centerMonth);
        }
    }

    @TargetApi(value=11)
    private class ScaleAnimationListener
    implements ValueAnimator.AnimatorUpdateListener {
        private ScaleAnimationListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            MonthView.this.invalidate();
        }
    }

    private class BGCircle {
        private float x;
        private float y;
        private int radius;
        private ShapeDrawable shape;

        public BGCircle(ShapeDrawable shape) {
            this.shape = shape;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public ShapeDrawable getShape() {
            return this.shape;
        }

        public void setShape(ShapeDrawable shape) {
            this.shape = shape;
        }
    }

    private static enum SlideMode {
        VER,
        HOR;

    }

    static interface OnDateChangeListener {
        public void onMonthChange(int var1);

        public void onYearChange(int var1);
    }
}

