/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.bizs.calendars;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public abstract class DPCalendar {
    protected final Calendar c = Calendar.getInstance();

    public abstract String[][] buildMonthFestival(int var1, int var2);

    public abstract Set<String> buildMonthHoliday(int var1, int var2);

    public boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public boolean isToday(int year, int month, int day) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.set(year, month, day);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) + 1 && c1.get(5) == c2.get(5);
    }

    public String[][] buildMonthG(int year, int month) {
        this.c.clear();
        String[][] tmp = new String[6][7];
        this.c.set(year, month - 1, 1);
        int daysInMonth = 0;
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            daysInMonth = 31;
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            daysInMonth = 30;
        } else if (month == 2) {
            daysInMonth = this.isLeapYear(year) ? 29 : 28;
        }
        int dayOfWeek = this.c.get(7) - 1;
        int day = 1;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                tmp[i][j] = "";
                if (i == 0 && j >= dayOfWeek) {
                    tmp[i][j] = "" + day;
                    ++day;
                    continue;
                }
                if (i <= 0 || day > daysInMonth) continue;
                tmp[i][j] = "" + day;
                ++day;
            }
        }
        return tmp;
    }

    public Set<String> buildMonthWeekend(int year, int month) {
        HashSet<String> set = new HashSet<String>();
        this.c.clear();
        this.c.set(year, month - 1, 1);
        do {
            int day;
            if ((day = this.c.get(7)) == 7 || day == 1) {
                set.add(String.valueOf(this.c.get(5)));
            }
            this.c.add(6, 1);
        } while (this.c.get(2) == month - 1);
        return set;
    }

    protected long GToNum(int year, int month, int day) {
        month = (month + 9) % 12;
        return 365 * (year -= month / 10) + year / 4 - year / 100 + year / 400 + (month * 306 + 5) / 10 + (day - 1);
    }

    protected int getBitInt(int data, int length, int shift) {
        return (data & (1 << length) - 1 << shift) >> shift;
    }
}

