/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Region;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;

public class YearView
extends View {
    private static final String[][] MONTHS = new String[][]{{"1", "2", "3", "4"}, {"5", "6", "7", "8"}, {"9", "10", "11", "12"}};
    private TextPaint mTextPaint;
    private int sizeBase;
    private int textSizeMonth;
    private Region[][] mRegion = new Region[3][4];

    public YearView(Context context) {
        this(context, null);
    }

    public YearView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YearView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mTextPaint = new TextPaint(69);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(width, (int)((float)width * 3.0f / 4.0f));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.sizeBase = w;
        this.textSizeMonth = (int)((float)this.sizeBase / 10.0f);
        this.mTextPaint.setTextSize((float)this.textSizeMonth);
        int sizeCell = (int)((float)this.sizeBase / 4.0f);
        for (int i = 0; i < this.mRegion.length; ++i) {
            for (int j = 0; j < this.mRegion[i].length; ++j) {
                Region region = new Region();
                region.set(j * sizeCell, i * sizeCell, sizeCell + j * sizeCell, sizeCell + i * sizeCell);
                this.mRegion[i][j] = region;
            }
        }
        this.requestLayout();
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0; i < this.mRegion.length; ++i) {
            for (int j = 0; j < this.mRegion[i].length; ++j) {
                canvas.drawText(MONTHS[i][j], (float)this.mRegion[i][j].getBounds().centerX(), (float)this.mRegion[i][j].getBounds().centerY(), (Paint)this.mTextPaint);
            }
        }
    }
}

