/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.aigestudio.datepicker.entities.Language;
import cn.aigestudio.datepicker.interfaces.OnDateSelected;
import cn.aigestudio.datepicker.views.MonthView;

public class TitleView
extends LinearLayout
implements MonthView.OnPageChangeListener,
MonthView.OnSizeChangedListener {
    private String[] monthTitles;
    private TextView tvYear;
    private TextView tvMonth;
    private TextView tvConfirm;
    private OnDateSelected mOnDateSelected;
    private MonthView monthView;

    public TitleView(Context context) {
        super(context);
        this.setColor(-1486012);
        this.setOrientation(0);
        this.monthTitles = Language.getLanguage(context).monthTitles();
        LinearLayout.LayoutParams llParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
        this.tvYear = new TextView(context);
        this.tvYear.setGravity(8388627);
        this.tvYear.setTextColor(-1);
        this.tvMonth = new TextView(context);
        this.tvMonth.setGravity(17);
        this.tvMonth.setTextColor(-1);
        this.tvConfirm = new TextView(context);
        this.tvConfirm.setGravity(8388629);
        this.tvConfirm.setText((CharSequence)Language.getLanguage(context).ensureTitle());
        this.tvConfirm.setTextColor(-1);
        this.tvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != TitleView.this.mOnDateSelected && null != TitleView.this.monthView) {
                    TitleView.this.mOnDateSelected.selected(TitleView.this.monthView.getDateSelected());
                }
            }
        });
        this.addView((View)this.tvYear, (ViewGroup.LayoutParams)llParams);
        this.addView((View)this.tvMonth, (ViewGroup.LayoutParams)llParams);
        this.addView((View)this.tvConfirm, (ViewGroup.LayoutParams)llParams);
    }

    public void setOnDateSelected(OnDateSelected onDateSelected, MonthView monthView) {
        this.mOnDateSelected = onDateSelected;
        this.monthView = monthView;
    }

    public void setColor(int color) {
        this.setBackgroundColor(color);
    }

    @Override
    public void onMonthChange(int month) {
        this.tvMonth.setText((CharSequence)this.monthTitles[month - 1]);
    }

    @Override
    public void onYearChange(int year) {
        this.tvYear.setText((CharSequence)String.valueOf(year));
    }

    @Override
    public void onSizeChanged(int size) {
        int padding = (int)((float)size * 1.0f / 50.0f);
        int textSizeSmall = (int)((float)size * 1.0f / 25.0f);
        int textSizeLarge = (int)((float)size * 1.0f / 18.0f);
        this.tvYear.setPadding(padding, padding, 0, padding);
        this.tvYear.getPaint().setTextSize((float)textSizeSmall);
        this.tvMonth.setPadding(0, padding, 0, padding);
        this.tvMonth.getPaint().setTextSize((float)textSizeLarge);
        this.tvConfirm.setPadding(0, padding, padding, padding);
        this.tvConfirm.getPaint().setTextSize((float)textSizeSmall);
    }
}

