/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Region;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.Scroller;
import cn.aigestudio.datepicker.bizs.CalendarBiz;
import cn.aigestudio.datepicker.entities.BGCircle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonthView
extends View
implements ValueAnimator.AnimatorUpdateListener {
    private Paint mPaint;
    private TextPaint mTextPaint;
    private Scroller mScroller;
    private CalendarBiz mCalendarBiz;
    private OnPageChangeListener onPageChangeListener;
    private OnSizeChangedListener onSizeChangedListener;
    private int sizeBase;
    private int lastPointX;
    private int lastMoveX;
    private int width;
    private int height;
    private int criticalWidth;
    private int index;
    private int lastMonth;
    private int currentMonth;
    private int nextMonth;
    private int lastYear;
    private int currentYear;
    private int nextYear;
    private int animZoomOut1;
    private int animZoomIn1;
    private int animZoomOut2;
    private int circleRadius;
    private int colorMain = -1486012;
    private float textSizeGregorian;
    private float textSizeLunar;
    private float offsetYLunar;
    private boolean isLunarShow = true;
    private EventType mEventType;
    private Map<Integer, List<Region>> calendarRegion = new HashMap<Integer, List<Region>>();
    private Region[][] mRegion = new Region[6][7];
    private Map<String, BGCircle> circlesAppear = new HashMap<String, BGCircle>();
    private Map<String, BGCircle> circlesDisappear = new HashMap<String, BGCircle>();
    private List<String> dateSelected = new ArrayList<String>();

    public MonthView(Context context) {
        this(context, null);
    }

    public MonthView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint(5);
        this.mTextPaint = new TextPaint(261);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mScroller = new Scroller(context);
        Calendar calendar = Calendar.getInstance();
        this.currentYear = calendar.get(1);
        this.currentMonth = calendar.get(2) + 1;
        this.computeDate();
        this.mCalendarBiz = new CalendarBiz(this.index, this.currentYear, this.currentMonth);
        this.buildCalendarRegion();
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
        if (null != this.onPageChangeListener) {
            this.onPageChangeListener.onYearChange(this.currentYear);
            this.onPageChangeListener.onMonthChange(this.currentMonth);
        }
    }

    public void setOnSizeChangedListener(OnSizeChangedListener onSizeChangedListener) {
        this.onSizeChangedListener = onSizeChangedListener;
    }

    public List<String> getDateSelected() {
        return this.dateSelected;
    }

    public void setLunarShow(boolean isLunarShow) {
        this.isLunarShow = isLunarShow;
        this.invalidate();
    }

    public void setColorMain(int colorMain) {
        this.colorMain = colorMain;
        this.invalidate();
    }

    private void computeDate() {
        this.nextYear = this.lastYear = this.currentYear;
        this.nextMonth = this.currentMonth + 1;
        this.lastMonth = this.currentMonth - 1;
        if (null != this.onPageChangeListener) {
            this.onPageChangeListener.onYearChange(this.currentYear);
        }
        if (this.currentMonth == 12) {
            ++this.nextYear;
            this.mCalendarBiz.buildSolarTerm(this.nextYear);
            if (null != this.onPageChangeListener) {
                this.onPageChangeListener.onYearChange(this.nextYear);
            }
            this.nextMonth = 1;
        }
        if (this.currentMonth == 1) {
            --this.lastYear;
            this.mCalendarBiz.buildSolarTerm(this.lastYear);
            if (null != this.onPageChangeListener) {
                this.onPageChangeListener.onYearChange(this.lastYear);
            }
            this.lastMonth = 12;
        }
    }

    private void buildCalendarRegion() {
        if (!this.calendarRegion.containsKey(this.index)) {
            ArrayList regions = new ArrayList();
            this.calendarRegion.put(this.index, regions);
        }
    }

    private String[][] gregorianToLunar(String[][] gregorian, int year, int month) {
        String[][] lunar = new String[6][7];
        for (int i = 0; i < gregorian.length; ++i) {
            for (int j = 0; j < gregorian[i].length; ++j) {
                String str = gregorian[i][j];
                str = null == str ? "" : this.mCalendarBiz.gregorianToLunar(year, month, Integer.valueOf(str));
                lunar[i][j] = str;
            }
        }
        return lunar;
    }

    private BGCircle createCircle(float x, float y) {
        OvalShape circle = new OvalShape();
        circle.resize(0.0f, 0.0f);
        ShapeDrawable drawable = new ShapeDrawable((Shape)circle);
        BGCircle circle1 = new BGCircle(drawable);
        circle1.setX(x);
        circle1.setY(y);
        drawable.getPaint().setColor(-2302756);
        return circle1;
    }

    private void defineContainRegion(int x, int y) {
        for (int i = 0; i < this.mRegion.length; ++i) {
            for (int j = 0; j < this.mRegion[i].length; ++j) {
                BGCircle circle;
                Region region = this.mRegion[i][j];
                if (null == this.mCalendarBiz.getGregorianCreated().get(this.index)[i][j] || !region.contains(x, y)) continue;
                List<Region> regions = this.calendarRegion.get(this.index);
                if (regions.contains(region)) {
                    regions.remove(region);
                } else {
                    regions.add(region);
                }
                final String date = this.currentYear + "-" + this.currentMonth + "-" + this.mCalendarBiz.getGregorianCreated().get(this.index)[i][j];
                if (this.dateSelected.contains(date)) {
                    this.dateSelected.remove(date);
                    circle = this.circlesAppear.get(date);
                    ObjectAnimator animScale = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.circleRadius, 0});
                    animScale.setDuration(250L);
                    animScale.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                    animScale.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                    animScale.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            MonthView.this.circlesDisappear.remove(date);
                        }
                    });
                    animScale.start();
                    this.circlesDisappear.put(date, circle);
                    this.circlesAppear.remove(date);
                    continue;
                }
                this.dateSelected.add(date);
                circle = this.createCircle(region.getBounds().centerX() + this.index * this.sizeBase, region.getBounds().centerY());
                ObjectAnimator animScale1 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{0, this.animZoomOut1});
                animScale1.setDuration(250L);
                animScale1.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                animScale1.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                ObjectAnimator animScale2 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut1, this.animZoomIn1});
                animScale2.setDuration(100L);
                animScale2.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                animScale2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                ObjectAnimator animScale3 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomIn1, this.animZoomOut2});
                animScale3.setDuration(150L);
                animScale3.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                animScale3.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                ObjectAnimator animScale4 = ObjectAnimator.ofInt((Object)circle, (String)"radius", (int[])new int[]{this.animZoomOut2, this.circleRadius});
                animScale4.setDuration(50L);
                animScale4.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                animScale4.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
                AnimatorSet animSet = new AnimatorSet();
                animSet.playSequentially(new Animator[]{animScale1, animScale2, animScale3, animScale4});
                animSet.start();
                this.circlesAppear.put(date, circle);
            }
        }
    }

    public void smoothScrollTo(int fx, int fy) {
        int dx = fx - this.mScroller.getFinalX();
        int dy = fy - this.mScroller.getFinalY();
        this.smoothScrollBy(dx, dy);
    }

    private void smoothScrollBy(int dx, int dy) {
        this.mScroller.startScroll(this.mScroller.getFinalX(), this.mScroller.getFinalY(), dx, dy, 500);
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.lastPointX = (int)event.getX();
                break;
            }
            case 2: {
                int totalMoveX = (int)((float)this.lastPointX - event.getX()) + this.lastMoveX;
                this.smoothScrollTo(totalMoveX, 0);
                break;
            }
            case 1: {
                if (Math.abs((float)this.lastPointX - event.getX()) > 10.0f) {
                    if ((float)this.lastPointX > event.getX()) {
                        if (Math.abs((float)this.lastPointX - event.getX()) >= (float)this.criticalWidth) {
                            ++this.index;
                            this.currentMonth = (this.currentMonth + 1) % 13;
                            if (this.currentMonth == 0) {
                                this.currentMonth = 1;
                                ++this.currentYear;
                                this.mCalendarBiz.buildSolarTerm(this.currentYear);
                            }
                            this.computeDate();
                            if (null != this.onPageChangeListener) {
                                this.onPageChangeListener.onMonthChange(this.currentMonth);
                                this.onPageChangeListener.onYearChange(this.currentYear);
                            }
                            this.buildCalendarRegion();
                        }
                        this.smoothScrollTo(this.width * this.index, 0);
                        this.lastMoveX = this.width * this.index;
                        break;
                    }
                    if (!((float)this.lastPointX < event.getX())) break;
                    if (Math.abs((float)this.lastPointX - event.getX()) >= (float)this.criticalWidth) {
                        --this.index;
                        this.currentMonth = (this.currentMonth - 1) % 12;
                        if (this.currentMonth == 0) {
                            this.currentMonth = 12;
                            --this.currentYear;
                            this.mCalendarBiz.buildSolarTerm(this.currentYear);
                        }
                        this.computeDate();
                        if (null != this.onPageChangeListener) {
                            this.onPageChangeListener.onMonthChange(this.currentMonth);
                            this.onPageChangeListener.onYearChange(this.currentYear);
                        }
                        this.buildCalendarRegion();
                    }
                    this.smoothScrollTo(this.width * this.index, 0);
                    this.lastMoveX = this.width * this.index;
                    break;
                }
                this.defineContainRegion((int)event.getX(), (int)event.getY());
            }
        }
        return true;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.invalidate();
        } else {
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        String[][] currentGregorian = this.mCalendarBiz.getGregorianCreated().get(this.index);
        if (null == currentGregorian[4][0]) {
            this.setMeasuredDimension(measureWidth, (int)((float)(measureWidth * 4) / 7.0f));
        } else if (null == currentGregorian[5][0]) {
            this.setMeasuredDimension(measureWidth, (int)((float)(measureWidth * 5) / 7.0f));
        } else {
            this.setMeasuredDimension(measureWidth, (int)((float)(measureWidth * 6) / 7.0f));
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int sizeCell;
        this.width = w;
        this.height = h;
        this.criticalWidth = (int)(0.2f * (float)this.width);
        this.sizeBase = this.width;
        if (null != this.onSizeChangedListener) {
            this.onSizeChangedListener.onSizeChanged(this.sizeBase);
        }
        this.circleRadius = sizeCell = (int)((float)this.sizeBase / 7.0f);
        this.animZoomOut1 = (int)((float)sizeCell * 1.2f);
        this.animZoomIn1 = (int)((float)sizeCell * 0.8f);
        this.animZoomOut2 = (int)((float)sizeCell * 1.1f);
        this.textSizeGregorian = (float)this.sizeBase / 20.0f;
        this.mTextPaint.setTextSize(this.textSizeGregorian);
        float gregorianH = this.mTextPaint.getFontMetrics().bottom - this.mTextPaint.getFontMetrics().top;
        this.textSizeLunar = (float)this.sizeBase / 35.0f;
        this.mTextPaint.setTextSize(this.textSizeLunar);
        float lunarH = this.mTextPaint.getFontMetrics().bottom - this.mTextPaint.getFontMetrics().top;
        this.offsetYLunar = (Math.abs(this.mTextPaint.ascent() + this.mTextPaint.descent()) / 2.0f + lunarH / 2.0f + gregorianH / 2.0f) * 3.0f / 4.0f;
        for (int i = 0; i < this.mRegion.length; ++i) {
            for (int j = 0; j < this.mRegion[i].length; ++j) {
                Region region = new Region();
                region.set(j * sizeCell, i * sizeCell, sizeCell + j * sizeCell, sizeCell + i * sizeCell);
                this.mRegion[i][j] = region;
            }
        }
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.drawCircle(canvas);
        this.drawMonths(canvas);
    }

    private void drawCircle(Canvas canvas) {
        BGCircle circle;
        for (String s : this.circlesDisappear.keySet()) {
            circle = this.circlesDisappear.get(s);
            this.drawBGCircle(canvas, circle);
        }
        for (String s : this.circlesAppear.keySet()) {
            circle = this.circlesAppear.get(s);
            this.drawBGCircle(canvas, circle);
        }
    }

    private void drawBGCircle(Canvas canvas, BGCircle circle) {
        canvas.save();
        canvas.translate(circle.getX() - (float)(circle.getRadius() / 2), circle.getY() - (float)(circle.getRadius() / 2));
        circle.getShape().getShape().resize((float)circle.getRadius(), (float)circle.getRadius());
        circle.getShape().draw(canvas);
        canvas.restore();
    }

    private void drawMonths(Canvas canvas) {
        this.drawMonth(canvas, (this.index - 1) * this.sizeBase, this.lastYear, this.lastMonth);
        this.drawMonth(canvas, this.index * this.sizeBase, this.currentYear, this.currentMonth);
        this.drawMonth(canvas, (this.index + 1) * this.sizeBase, this.nextYear, this.nextMonth);
    }

    private void drawMonth(Canvas canvas, float offsetX, int year, int month) {
        canvas.save();
        canvas.translate(offsetX, 0.0f);
        int current = (int)(offsetX / (float)this.sizeBase);
        this.mTextPaint.setTextSize(this.textSizeGregorian);
        this.mTextPaint.setColor(-16777216);
        String[][] gregorianCurrent = this.mCalendarBiz.getGregorianCreated().get(current);
        if (null == gregorianCurrent) {
            gregorianCurrent = this.mCalendarBiz.buildGregorian(year, month);
        }
        for (int i = 0; i < gregorianCurrent.length; ++i) {
            for (int j = 0; j < gregorianCurrent[i].length; ++j) {
                String str = gregorianCurrent[i][j];
                if (null == str) {
                    str = "";
                }
                canvas.drawText(str, (float)this.mRegion[i][j].getBounds().centerX(), (float)this.mRegion[i][j].getBounds().centerY(), (Paint)this.mTextPaint);
            }
        }
        if (this.isLunarShow) {
            String[][] lunarCurrent = this.mCalendarBiz.getLunarCreated().get(current);
            if (null == lunarCurrent) {
                lunarCurrent = this.gregorianToLunar(gregorianCurrent, year, month);
            }
            this.mTextPaint.setTextSize(this.textSizeLunar);
            for (int i = 0; i < lunarCurrent.length; ++i) {
                for (int j = 0; j < lunarCurrent[i].length; ++j) {
                    String str = lunarCurrent[i][j];
                    if (str.contains(" ")) {
                        str.trim();
                        this.mTextPaint.setColor(this.colorMain);
                    } else {
                        this.mTextPaint.setColor(-7829368);
                    }
                    canvas.drawText(str, (float)this.mRegion[i][j].getBounds().centerX(), (float)this.mRegion[i][j].getBounds().centerY() + this.offsetYLunar, (Paint)this.mTextPaint);
                }
            }
            this.mCalendarBiz.getLunarCreated().put(current, lunarCurrent);
        }
        this.mCalendarBiz.getGregorianCreated().put(current, gregorianCurrent);
        canvas.restore();
    }

    public static interface OnSizeChangedListener {
        public void onSizeChanged(int var1);
    }

    public static interface OnPageChangeListener {
        public void onMonthChange(int var1);

        public void onYearChange(int var1);
    }

    private static enum EventType {
        SINGLE,
        MULTIPLE;

    }
}

