/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.aigestudio.datepicker.interfaces.IPick;
import cn.aigestudio.datepicker.interfaces.OnDateSelected;
import cn.aigestudio.datepicker.views.MonthView;
import cn.aigestudio.datepicker.views.TitleView;

public class DatePicker
extends LinearLayout
implements IPick {
    private MonthView monthView;
    private TitleView titleView;

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundColor(-1);
        this.setOrientation(1);
        LinearLayout.LayoutParams llParams = new LinearLayout.LayoutParams(-1, -2);
        this.titleView = new TitleView(context);
        this.addView((View)this.titleView, (ViewGroup.LayoutParams)llParams);
        this.monthView = new MonthView(context);
        this.monthView.setOnPageChangeListener(this.titleView);
        this.monthView.setOnSizeChangedListener(this.titleView);
        this.addView(this.monthView, (ViewGroup.LayoutParams)llParams);
    }

    @Override
    public void setOnDateSelected(OnDateSelected onDateSelected) {
        this.titleView.setOnDateSelected(onDateSelected, this.monthView);
    }

    @Override
    public void setColor(int color) {
        this.titleView.setColor(color);
        this.monthView.setColorMain(color);
    }

    @Override
    public void isLunarDisplay(boolean display) {
        this.monthView.setLunarShow(display);
    }
}

