/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.bizs;

import cn.aigestudio.datepicker.bizs.IBO;
import cn.aigestudio.datepicker.entities.Gregorian;
import cn.aigestudio.datepicker.entities.Lunar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalendarBiz
implements IBO {
    private static final int[] LUNAR_YEAR_INFO = new int[]{1887, 5780, 5802, 19157, 2742, 50359, 1198, 2646, 46378, 7466, 3412, 30122, 5482, 67949, 2396, 5294, 43597, 6732, 6954, 36181, 2772, 4954, 18781, 2396, 54427, 5274, 6730, 47781, 5800, 6868, 21210, 4790, 59703, 2350, 5270, 46667, 3402, 3496, 38325, 1388, 4782, 18735, 2350, 52374, 6804, 7498, 44457, 2906, 1388, 29294, 4700, 63789, 6442, 6804, 56138, 5802, 2772, 38235, 1210, 4698, 22827, 5418, 63125, 3476, 5802, 43701, 2484, 5302, 27223, 2646, 70954, 7466, 3412, 54698, 5482, 2412, 38062, 5294, 2636, 32038, 6954, 60245, 2772, 4826, 43357, 2394, 5274, 39501, 6730, 72357, 5800, 5844, 53978, 4790, 2358, 38039, 5270, 87627, 3402, 3496, 54708, 5484, 4782, 43311, 2350, 3222, 27978, 7498, 68965, 2904, 5484, 45677, 4700, 6444, 39573, 6804, 6986, 19285, 2772, 62811, 1210, 4698, 47403, 5418, 5780, 38570, 5546, 76469, 2420, 5302, 51799, 2646, 5414, 36501, 3412, 5546, 18869, 2412, 54446, 5276, 6732, 48422, 6822, 2900, 28010, 4826, 92509, 2394, 5274, 55883, 6730, 6820, 47956, 5812, 2778, 18779, 2358, 62615, 5270, 5450, 46757, 3492, 5556, 27318, 4718, 67887, 2350, 3222, 52554, 7498, 3428, 38252, 5468, 4700, 31022, 6444, 64149, 6804, 6986, 43861, 2772, 5338, 35421, 2650, 70955, 5418, 5780, 54954, 5546, 2740, 38074, 5302, 2646, 29991, 3366, 61011, 3412, 5546, 43445, 2412, 5294, 35406, 6732, 72998, 6820, 6996, 52586, 2778, 2396, 38045, 5274, 6698, 23333, 6820, 64338, 5812, 2746, 43355, 2358, 5270, 39499, 5450, 79525, 3492, 5548};
    private static final int[] GREGORIAN_YEAR_INFO = new int[]{1887, 966732, 967231, 967733, 968265, 968766, 969297, 969798, 970298, 970829, 971330, 971830, 972362, 972863, 973395, 973896, 974397, 974928, 975428, 975929, 976461, 976962, 977462, 977994, 978494, 979026, 979526, 980026, 980558, 981059, 981559, 982091, 982593, 983124, 983624, 984124, 984656, 985157, 985656, 986189, 986690, 987191, 987722, 988222, 988753, 989254, 989754, 990286, 990788, 991288, 991819, 992319, 992851, 993352, 993851, 994383, 994885, 995385, 995917, 996418, 996918, 997450, 997949, 998481, 998982, 999483, 1000014, 1000515, 1001016, 1001548, 1002047, 1002578, 1003080, 1003580, 1004111, 1004613, 1005113, 1005645, 1006146, 1006645, 1007177, 1007678, 1008209, 1008710, 1009211, 1009743, 1010243, 1010743, 1011275, 1011775, 1012306, 1012807, 1013308, 1013840, 1014341, 1014841, 1015373, 1015874, 1016404, 1016905, 1017405, 1017937, 1018438, 1018939, 1019471, 1019972, 1020471, 1021002, 1021503, 1022035, 1022535, 1023036, 1023568, 1024069, 1024568, 1025100, 1025601, 1026102, 1026633, 1027133, 1027666, 1028167, 1028666, 1029198, 1029699, 1030199, 1030730, 1031231, 1031763, 1032264, 1032764, 1033296, 1033797, 1034297, 1034828, 1035329, 1035830, 1036362, 1036861, 1037393, 1037894, 1038394, 1038925, 1039427, 1039927, 1040459, 1040959, 1041491, 1041992, 1042492, 1043023, 1043524, 1044024, 1044556, 1045057, 1045558, 1046090, 1046590, 1047121, 1047622, 1048122, 1048654, 1049154, 1049655, 1050187, 1050689, 1051219, 1051720, 1052220, 1052751, 1053252, 1053752, 1054284, 1054786, 1055285, 1055817, 1056317, 1056849, 1057349, 1057850, 1058382, 1058883, 1059383, 1059915, 1060415, 1060947, 1061447, 1061947, 1062479, 1062981, 1063480, 1064012, 1064514, 1065014, 1065545, 1066045, 1066577, 1067078, 1067578, 1068110, 1068611, 1069112, 1069642, 1070142, 1070674, 1071175, 1071675, 1072207, 1072709, 1073209, 1073740, 1074241, 1074741, 1075273, 1075773, 1076305, 1076807, 1077308, 1077839, 1078340, 1078840, 1079372, 1079871, 1080403, 1080904};
    private static final long[] TERM_INFO = new long[]{0L, 21208L, 42467L, 63836L, 85337L, 107014L, 128867L, 150921L, 173149L, 195551L, 218072L, 240693L, 263343L, 285989L, 308563L, 331033L, 353350L, 375494L, 397447L, 419210L, 440795L, 462224L, 483532L, 504758L};
    private static final String[] LUNAR_CAPITAL_NUM = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] LUNAR_HEADER = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", "\u6b63", "\u814a", "\u51ac", "\u95f0"};
    private static final String[] GREGORIAN_FESTIVAL = new String[]{"\u5143\u65e6 ", "\u60c5\u4eba\u8282 ", "\u5987\u5973\u8282 ", "\u690d\u6811\u8282 ", "\u6d88\u6743\u65e5 ", "\u611a\u4eba\u8282 ", "\u52b3\u52a8\u8282 ", "\u9752\u5e74\u8282 ", "\u513f\u7ae5\u8282 ", "\u5efa\u515a\u8282 ", "\u5efa\u519b\u8282 ", "\u6559\u5e08\u8282 ", "\u56fd\u5e86\u8282 ", "\u4e07\u5723\u8282 ", "\u5723\u8bde\u8282 "};
    private static final String[] LUNAR_FESTIVAL = new String[]{"\u6625\u8282 ", "\u5143\u5bb5\u8282 ", "\u7aef\u5348\u8282 ", "\u4e5e\u5de7\u8282 ", "\u4e2d\u79cb\u8282 ", "\u91cd\u9633\u8282 ", "\u814a\u516b\u8282 "};
    private static final String[] SOLAR_TERM = new String[]{"\u5c0f\u5bd2 ", "\u5927\u5bd2 ", "\u7acb\u6625 ", "\u96e8\u6c34 ", "\u60ca\u86f0 ", "\u6625\u5206 ", "\u6e05\u660e ", "\u8c37\u96e8 ", "\u7acb\u590f ", "\u5c0f\u6ee1 ", "\u8292\u79cd ", "\u590f\u81f3 ", "\u5c0f\u6691 ", "\u5927\u6691 ", "\u7acb\u79cb ", "\u5904\u6691 ", "\u767d\u9732 ", "\u79cb\u5206 ", "\u5bd2\u9732 ", "\u971c\u964d ", "\u7acb\u51ac ", "\u5c0f\u96ea ", "\u5927\u96ea ", "\u51ac\u81f3 "};
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd");
    private Map<Integer, List<String>> solarTermIdCreated = new HashMap<Integer, List<String>>();
    private Map<Integer, List<String>> solarTermNameCreated = new HashMap<Integer, List<String>>();
    private Map<Integer, String[][]> gregorianCreated = new HashMap<Integer, String[][]>();
    private Map<Integer, String[][]> lunarCreated = new HashMap<Integer, String[][]>();

    public CalendarBiz(int index, int year, int month) {
        this.buildSolarTerm(year);
        this.gregorianCreated.put(index, this.buildGregorian(year, month));
    }

    private int getBitInt(int data, int length, int shift) {
        return (data & (1 << length) - 1 << shift) >> shift;
    }

    private long gregorianToInt(int y, int m, int d) {
        m = (m + 9) % 12;
        return 365 * (y -= m / 10) + y / 4 - y / 100 + y / 400 + (m * 306 + 5) / 10 + (d - 1);
    }

    private Gregorian gregorianFromInt(long g) {
        long y = (10000L * g + 14780L) / 3652425L;
        long ddd = g - (365L * y + y / 4L - y / 100L + y / 400L);
        if (ddd < 0L) {
            ddd = g - (365L * --y + y / 4L - y / 100L + y / 400L);
        }
        long mi = (100L * ddd + 52L) / 3060L;
        long mm = (mi + 2L) % 12L + 1L;
        long dd = ddd - (mi * 306L + 5L) / 10L + 1L;
        Gregorian gregorian = new Gregorian();
        gregorian.year = (int)(y += (mi + 2L) / 12L);
        gregorian.month = (int)mm;
        gregorian.day = (int)dd;
        return gregorian;
    }

    private Gregorian lunarToGregorian(Lunar lunar) {
        int days = LUNAR_YEAR_INFO[lunar.year - LUNAR_YEAR_INFO[0]];
        int leap = this.getBitInt(days, 4, 13);
        int offset = 0;
        int loopEnd = leap;
        if (!lunar.isLeap) {
            loopEnd = lunar.month <= leap || leap == 0 ? lunar.month - 1 : lunar.month;
        }
        for (int i = 0; i < loopEnd; ++i) {
            offset += this.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
        }
        int gregorianToLunar = GREGORIAN_YEAR_INFO[lunar.year - GREGORIAN_YEAR_INFO[0]];
        int y = this.getBitInt(gregorianToLunar, 12, 9);
        int m = this.getBitInt(gregorianToLunar, 4, 5);
        int d = this.getBitInt(gregorianToLunar, 5, 0);
        return this.gregorianFromInt(this.gregorianToInt(y, m, d) + (long)(offset += lunar.day) - 1L);
    }

    private Lunar gregorianToLunar(Gregorian gregorian) {
        Lunar lunar = new Lunar();
        int index = gregorian.year - GREGORIAN_YEAR_INFO[0];
        int data = gregorian.year << 9 | gregorian.month << 5 | gregorian.day;
        int gregorianToLunar = 0;
        if (GREGORIAN_YEAR_INFO[index] > data) {
            --index;
        }
        gregorianToLunar = GREGORIAN_YEAR_INFO[index];
        int y = this.getBitInt(gregorianToLunar, 12, 9);
        int m = this.getBitInt(gregorianToLunar, 4, 5);
        int d = this.getBitInt(gregorianToLunar, 5, 0);
        long offset = this.gregorianToInt(gregorian.year, gregorian.month, gregorian.day) - this.gregorianToInt(y, m, d);
        int days = LUNAR_YEAR_INFO[index];
        int leap = this.getBitInt(days, 4, 13);
        int lunarY = index + GREGORIAN_YEAR_INFO[0];
        int lunarM = 1;
        int lunarD = 1;
        ++offset;
        for (int i = 0; i < 13; ++i) {
            int dm;
            int n = dm = this.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
            if (offset <= (long)dm) break;
            ++lunarM;
            offset -= (long)dm;
        }
        lunarD = (int)offset;
        lunar.year = lunarY;
        lunar.month = lunarM;
        lunar.isLeap = false;
        if (leap != 0 && lunarM > leap) {
            lunar.month = lunarM - 1;
            if (lunarM == leap + 1) {
                lunar.isLeap = true;
            }
        }
        lunar.day = lunarD;
        return lunar;
    }

    private int computeTerm(int y, int n) throws Exception {
        if (y == 2009 && n == 2) {
            CalendarBiz.TERM_INFO[n] = 43467L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 6, 2, 5);
        Date Year1900 = calendar.getTime();
        long millis = (long)(3.15569259747E10 * (double)(y - 1900) + (double)(TERM_INFO[n] * 60000L) + (double)Year1900.getTime());
        calendar.setTimeInMillis(millis);
        return calendar.get(5);
    }

    public void buildSolarTerm(int year) {
        if (null != this.solarTermIdCreated.get(year) && null != this.solarTermNameCreated.get(year)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (int month = 0; month < 12; ++month) {
            calendar.set(2, month);
            int firstTerm = 0;
            int secondTerm = 0;
            try {
                firstTerm = this.computeTerm(year, month * 2);
                secondTerm = this.computeTerm(year, month * 2 + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            calendar.set(5, firstTerm);
            ids.add(SDF.format(calendar.getTime()));
            names.add(SOLAR_TERM[month * 2]);
            calendar.set(5, secondTerm);
            ids.add(SDF.format(calendar.getTime()));
            names.add(SOLAR_TERM[month * 2 + 1]);
        }
        this.solarTermIdCreated.put(year, ids);
        this.solarTermNameCreated.put(year, names);
    }

    public String gregorianToLunar(int year, int month, int day) {
        int i;
        Gregorian gregorian = new Gregorian();
        gregorian.year = year;
        gregorian.month = month;
        gregorian.day = day;
        Lunar lunar = this.gregorianToLunar(gregorian);
        String result = String.valueOf(lunar.day);
        char[] c = result.toCharArray();
        if (c.length == 1) {
            for (i = 1; i < 10; ++i) {
                if (c[0] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[0] + LUNAR_CAPITAL_NUM[i];
            }
        } else if (c[0] == '1') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[0] + LUNAR_HEADER[1];
            } else {
                for (i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[1] + LUNAR_CAPITAL_NUM[i];
                }
            }
        } else if (c[0] == '2') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[2] + LUNAR_HEADER[1];
            } else {
                for (i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[2] + LUNAR_CAPITAL_NUM[i];
                }
            }
        } else if (c[1] == '0') {
            result = LUNAR_HEADER[3] + LUNAR_HEADER[1];
        } else {
            for (i = 1; i < 10; ++i) {
                if (c[1] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[3] + LUNAR_CAPITAL_NUM[i];
            }
        }
        List<String> ids = this.solarTermIdCreated.get(year);
        List<String> names = this.solarTermNameCreated.get(year);
        String id = "";
        id = month < 10 ? (day < 10 ? year + "" + 0 + "" + month + "" + 0 + "" + day : year + "" + 0 + "" + month + "" + day) : (day < 10 ? year + "" + month + "" + 0 + "" + day : year + "" + month + "" + day);
        if (ids.contains(id)) {
            result = names.get(ids.indexOf(id));
        }
        int lunarMonth = lunar.month;
        int lunarDay = lunar.day;
        if (lunarMonth == 1 && lunarDay == 1) {
            result = LUNAR_FESTIVAL[0];
        } else if (lunarMonth == 1 && lunarDay == 15) {
            result = LUNAR_FESTIVAL[1];
        } else if (lunarMonth == 5 && lunarDay == 5) {
            result = LUNAR_FESTIVAL[2];
        } else if (lunarMonth == 7 && lunarDay == 7) {
            result = LUNAR_FESTIVAL[3];
        } else if (lunarMonth == 8 && lunarDay == 15) {
            result = LUNAR_FESTIVAL[4];
        } else if (lunarMonth == 9 && lunarDay == 9) {
            result = LUNAR_FESTIVAL[5];
        } else if (lunarMonth == 12 && lunarDay == 8) {
            result = LUNAR_FESTIVAL[6];
        }
        if (month == 1 && day == 1) {
            result = GREGORIAN_FESTIVAL[0];
        } else if (month == 2 && day == 14) {
            result = GREGORIAN_FESTIVAL[1];
        } else if (month == 3 && day == 8) {
            result = GREGORIAN_FESTIVAL[2];
        } else if (month == 3 && day == 12) {
            result = GREGORIAN_FESTIVAL[3];
        } else if (month == 3 && day == 15) {
            result = GREGORIAN_FESTIVAL[4];
        } else if (month == 4 && day == 1) {
            result = GREGORIAN_FESTIVAL[5];
        } else if (month == 5 && day == 1) {
            result = GREGORIAN_FESTIVAL[6];
        } else if (month == 5 && day == 4) {
            result = GREGORIAN_FESTIVAL[7];
        } else if (month == 6 && day == 1) {
            result = GREGORIAN_FESTIVAL[8];
        } else if (month == 7 && day == 1) {
            result = GREGORIAN_FESTIVAL[9];
        } else if (month == 8 && day == 1) {
            result = GREGORIAN_FESTIVAL[10];
        } else if (month == 9 && day == 10) {
            result = GREGORIAN_FESTIVAL[11];
        } else if (month == 10 && day == 1) {
            result = GREGORIAN_FESTIVAL[12];
        } else if (month == 10 && day == 31) {
            result = GREGORIAN_FESTIVAL[13];
        } else if (month == 12 && day == 25) {
            result = GREGORIAN_FESTIVAL[14];
        }
        return result;
    }

    public String[][] buildGregorian(int year, int month) {
        String[][] a = new String[6][7];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        int week = calendar.get(7) - 1;
        int day = 0;
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            day = 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            day = 30;
        }
        if (month == 2) {
            day = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
        }
        int nextDay = 1;
        for (int k = 0; k < 6; ++k) {
            int j;
            if (k == 0) {
                for (j = week; j < 7; ++j) {
                    a[k][j] = "" + nextDay;
                    ++nextDay;
                }
                continue;
            }
            for (j = 0; j < 7 && nextDay <= day; ++nextDay, ++j) {
                a[k][j] = "" + nextDay;
            }
        }
        return a;
    }

    public Map<Integer, String[][]> getGregorianCreated() {
        return this.gregorianCreated;
    }

    public Map<Integer, String[][]> getLunarCreated() {
        return this.lunarCreated;
    }
}

