/*
 * Decompiled with CFR 0.152.
 */
package cn.leaqi.drawer;

import android.view.View;

public class ViewUtils {
    View view = null;
    View mask = null;
    int type = -1;
    int width = 0;
    int height = 0;
    int left = 0;
    int top = 0;
    int right = 0;
    int bottom = 0;
    int paddingLeft = 0;
    int paddingTop = 0;
    int paddingRight = 0;
    int paddingBottom = 0;
    boolean intercept = true;

    ViewUtils(View v, int t) {
        this.view = v;
        this.type = t;
    }

    ViewUtils(View v, int t, boolean u) {
        this.view = v;
        this.type = t;
        this.Update(u);
    }

    void Update(boolean isAll) {
        this.width = this.view.getMeasuredWidth();
        this.height = this.view.getMeasuredHeight();
        if (isAll) {
            this.left = this.view.getLeft();
            this.top = this.view.getTop();
            this.right = this.view.getRight();
            this.bottom = this.view.getBottom();
            this.paddingLeft = this.view.getPaddingLeft();
            this.paddingTop = this.view.getPaddingTop();
            this.paddingRight = this.view.getPaddingRight();
            this.paddingBottom = this.view.getPaddingBottom();
        }
    }

    void setMask(View view) {
        this.mask = view;
    }

    void setScale(float scale) {
        this.view.setScaleX(scale);
        this.view.setScaleY(scale);
        if (this.mask != null) {
            this.mask.setScaleX(scale);
            this.mask.setScaleY(scale);
        }
    }

    void setRotation(float rotation) {
        this.view.setRotation(rotation);
        if (this.mask != null) {
            this.mask.setRotation(rotation);
        }
    }

    void setLeft(int l) {
        this.left = l;
        this.view.setLeft(this.left);
        this.right = l + this.width;
        this.view.setRight(this.right);
        this.upMask();
    }

    void setTop(int t) {
        this.top = t;
        this.view.setTop(this.top);
        this.bottom = t + this.height;
        this.view.setBottom(this.bottom);
        this.upMask();
    }

    void setRight(int r) {
        this.right = r;
        this.view.setRight(this.right);
        this.left = r - this.width;
        this.view.setLeft(this.left);
        this.upMask();
    }

    void setBottom(int b) {
        this.bottom = b;
        this.view.setBottom(this.bottom);
        this.top = b - this.height;
        this.view.setTop(this.top);
        this.upMask();
    }

    void setVisibility(boolean show) {
        this.view.setVisibility(show ? 0 : 4);
    }

    void setFront() {
        this.view.bringToFront();
        if (this.mask != null) {
            this.mask.bringToFront();
        }
    }

    void upMask() {
        if (this.mask != null) {
            this.mask.setLeft(this.left);
            this.mask.setRight(this.right);
            this.mask.setTop(this.top);
            this.mask.setBottom(this.bottom);
        }
    }

    boolean isScrollLeft() {
        return !this.view.canScrollHorizontally(-1);
    }

    boolean isScrollTop() {
        return !this.view.canScrollVertically(-1);
    }

    boolean isScrollRight() {
        return !this.view.canScrollHorizontally(1);
    }

    boolean isScrollBottom() {
        return !this.view.canScrollVertically(1);
    }

    boolean isActionDown(int downX, int downY, int[] location) {
        int[] iLocation = this.getLocation();
        int getX = iLocation[0] - location[0];
        int getY = iLocation[1] - location[1];
        return downX > getX && downY > getY && downX < getX + this.width && downY < getY + this.height;
    }

    int[] getLocation() {
        int[] location = new int[2];
        this.view.getLocationOnScreen(location);
        return location;
    }
}

