/*
 * Decompiled with CFR 0.152.
 */
package cn.leaqi.drawer;

import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;

public class AnimThread
extends Thread {
    private static int FPS = 100;
    private int setDuration;
    private boolean isStop = false;
    private boolean isEnd = false;
    private boolean isAlive = true;
    private Interpolator animInterpolator;

    public AnimThread(int duration, Interpolator interpolator) {
        this.setDuration = duration;
        this.animInterpolator = interpolator == null ? new AccelerateDecelerateInterpolator() : interpolator;
        this.onInit();
        this.start();
    }

    protected void onInit() {
    }

    protected void onEnd() {
    }

    protected void onUpdate(float value) {
    }

    public void setStop() {
        this.isStop = true;
    }

    public void setEnd() {
        this.isEnd = true;
    }

    public void setAlive() {
        this.isAlive = false;
    }

    public static void setFPS(int num) {
        FPS = num;
    }

    public boolean getStop() {
        return this.isStop;
    }

    public boolean getEnd() {
        return this.isEnd;
    }

    public boolean getAlive() {
        return this.isAlive;
    }

    public static int getFPS() {
        return FPS;
    }

    public float getInterpolation(float t) {
        if (this.animInterpolator != null) {
            return this.animInterpolator.getInterpolation(t);
        }
        return t;
    }

    @Override
    public void run() {
        if (this.setDuration > 0) {
            int sSleep = Math.round(1000 / FPS);
            int iNum = 0;
            float eNum = (float)this.setDuration / 1000.0f * (float)FPS;
            float value = 0.0f;
            while ((float)iNum < eNum && !this.isEnd) {
                if (this.isStop) {
                    return;
                }
                try {
                    Thread.sleep(sSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                value = this.getInterpolation((float)iNum / eNum);
                this.onUpdate(value);
                ++iNum;
            }
            if (value < 1.0f) {
                this.onUpdate(1.0f);
            }
        } else {
            this.onUpdate(1.0f);
        }
        this.onEnd();
    }

    public static boolean isThread(AnimThread thread) {
        if (thread != null) {
            return thread.getAlive() || thread.isAlive();
        }
        return false;
    }
}

