/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.easyxls;

import cn.coder.easyxls.Sheet;
import cn.coder.easyxls.util.XLSUtils;
import cn.coder.easyxls.util.ZipUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Workbook {
    private static final Logger logger = LoggerFactory.getLogger(Workbook.class);
    private Sheet[] sheets;
    private Sheet defaultSheet;

    public Workbook(String sheet) {
        this.defaultSheet = new Sheet(sheet, 1);
        this.sheets = new Sheet[]{this.defaultSheet};
        if (logger.isDebugEnabled()) {
            logger.debug("Add default sheet:{}", (Object)this.defaultSheet.getName());
        }
    }

    public void addTitle(String title) {
        this.defaultSheet.addTitle(title);
    }

    public void addData(Object ... data) {
        this.defaultSheet.addData(data);
    }

    public boolean write(OutputStream outputStream) {
        ZipOutputStream zipStream;
        long start;
        block10: {
            start = System.currentTimeMillis();
            zipStream = null;
            ArrayList<String> strings = null;
            try {
                byte[] workBook = XLSUtils.getWorkbook(this.sheets);
                byte[] workBookRels = XLSUtils.getWorkbookRels(this.sheets);
                byte[] app = XLSUtils.getApp(this.sheets);
                zipStream = ZipUtils.createZip(outputStream, workBook, workBookRels, app);
                strings = new ArrayList<String>();
                Sheet[] sheetArray = this.sheets;
                int n = this.sheets.length;
                int n2 = 0;
                while (n2 < n) {
                    Sheet sheet = sheetArray[n2];
                    Workbook.putSheet(zipStream, strings, sheet);
                    ++n2;
                }
                Workbook.putStrings(zipStream, strings);
                if (strings == null) break block10;
                strings.clear();
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Create xlsx file faild", (Throwable)e);
                }
                return false;
            }
            finally {
                if (strings != null) {
                    strings.clear();
                }
                ZipUtils.close(zipStream, outputStream);
                if (logger.isDebugEnabled()) {
                    logger.debug("Created xlsx file with {}ms", (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        ZipUtils.close(zipStream, outputStream);
        if (logger.isDebugEnabled()) {
            logger.debug("Created xlsx file with {}ms", (Object)(System.currentTimeMillis() - start));
        }
        return true;
    }

    private static void putSheet(ZipOutputStream zipStream, ArrayList<String> strings, Sheet sheet) throws IOException {
        byte[] sheetData = XLSUtils.getSheet(sheet, strings);
        ZipUtils.putStreamEntry(zipStream, "xl/worksheets/sheet" + sheet.getId() + ".xml", sheetData);
    }

    private static void putStrings(ZipOutputStream zipStream, ArrayList<String> strings) throws IOException {
        byte[] temp = XLSUtils.getStrings(strings);
        ZipUtils.putStreamEntry(zipStream, "xl/sharedStrings.xml", temp);
    }

    public synchronized void close() {
        this.defaultSheet.clear();
        this.defaultSheet = null;
        Sheet[] sheetArray = this.sheets;
        int n = this.sheets.length;
        int n2 = 0;
        while (n2 < n) {
            Sheet sheet = sheetArray[n2];
            sheet.clear();
            ++n2;
        }
        this.sheets = null;
    }

    public Sheet addSheet(String name) {
        Sheet sheet = new Sheet(name, this.sheets.length + 1);
        Sheet[] temp = new Sheet[this.sheets.length + 1];
        System.arraycopy(this.sheets, 0, temp, 0, this.sheets.length);
        temp[this.sheets.length] = sheet;
        this.sheets = temp;
        if (logger.isDebugEnabled()) {
            logger.debug("Add sheet:{}, total:{}", (Object)sheet.getName(), (Object)temp.length);
        }
        return sheet;
    }
}

