/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHttpServerRequest
implements HttpServerRequest {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpServerRequest.class.getPackageName());
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>(1);
    private InputStream inputStream;
    private String method;
    private Map<String, List<String>> queryParameters;
    private String queryString;
    private String requestTarget;
    private final Socket socket;

    public DefaultHttpServerRequest(Socket socket) {
        this.socket = socket;
        this.parse();
    }

    public void addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, value);
        } else {
            this.headers.put(name, this.headers.get(name) + "," + value);
        }
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Iterator<String> getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public InputStream getInputStream() {
        InputStream result;
        block3: {
            result = this.inputStream;
            if (this.inputStream == null) {
                try {
                    result = this.inputStream = this.socket.getInputStream();
                }
                catch (IOException exception) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.log(Level.WARNING, "An I/O error occurred while acquiring input stream", exception);
                }
            }
        }
        return result;
    }

    public String getLocalAddress() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public String getLocalHostname() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryParameter(String name) {
        String result = null;
        DefaultHttpServerRequest defaultHttpServerRequest = this;
        synchronized (defaultHttpServerRequest) {
            if (this.queryParameters == null && this.queryString != null) {
                String[] params;
                this.queryParameters = new HashMap<String, List<String>>();
                for (String param : params = this.queryString.split("&")) {
                    try {
                        List<Object> values;
                        String parameterName = URLDecoder.decode(param.split("=")[0], "UTF-8");
                        String parameterValue = URLDecoder.decode(param.split("=")[1], "UTF-8");
                        if (this.queryParameters.containsKey(parameterName)) {
                            values = this.queryParameters.get(parameterName);
                            values.add(parameterValue);
                            continue;
                        }
                        values = new ArrayList<String>();
                        values.add(parameterValue);
                        this.queryParameters.put(parameterName, values);
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new RuntimeException(uee);
                    }
                }
            }
        }
        if (this.queryParameters != null) {
            result = this.queryParameters.get(name) != null ? this.queryParameters.get(name).get(0) : null;
        }
        return result;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHostname() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public String getRequestTarget() {
        return this.requestTarget;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setRequestTarget(String requestTarget) {
        this.requestTarget = requestTarget;
    }

    private void parse() {
        block8: {
            try {
                InputStream parseStream = this.socket.getInputStream();
                StringBuilder line = new StringBuilder();
                int read = parseStream.read();
                boolean requestLineParsed = false;
                if (read != -1) {
                    while (read != -1 && parseStream.available() > 0) {
                        if ('\r' != (char)read) {
                            line.append((char)read);
                        }
                        if ('\n' != (char)(read = parseStream.read())) continue;
                        if (line.length() > 0) {
                            if (!requestLineParsed) {
                                this.parseRequestLine(line.toString());
                                requestLineParsed = true;
                            } else {
                                this.parseHeader(line.toString());
                            }
                            line = new StringBuilder();
                            read = parseStream.read();
                            continue;
                        }
                        read = -1;
                    }
                }
            }
            catch (IOException exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                LOGGER.log(Level.WARNING, "An I/O error occurred while parsing the request", exception);
            }
        }
    }

    private void parseHeader(String line) {
        String name = line.substring(0, line.indexOf(58)).trim();
        String value = line.substring(line.indexOf(58) + 1).trim();
        this.addHeader(name, value);
    }

    private void parseRequestLine(String line) {
        int index = line.indexOf(32);
        this.setMethod(line.substring(0, index));
        line = line.substring(index + 1);
        index = line.indexOf(32);
        this.requestTarget = line.substring(0, index);
        if (this.requestTarget.contains("?")) {
            this.queryString = this.requestTarget.substring(this.requestTarget.indexOf("?") + 1);
            this.requestTarget = this.requestTarget.substring(0, this.requestTarget.indexOf("?"));
        }
    }
}

