/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.impl.DefaultHttpServer;
import cloud.piranha.http.impl.DefaultHttpServerProcessingThread;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

class DefaultHttpServerAcceptorThread
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpServerAcceptorThread.class.getPackageName());
    private final DefaultHttpServer server;

    public DefaultHttpServerAcceptorThread(DefaultHttpServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        while (!this.server.serverStopRequest) {
            try {
                Socket socket = this.server.serverSocket.accept();
                this.server.executorService.execute(new DefaultHttpServerProcessingThread(this.server, socket));
            }
            catch (IOException socket) {
            }
            catch (Throwable throwable) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "An error occurred while accepting a socket connection", throwable);
            }
        }
    }
}

