/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.lambda;

import cloud.localstack.LambdaExecutor;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class KinesisEventParser {
    public static KinesisEvent parse(List<Map<String, Object>> records) {
        KinesisEvent kinesisEvent = new KinesisEvent();
        kinesisEvent.setRecords(new LinkedList());
        for (Map<String, Object> record : records) {
            KinesisEvent.KinesisEventRecord r = new KinesisEvent.KinesisEventRecord();
            kinesisEvent.getRecords().add(r);
            r.setEventSourceARN((String)LambdaExecutor.get(record, "eventSourceARN"));
            r.setEventSource((String)LambdaExecutor.get(record, "eventSource"));
            r.setEventName((String)LambdaExecutor.get(record, "eventName"));
            r.setEventVersion((String)LambdaExecutor.get(record, "eventVersion"));
            r.setEventID((String)LambdaExecutor.get(record, "eventID"));
            r.setAwsRegion((String)LambdaExecutor.get(record, "awsRegion"));
            r.setInvokeIdentityArn((String)LambdaExecutor.get(record, "invokeIdentityArn"));
            Map kinesis = (Map)LambdaExecutor.get(record, "Kinesis");
            String dataString = new String(LambdaExecutor.get(kinesis, "Data").toString().getBytes());
            byte[] decodedData = Base64.getDecoder().decode(dataString);
            KinesisEvent.Record kinesisRecord = new KinesisEvent.Record();
            kinesisRecord.setData(ByteBuffer.wrap(decodedData));
            kinesisRecord.setPartitionKey((String)LambdaExecutor.get(kinesis, "PartitionKey"));
            kinesisRecord.setSequenceNumber((String)LambdaExecutor.get(kinesis, "SequenceNumber"));
            kinesisRecord.setKinesisSchemaVersion((String)LambdaExecutor.get(kinesis, "KinesisSchemaVersion"));
            kinesisRecord.setApproximateArrivalTimestamp(new Date());
            r.setKinesis(kinesisRecord);
        }
        return kinesisEvent;
    }
}

