/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.sponge7;

import cloud.commandframework.CommandTree;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandSource;

public final class CloudInjectionModule<C>
extends AbstractModule {
    private final Class<C> commandSenderType;
    private final Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator;
    private final Function<@NonNull CommandSource, @NonNull C> commandSenderMapper;
    private final Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper;

    public CloudInjectionModule(@NonNull Class<C> commandSenderType, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSource, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSource> backwardsCommandSenderMapper) {
        this.commandSenderType = commandSenderType;
        this.commandExecutionCoordinator = commandExecutionCoordinator;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
    }

    protected void configure() {
        ParameterizedType commandTreeType = Types.newParameterizedType(CommandTree.class, (Type[])new Type[]{this.commandSenderType});
        ParameterizedType commandExecutionCoordinatorType = Types.newParameterizedType(CommandExecutionCoordinator.class, (Type[])new Type[]{this.commandSenderType});
        ParameterizedType executorFunction = Types.newParameterizedType(Function.class, (Type[])new Type[]{commandTreeType, commandExecutionCoordinatorType});
        Key executorFunctionKey = Key.get((Type)executorFunction);
        this.bind(executorFunctionKey).toInstance(this.commandExecutionCoordinator);
        ParameterizedType commandSenderMapperFunction = Types.newParameterizedType(Function.class, (Type[])new Type[]{CommandSource.class, this.commandSenderType});
        Key commandSenderMapperFunctionKey = Key.get((Type)commandSenderMapperFunction);
        this.bind(commandSenderMapperFunctionKey).toInstance(this.commandSenderMapper);
        ParameterizedType backwardsCommandSenderMapperFunction = Types.newParameterizedType(Function.class, (Type[])new Type[]{this.commandSenderType, CommandSource.class});
        Key backwardsCommandSenderMapperFunctionKey = Key.get((Type)backwardsCommandSenderMapperFunction);
        this.bind(backwardsCommandSenderMapperFunctionKey).toInstance(this.backwardsCommandSenderMapper);
    }
}

