/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.sponge7;

import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.sponge7.SpongeCommandManager;
import cloud.commandframework.sponge7.SpongeMetaKeys;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

final class CloudCommandCallable<C>
implements CommandCallable {
    private static final Text MESSAGE_INTERNAL_ERROR = Text.of((Object[])new Object[]{TextColors.RED, "An internal error occurred while attempting to perform this command."});
    private static final Text MESSAGE_NO_PERMS = Text.of((Object[])new Object[]{TextColors.RED, "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error."});
    private static final Text MESSAGE_UNKNOWN_COMMAND = Text.of((String)"Unknown command. Type \"/help\" for help.");
    private final CommandArgument<?, ?> command;
    private final Command<C> cloudCommand;
    private final SpongeCommandManager<C> manager;

    CloudCommandCallable(CommandArgument<?, ?> command, Command<C> cloudCommand, SpongeCommandManager<C> manager) {
        this.command = command;
        this.cloudCommand = cloudCommand;
        this.manager = manager;
    }

    public CommandResult process(@NonNull CommandSource source, @NonNull String arguments) {
        C cloudSender = this.manager.getCommandSourceMapper().apply(source);
        this.manager.executeCommand(cloudSender, this.formatCommand(arguments)).whenComplete((result, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(cloudSender, InvalidSyntaxException.class, (Exception)((InvalidSyntaxException)throwable), (c, e) -> source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Invalid Command Syntax. Correct command syntax is: ", Text.of((Object[])new Object[]{TextColors.GRAY, ((InvalidSyntaxException)finalThrowable).getCorrectSyntax()})})));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    this.manager.handleException(cloudSender, InvalidCommandSenderException.class, (Exception)((InvalidCommandSenderException)throwable), (c, e) -> source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, finalThrowable.getMessage()})));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(cloudSender, NoPermissionException.class, (Exception)((NoPermissionException)throwable), (c, e) -> source.sendMessage(MESSAGE_NO_PERMS));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(cloudSender, NoSuchCommandException.class, (Exception)((NoSuchCommandException)throwable), (c, e) -> source.sendMessage(MESSAGE_UNKNOWN_COMMAND));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(cloudSender, ArgumentParseException.class, (Exception)((ArgumentParseException)throwable), (c, e) -> source.sendMessage(Text.of((Object[])new Object[]{"Invalid Command Argument: ", this.formatMessage(finalThrowable.getCause())})));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(cloudSender, CommandExecutionException.class, (Exception)((CommandExecutionException)throwable), (c, e) -> {
                        source.sendMessage(MESSAGE_INTERNAL_ERROR);
                        this.manager.getOwningPlugin().getLogger().error("Exception executing command handler", finalThrowable.getCause());
                    });
                } else {
                    source.sendMessage(MESSAGE_INTERNAL_ERROR);
                    this.manager.getOwningPlugin().getLogger().error("An unhandled exception was thrown during command execution", throwable);
                }
            }
        });
        return CommandResult.success();
    }

    private Text formatMessage(Throwable exc) {
        if (exc instanceof TextMessageException) {
            Text response = ((TextMessageException)exc).getText();
            if (response == null) {
                return Text.of((Object[])new Object[]{TextColors.GRAY, "null"});
            }
            if (response.getColor() == TextColors.NONE) {
                return response.toBuilder().color(TextColors.GRAY).build();
            }
            return response;
        }
        return Text.of((Object[])new Object[]{TextColors.GRAY, exc.getMessage()});
    }

    public List<String> getSuggestions(@NonNull CommandSource source, @NonNull String arguments, @Nullable Location<World> targetPosition) {
        return this.manager.suggest(this.manager.getCommandSourceMapper().apply(source), this.formatCommand(arguments));
    }

    private String formatCommand(String arguments) {
        if (arguments.isEmpty()) {
            return this.command.getName();
        }
        return this.command.getName() + " " + arguments;
    }

    public boolean testPermission(@NonNull CommandSource source) {
        return this.manager.hasPermission(this.manager.getCommandSourceMapper().apply(source), this.cloudCommand.getCommandPermission());
    }

    public @NonNull Optional<Text> getShortDescription(@NonNull CommandSource source) {
        Optional richDesc = this.cloudCommand.getCommandMeta().get(SpongeMetaKeys.RICH_DESCRIPTION);
        if (richDesc.isPresent()) {
            return richDesc;
        }
        return this.cloudCommand.getCommandMeta().get(CommandMeta.DESCRIPTION).map(Text::of);
    }

    public @NonNull Optional<Text> getHelp(@NonNull CommandSource source) {
        Optional richLongDesc = this.cloudCommand.getCommandMeta().get(SpongeMetaKeys.RICH_LONG_DESCRIPTION);
        if (richLongDesc.isPresent()) {
            return richLongDesc;
        }
        return this.cloudCommand.getCommandMeta().get(CommandMeta.LONG_DESCRIPTION).map(Text::of);
    }

    public Text getUsage(@NonNull CommandSource source) {
        return Text.of((String)this.manager.commandSyntaxFormatter().apply(Collections.emptyList(), this.manager.commandTree().getNamedNode(this.command.getName())));
    }
}

