/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.AbstractAgileCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.util.NumberUtils;

public class AgileEhCache
extends AbstractAgileCache {
    AgileEhCache(EhCacheCache cache) {
        super((Cache)cache);
    }

    private Ehcache getEhCache() {
        return (Ehcache)this.cache.getNativeCache();
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        Ehcache ehCache = this.getEhCache();
        Element element = new Element(key, value);
        element.setTimeToLive(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setEternal(true);
        ehCache.put(element);
    }

    @Override
    public boolean containKey(Object key) {
        return this.getEhCache().get(key) != null;
    }

    private Map<Object, Object> getMap(Object mapKey, boolean require) {
        Object map;
        Element value = this.getEhCache().get(mapKey);
        if (value == null) {
            if (require) {
                value = new Element(mapKey, new HashMap(0));
                this.getEhCache().put(value);
            } else {
                throw new CacheException("Cache data does not exist");
            }
        }
        if (!Map.class.isAssignableFrom((map = value.getObjectValue()).getClass())) {
            throw new CacheException("Target data is not the expected type");
        }
        return (Map)map;
    }

    private List<Object> getList(Object listKey, boolean require) {
        Object map;
        Element value = this.getEhCache().get(listKey);
        if (value == null) {
            if (require) {
                value = new Element(listKey, new ArrayList());
                this.getEhCache().put(value);
            } else {
                throw new CacheException("Cache data does not exist");
            }
        }
        if (!List.class.isAssignableFrom((map = value.getObjectValue()).getClass())) {
            throw new CacheException("Target data is not the expected type");
        }
        return (List)map;
    }

    private Set<Object> getSet(Object setKey, boolean require) {
        Object map;
        Element value = this.getEhCache().get(setKey);
        if (value == null) {
            if (require) {
                value = new Element(setKey, new HashSet());
                this.getEhCache().put(value);
            } else {
                throw new CacheException("Cache data does not exist");
            }
        }
        if (!Set.class.isAssignableFrom((map = value.getObjectValue()).getClass())) {
            throw new CacheException("Target data is not the expected type");
        }
        return (Set)map;
    }

    @Override
    public void addToMap(Object mapKey, Object key, Object value) {
        Map<Object, Object> map = this.getMap(mapKey, true);
        map.put(key, value);
    }

    @Override
    public Object getFromMap(Object mapKey, Object key) {
        Map<Object, Object> map = this.getMap(mapKey, false);
        return map.get(key);
    }

    @Override
    public <T> T getFromMap(Object mapKey, Object key, Class<T> clazz) {
        Object value = this.getFromMap(mapKey, key);
        if (value != null && clazz != null && !clazz.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + clazz.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public void removeFromMap(Object mapKey, Object key) {
        Map<Object, Object> map = this.getMap(mapKey, false);
        map.remove(key);
    }

    @Override
    public void addToList(Object listKey, Object node) {
        List<Object> list = this.getList(listKey, true);
        list.add(node);
    }

    @Override
    public Object getFromList(Object listKey, int index) {
        List<Object> list = this.getList(listKey, false);
        return list.get(index);
    }

    @Override
    public <T> T getFromList(Object listKey, int index, Class<T> clazz) {
        Object value = this.getFromList(listKey, index);
        if (value != null && clazz != null && !clazz.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + clazz.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public void removeFromList(Object listKey, int index) {
        List<Object> list = this.getList(listKey, false);
        list.remove(index);
    }

    @Override
    public void addToSet(Object setKey, Object node) {
        Set<Object> set = this.getSet(setKey, true);
        set.add(node);
    }

    @Override
    public void removeFromSet(Object setKey, Object node) {
        Set<Object> set = this.getSet(setKey, false);
        set.remove(node);
    }

    @Override
    public synchronized boolean lock(Object lock) {
        return this.lock(lock, null);
    }

    @Override
    public synchronized boolean lock(Object lock, Duration timeout) {
        boolean isLock;
        Ehcache ehcache = this.getEhCache();
        try {
            isLock = ehcache.tryWriteLockOnKey(lock, 0L);
        }
        catch (InterruptedException e) {
            isLock = false;
        }
        if (isLock) {
            ehcache.acquireWriteLockOnKey(lock);
            if (timeout == null) {
                ehcache.put(new Element(lock, (Object)new byte[0]));
            } else {
                ehcache.put(new Element(lock, (Object)new byte[0], timeout.getSeconds()));
            }
        }
        return isLock;
    }

    @Override
    public void unlock(Object lock) {
        Ehcache ehcache = this.getEhCache();
        try {
            ehcache.releaseReadLockOnKey(lock);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    @Override
    public void unlock(Object lock, Duration timeout) {
        this.unlock(lock);
        Ehcache ehcache = this.getEhCache();
        ehcache.put(new Element(lock, (Object)new byte[0], timeout.getSeconds()));
    }
}

