/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.memory;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.support.memory.Node;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;

public class MemoryCache
implements AgileCache {
    private final ConcurrentHashMap<Object, Node> store = new ConcurrentHashMap();
    private final String cacheName;
    private static final Map<Object, Long> LOCK_POOL = Maps.newConcurrentMap();

    public MemoryCache(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public Object getNativeCache() {
        return this;
    }

    public Cache.ValueWrapper get(Object key) {
        return () -> {
            Node v;
            if (this.containKey(key) && (v = this.store.get(key)) != null) {
                return v.getValue();
            }
            return null;
        };
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (!this.containKey(key)) {
            this.put(key, value);
        }
        return this.get(key);
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.store.put(key, new Node(System.currentTimeMillis() + timeout.toMillis(), value));
    }

    @Override
    public void put(Object key, Object value) {
        this.store.put(key, new Node(-1L, value));
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        return (T)this.get(key).get();
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        T v;
        try {
            v = valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
        this.put(key, v);
        return v;
    }

    @Override
    public void evict(Object key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean containKey(Object key) {
        Node node = this.store.get(key);
        if (node == null || node.getTimeout() != -1L && node.getTimeout() <= System.currentTimeMillis()) {
            this.store.remove(key);
            return false;
        }
        return true;
    }

    @Override
    public void addToMap(Object mapKey, Object key, Object value) {
        if (this.containKey(mapKey)) {
            Node node = this.store.get(mapKey);
            Object v = node.getValue();
            if (v == null || !Map.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fMap\u7ed3\u6784\uff0c\u65e0\u6cd5\u5b58\u653e\u7f13\u5b58");
            }
            ((Map)v).put(key, value);
        } else {
            HashMap<Object, Object> map = new HashMap<Object, Object>(16);
            map.put(key, value);
            Node node = new Node(-1L, map);
            this.store.put(mapKey, node);
        }
    }

    @Override
    public Object getFromMap(Object mapKey, Object key) {
        if (this.containKey(mapKey)) {
            Node node = this.store.get(mapKey);
            Object v = node.getValue();
            if (v == null || !Map.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fMap\u7ed3\u6784\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58");
            }
            return ((Map)v).get(key);
        }
        return null;
    }

    @Override
    public <T> T getFromMap(Object mapKey, Object key, Class<T> clazz) {
        Object v = this.getFromMap(mapKey, key);
        return (T)v;
    }

    @Override
    public void removeFromMap(Object mapKey, Object key) {
        if (this.containKey(mapKey)) {
            Node node = this.store.get(mapKey);
            Object v = node.getValue();
            if (v == null || !Map.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fMap\u7ed3\u6784\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58");
            }
            ((Map)v).remove(key);
        }
    }

    @Override
    public void addToList(Object listKey, Object value) {
        if (this.containKey(listKey)) {
            Node node = this.store.get(listKey);
            Object v = node.getValue();
            if (v == null || !List.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fList\u7ed3\u6784\uff0c\u65e0\u6cd5\u5b58\u653e\u7f13\u5b58");
            }
            ((List)v).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(16);
            list.add(value);
            Node node = new Node(-1L, list);
            this.store.put(listKey, node);
        }
    }

    @Override
    public Object getFromList(Object listKey, int index) {
        if (this.containKey(listKey)) {
            Node node = this.store.get(listKey);
            Object v = node.getValue();
            if (v == null || !List.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fList\u7ed3\u6784\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58");
            }
            return ((List)v).get(index);
        }
        return null;
    }

    @Override
    public <T> T getFromList(Object listKey, int index, Class<T> clazz) {
        Object v = this.getFromList(listKey, index);
        return (T)v;
    }

    @Override
    public void removeFromList(Object listKey, int index) {
        if (this.containKey(listKey)) {
            Node node = this.store.get(listKey);
            Object v = node.getValue();
            if (v == null || !List.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fList\u7ed3\u6784\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58");
            }
            ((List)v).remove(index);
        }
    }

    @Override
    public void addToSet(Object setKey, Object value) {
        if (this.containKey(setKey)) {
            Node node = this.store.get(setKey);
            Object v = node.getValue();
            if (v == null || !Set.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fSet\u7ed3\u6784\uff0c\u65e0\u6cd5\u5b58\u653e\u7f13\u5b58");
            }
            ((Set)v).add(value);
        } else {
            HashSet<Object> set = new HashSet<Object>(16);
            set.add(value);
            Node node = new Node(-1L, set);
            this.store.put(setKey, node);
        }
    }

    @Override
    public void removeFromSet(Object setKey, Object value) {
        if (this.containKey(setKey)) {
            Node node = this.store.get(setKey);
            Object v = node.getValue();
            if (v == null || !Set.class.isAssignableFrom(v.getClass())) {
                throw new RuntimeException("\u76ee\u6807\u7f13\u5b58\u5e76\u4e0d\u662fSet\u7ed3\u6784\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58");
            }
            ((Set)v).remove(node);
        }
    }

    @Override
    public synchronized boolean lock(Object lock) {
        return this.lock(lock, null);
    }

    @Override
    public synchronized boolean lock(Object lock, Duration timeout) {
        Long timeoutMillion;
        long currentTime = System.currentTimeMillis();
        if (LOCK_POOL.containsKey(lock) && ((timeoutMillion = LOCK_POOL.get(lock)) == -1L || currentTime <= timeoutMillion)) {
            return false;
        }
        if (timeout == null) {
            LOCK_POOL.put(lock, -1L);
        } else {
            LOCK_POOL.put(lock, currentTime + timeout.toMillis());
        }
        return true;
    }

    @Override
    public synchronized void unlock(Object lock) {
        LOCK_POOL.remove(lock);
    }

    @Override
    public synchronized void unlock(Object lock, Duration timeout) {
        long currentTime = System.currentTimeMillis();
        LOCK_POOL.put(lock, currentTime + timeout.toMillis());
    }
}

