/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.sync;

import cloud.agileframework.cache.support.ehcache.AgileEhCache;
import cloud.agileframework.cache.support.ehcache.AgileEhCacheCacheManager;
import cloud.agileframework.cache.support.redis.AgileRedis;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import cloud.agileframework.cache.sync.AbstractSyncCache;
import cloud.agileframework.cache.sync.CacheSyncException;
import cloud.agileframework.cache.sync.OpType;
import cloud.agileframework.cache.sync.OptimisticLockCheckError;
import cloud.agileframework.cache.sync.SyncKeys;
import cloud.agileframework.spring.util.AsyncUtil;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisSyncCache
extends AbstractSyncCache
implements MessageListener {
    public static final String LOCK_CACHE_KEY = "key";
    @Autowired
    private AgileRedisCacheManager agileRedisCacheManager;
    @Autowired
    private AgileEhCacheCacheManager agileEhCacheCacheManager;
    @Autowired
    private StringRedisTemplate redisTemplate;

    private void notice(String channel, int newCacheVersion) {
        this.redisTemplate.convertAndSend(channel, (Object)Integer.toString(newCacheVersion));
    }

    public void onMessage(Message message, byte[] pattern) {
        Object channel = this.redisTemplate.getKeySerializer().deserialize(message.getChannel());
        Object noticeVersionData = this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        if (noticeVersionData instanceof String && NumberUtils.isCreatable((String)((String)noticeVersionData))) {
            this.message((String)channel, NumberUtils.toInt((String)((String)noticeVersionData)));
            return;
        }
        throw new CacheSyncException("Notification content does not conform to version number format");
    }

    private void ehcacheToRedis(SyncKeys syncKeys, OpType opType) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
        if (OpType.DELETE == opType) {
            syncKeys.getVersionData().set(-1);
            redisCache.evict(syncKeys.getData());
            redisCache.evict(syncKeys.getVersion());
        } else if (OpType.WRITE == opType) {
            Element element = this.agileEhCacheCacheManager.getCache(syncKeys.getRegion()).getNativeCache().get((Serializable)((Object)syncKeys.getData()));
            if (element == null || element.getObjectValue() == null) {
                return;
            }
            syncKeys.getVersionData().addAndGet(1);
            redisCache.putIgnoreAggregate(syncKeys.getData(), element.getObjectValue());
            redisCache.putIgnoreAggregate(syncKeys.getVersion(), syncKeys.getVersionData().get());
        }
    }

    private void redisToEhcache(SyncKeys syncKeys, OpType opType) {
        AgileEhCache ehcache = this.agileEhCacheCacheManager.getCache(syncKeys.getRegion());
        if (OpType.DELETE == opType) {
            ehcache.directEvict(syncKeys.getData());
        } else if (OpType.READ == opType || OpType.WRITE == opType) {
            AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
            Cache.ValueWrapper valueWrapper = redisCache.get(syncKeys.getData());
            if (valueWrapper == null || valueWrapper.get() == null) {
                return;
            }
            ehcache.directPut(syncKeys.getData(), valueWrapper.get());
            this.syncVersion(syncKeys);
        }
    }

    private void syncVersion(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
        Integer cacheVersion = redisCache.get((Object)syncKeys.getVersion(), Integer.class);
        if (cacheVersion != null) {
            syncKeys.getVersionData().set(cacheVersion);
        }
    }

    public void message(String channel, int noticeVersion) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(channel);
        SyncKeys syncKeys = RedisSyncCache.keysByChannel(channel);
        Integer cacheVersionData = redisCache.get((Object)syncKeys.getVersion(), Integer.class);
        if (cacheVersionData == null) {
            throw new CacheSyncException("The cached version number was not found");
        }
        int cacheVersion = NumberUtils.toInt((String)cacheVersionData.toString());
        if (-1 == noticeVersion) {
            this.redisToEhcache(syncKeys, OpType.DELETE);
        } else {
            if (cacheVersion < noticeVersion) {
                throw new CacheSyncException("The version number of the notification does not match the version number of the cache");
            }
            this.redisToEhcache(syncKeys, OpType.WRITE);
        }
    }

    private boolean writeLock(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        if (redisCache.containLock(syncKeys.getReadLock())) {
            return false;
        }
        return redisCache.lockOnThreadLocal(syncKeys.getWriteLock(), Duration.ofSeconds(120L));
    }

    private boolean readLock(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        if (redisCache.containLock(syncKeys.getWriteLock())) {
            return true;
        }
        return redisCache.lockOnThreadLocal(syncKeys.getReadLock(), Duration.ofSeconds(120L));
    }

    private void unlock(String lockKey) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        redisCache.unlock(lockKey);
    }

    @Override
    public <T> T sync(String region, String key, Supplier<T> supplier, OpType opType) {
        T result = null;
        SyncKeys syncKeys = RedisSyncCache.keys(region, key);
        for (int count = 1200; count > 0; --count) {
            switch (opType) {
                case READ: {
                    T v = supplier.get();
                    if (v != null) {
                        return v;
                    }
                    if (!this.syncData(syncKeys)) break;
                    return supplier.get();
                }
                case WRITE: 
                case DELETE: {
                    if (!this.writeLock(syncKeys)) break;
                    try {
                        this.checkCAS(syncKeys);
                        result = supplier.get();
                        AsyncUtil.execute(() -> this.ehcacheToRedisAndNotice(syncKeys, opType));
                        return result;
                    }
                    catch (OptimisticLockCheckError e) {
                        this.unlock(syncKeys.getWriteLock());
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.unlock(syncKeys.getWriteLock());
                        break;
                    }
                }
            }
            try {
                Thread.sleep(Duration.ofMillis(10L).toMillis());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    private void checkCAS(SyncKeys syncKeys) throws OptimisticLockCheckError {
        AgileRedis redisCache;
        Integer redisVersion;
        boolean noChange;
        int ehcacheVersion = syncKeys.getVersionData().get();
        if (ehcacheVersion == 0) {
            this.syncVersion(syncKeys);
            ehcacheVersion = syncKeys.getVersionData().get();
        }
        boolean bl = noChange = (redisVersion = (redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion())).get((Object)syncKeys.getVersion(), Integer.TYPE)) == null || redisVersion <= ehcacheVersion;
        if (!noChange) {
            throw new OptimisticLockCheckError("redis version is illegal");
        }
    }

    @Override
    public void clear(String region) {
        Ehcache ehcache = this.agileEhCacheCacheManager.getCache(region).getNativeCache();
        List keys = ehcache.getKeys();
        keys.forEach(key -> this.sync(region, key.toString(), () -> null, OpType.DELETE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ehcacheToRedisAndNotice(SyncKeys syncKeys, OpType opType) {
        try {
            this.ehcacheToRedis(syncKeys, opType);
            this.notice(syncKeys.getChannel(), syncKeys.getVersionData().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.unlock(syncKeys.getWriteLock());
        }
        if (OpType.DELETE == opType) {
            RedisSyncCache.remove(syncKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncData(SyncKeys syncKeys) {
        if (this.readLock(syncKeys)) {
            try {
                Element element = this.agileEhCacheCacheManager.getCache(syncKeys.getRegion()).getNativeCache().get((Serializable)((Object)syncKeys.getData()));
                if (element == null || element.getObjectValue() == null) {
                    this.redisToEhcache(syncKeys, OpType.READ);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock(syncKeys.getReadLock());
            }
            return true;
        }
        return false;
    }
}

