/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.redis;

import cloud.agileframework.cache.support.AbstractAgileCacheManager;
import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.support.redis.AgileRedis;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class AgileRedisCacheManager
extends AbstractAgileCacheManager {
    private static RedisCacheManager cacheManager;
    private final RedisConnectionFactory redisConnectionFactory;

    public AgileRedisCacheManager(RedisCacheManager cacheManager, RedisConnectionFactory redisConnectionFactory) {
        AgileRedisCacheManager.setCacheManager(cacheManager);
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public static RedisCacheManager getCacheManager() {
        return cacheManager;
    }

    public static void setCacheManager(RedisCacheManager cacheManager) {
        AgileRedisCacheManager.cacheManager = cacheManager;
    }

    @Override
    public AgileCache cover(Cache cache) {
        return new AgileRedis((RedisCache)cache, this.redisConnectionFactory);
    }

    @Override
    public AgileCache getMissingCache(String cacheName) {
        return this.cover(cacheManager.getCache(cacheName));
    }
}

