/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.properties.EhCacheProperties;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={EhCacheProperties.class})
@ConditionalOnClass(value={Cache.class, EhCacheCacheManager.class})
@ConditionalOnMissingBean(value={org.springframework.cache.CacheManager.class})
@ConditionalOnProperty(name={"type"}, prefix="spring.cache", havingValue="ehcache")
public class EhCacheAutoConfiguration {
    private final EhCacheProperties ehCacheProperties;

    public EhCacheAutoConfiguration(EhCacheProperties ehCacheProperties) {
        this.ehCacheProperties = ehCacheProperties;
    }

    @Bean
    public EhCacheCacheManager cacheManager(CacheManager ehCacheCacheManager) {
        return new EhCacheCacheManager(ehCacheCacheManager);
    }

    @Bean
    public CacheManager ehCacheCacheManager() {
        return new CacheManager(this.configuration());
    }

    public Configuration configuration() {
        DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration().path(this.ehCacheProperties.getPath());
        Configuration configuration = new Configuration().diskStore(diskStoreConfiguration);
        configuration.setName(this.ehCacheProperties.getDefaultConfigName());
        Map<String, CacheConfiguration> regions = this.ehCacheProperties.getRegions();
        for (Map.Entry<String, CacheConfiguration> entry : regions.entrySet()) {
            String name = entry.getKey();
            CacheConfiguration regionConfig = entry.getValue();
            regionConfig.setName(name);
            if (this.ehCacheProperties.getDefaultConfigName().equals(name)) {
                configuration.setDefaultCacheConfiguration(regionConfig);
                configuration.cache(regionConfig.clone().name("hibernate.org.hibernate.cache.spi.TimestampsRegion"));
                configuration.cache(regionConfig.clone().name("hibernate.org.hibernate.cache.spi.QueryResultsRegion"));
                continue;
            }
            configuration.cache(regionConfig);
        }
        return configuration;
    }
}

