(ns web.video.TrackDefaultList
  "The TrackDefaultList interface represents a simple container
  for multiple `web.video.TrackDefault` objects."
  (:refer-clojure :exclude []))

(defn constructor
  "Constructor.

  The TrackDefaultList() constructor of the `web.video.TrackDefaultList` interface constructs and returns a new TrackDefaultList object.

  trackDefaults
  A sequence (array) of `web.video.TrackDefault` objects.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefaultList/TrackDefaultList`"
  [& args]
  (new (js/Function.prototype.bind.apply js/TrackDefaultList (clj->js args))))

(defn track-default
  "Method.

  [Experimental]

  The TrackDefault() getter method of the `web.video.TrackDefaultList`
  allows the TrackDefault objects in the list to be accessed with
  array operator (i.e. [].)

  `var myTrackDefault = TrackDefaultList[index];`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefaultList/TrackDefault`"
  [this ]
  (-> this (.TrackDefault)))

(defn length
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The length read-only property of the `web.video.TrackDefaultList`
  returns the number of `web.video.TrackDefault` objects in the

  `var myListLength = TrackDefaultList.length;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefaultList/length`"
  [this]
  (-> this (.-length)))

