(ns web.video.TrackDefault
  "The TrackDefault interface provides a `web.video.SourceBuffer`
  kind, label, and language information for tracks that do not
  this information in the initialization segments of a media chunk."
  (:refer-clojure :exclude [type]))

(defn constructor
  "Constructor.

  The TrackDefault() constructor of the `web.video.TrackDefault` interface constructs and returns a new TrackDefault object.

  type
  A `web.DOMString` specifying a media segment data type for the `web.video.SourceBuffer` to contain. Can be audio, video, or text.
  language
  A `web.DOMString` specifying a default language for the `web.video.SourceBuffer` to use when an initialization segment does not contain language information for a new track.
  label
  A `web.DOMString` specifying a default label for the `web.video.SourceBuffer` to use when an initialization segment does not contain label information for a new track.
  kinds
  An array (sequence) of `web.DOMString`s specifying default kinds for the `web.video.SourceBuffer` to use when an initialization segment does not contain kind information for a new track.
  byteStreamTrackID Optional
  A `web.DOMString` specifying the ID of the specific track that the `web.video.SourceBuffer` should apply to. If not specified, this value will be an empty string and the SourceBuffer can contain any tracks of the specified type.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/TrackDefault`"
  [& args]
  (new (js/Function.prototype.bind.apply js/TrackDefault (clj->js args))))

(defn type
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The type read-only property of the `web.video.TrackDefault` interface
  the type of track that this `web.video.SourceBuffer`'s media
  data relates to (i.e. audio, video, or text track.)

  `var myType = TrackDefault.type;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/type`"
  [this]
  (-> this (.-type)))

(defn byte-stream-track-id
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The byteStreamTrackID read-only property of the `web.video.TrackDefault`
  returns the ID of the specific track that the `web.video.SourceBuffer`
  apply to.

  `var myID = TrackDefault.byteStreamTrackID;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/byteStreamTrackID`"
  [this]
  (-> this (.-byteStreamTrackID)))

(defn language
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The language read-only property of the `web.video.TrackDefault`
  returns a default language for an associated `web.video.SourceBuffer`
  use when an initialization segment does not contain language
  for a new track.

  `var mylanguage = TrackDefault.language;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/language`"
  [this]
  (-> this (.-language)))

(defn label
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The label read-only property of the `web.video.TrackDefault`
  returns the default label for an associated `web.video.SourceBuffer`
  use when an initialization segment does not contain label information
  a new track.

  `var mylabel = TrackDefault.label;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/label`"
  [this]
  (-> this (.-label)))

(defn kinds
  "Property.

  [Read Only]
  [Draft]
  [Experimental]

  The kinds read-only property of the `web.video.TrackDefault`
  returns default kinds for an associated `web.video.SourceBuffer`
  use when an initialization segment does not contain label information
  a new track.

  `var mykinds = TrackDefault.kinds;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/TrackDefault/kinds`"
  [this]
  (-> this (.-kinds)))

