(ns web.video.MediaRecorderErrorEvent
  "The MediaRecorderErrorEvent interface represents errors returned
  the MediaStream Recording API. It is an `web.Event` object that
  a reference to a `web.DOMException` describing the error that"
  (:refer-clojure :exclude []))

(defn constructor
  "Constructor.

  The MediaRecorderErrorEvent() constructor creates a new `web.video.MediaRecorderErrorEvent` object that represents an error that occurred during the recording of media by the MediaStream Recording API.

  errorInfo
  An object describing the error object to be created. It must contain the error property at a minimum.

  error
  A `web.DOMException` that describes the error that occurred. This object's `name` property should indicate the name of the error that occurred. The other fields may or may not be present.





  Some user agents add to the error object other properties that provide information such as stack dumps, the name of the JavaScript file and the line number where the error occurred, and other debugging aids, but you should not rely on this information in a production environment.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaRecorderErrorEvent/MediaRecorderErrorEvent`"
  [& args]
  (new (js/Function.prototype.bind.apply js/MediaRecorderErrorEvent (clj->js args))))

(defn error
  "Property.

  [Read Only]

  The read-only error property in the `web.video.MediaRecorderErrorEvent`
  is a `web.DOMException` object providing details about the exception
  was thrown by a `web.video.MediaRecorder` instance.

  `error = MediaRecorderErrorEvent.error;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaRecorderErrorEvent/error`"
  [this]
  (-> this (.-error)))

