(ns web.video.MediaKeySession
  "The MediaKeySession interface of the EncryptedMediaExtensions
  represents a context for message exchange with a content decryption
  (CDM)."
  (:refer-clojure :exclude [load remove update]))

(defn close
  "Method.

  [Experimental]

  The MediaKeySession.close() method notifies that the current
  session is no longer needed, and that the content decryption
  should release any resources associated with this object and
  it. Then, it returns a `js.Promise`.

  `mediaKeySession.close().then(function() { ... });`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/close`"
  [this & args]
  (-> this .-close (.apply this (clj->js args))))

(defn generate-request
  "Method.

  [Experimental]

  The MediaKeySession.generateRequest() method returns a `js.Promise`
  generating a media request based on initialization data.

  `mediaKeySession.generateRequest().then(function) { ... });`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/generateRequest`"
  [this & args]
  (-> this .-generateRequest (.apply this (clj->js args))))

(defn load
  "Method.

  [Experimental]

  The MediaKeySession.load() method returns a `js.Promise` that
  to a boolean value after loading data for a specified session

  `mediaKeySession.load(sessionId).then(function(booleanValue) { ... });`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/load`"
  [this session-id]
  (-> this (.load session-id)))

(defn remove
  "Method.

  [Experimental]

  The MediaKeySession.remove() method returns a `js.Promise` after
  any session data associated with the current object.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/remove`"
  [this & args]
  (-> this .-remove (.apply this (clj->js args))))

(defn update
  "Method.

  [Experimental]

  The MediaKeySession.update() method loads messages and licenses
  the CDM, and then returns a `js.Promise` .

  `mediaKeySession.update(response).then(function() { ... });`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/update`"
  [this response]
  (-> this (.update response)))

(defn closed
  "Property.

  [Read Only]
  [Experimental]

  The MediaKeySession.closed read-only property returns a `js.Promise`
  when a `web.video.MediaKeySession` closes. This promise can only
  fulfilled and is never rejected. Closing a session means that
  and keys associated with it are no longer valid for decrypting
  data.

  `var promise = mediaKeySessionObj.closed;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/closed`"
  [this]
  (-> this (.-closed)))

(defn expiration
  "Property.

  [Read Only]
  [Experimental]

  The MediaKeySession.expiration read-only property returns the
  after which the keys in the current session can no longer be
  to decrypt media data, or NaN if no such time exists. This value
  determined by the CDM and measured in milliseconds since January
  1970, UTC. This value may change during a session lifetime, such
  when an action triggers the start of a window.

  `​var expirationTime = mediaKeySessionObj.expiration;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/expiration`"
  [this]
  (-> this (.-expiration)))

(defn key-statuses
  "Property.

  [Read Only]
  [Experimental]

  The MediaKeySession.keyStatuses read-only property returns a
  to a read-only `web.media.MediaKeyStatusMap` of the current session's
  and their statuses.

  `var mediaKeyStatusMapObj = mediaKeySessionObj.keyStatuses;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/keyStatuses`"
  [this]
  (-> this (.-keyStatuses)))

(defn session-id
  "Property.

  [Read Only]
  [Experimental]

  The MediaKeySession.sessionId read-only property contains a unique
  generated by the CDM for the current media object and its associated
  or licenses.

  `​var sessionId = mediaKeySessionObj.sessionId;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/sessionId`"
  [this]
  (-> this (.-sessionId)))

(defn onkeystatuseschange
  "Property.

  [Experimental]

  The onkeystatuseschange property of the `web.video.MediaKeySession`
  an event handler, fired whenever a keystatuschange event ocurrs,
  there has been a change in the keys or their statuses within
  session.

  `MediaKeySession.onkeystatuseschange = function(keystatuschange) { ... }`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/onkeystatuseschange`"
  [this]
  (-> this (.-onkeystatuseschange)))

(defn set-onkeystatuseschange!
  "Property.

  [Experimental]

  The onkeystatuseschange property of the `web.video.MediaKeySession`
  an event handler, fired whenever a keystatuschange event ocurrs,
  there has been a change in the keys or their statuses within
  session.

  `MediaKeySession.onkeystatuseschange = function(keystatuschange) { ... }`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/onkeystatuseschange`"
  [this val]
  (aset this "onkeystatuseschange" val))

(defn onmessage
  "Property.

  [Experimental]

  The onmessage property of the `web.video.MediaKeySession` is
  event handler, fired whenever a `web.media.MediaKeyMessageEvent`
  denoting a message is generated by the content decryption module.

  `MediaKeySession.onmessage = function(MediaKeyMessageEvent) { ... }`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/onmessage`"
  [this]
  (-> this (.-onmessage)))

(defn set-onmessage!
  "Property.

  [Experimental]

  The onmessage property of the `web.video.MediaKeySession` is
  event handler, fired whenever a `web.media.MediaKeyMessageEvent`
  denoting a message is generated by the content decryption module.

  `MediaKeySession.onmessage = function(MediaKeyMessageEvent) { ... }`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/MediaKeySession/onmessage`"
  [this val]
  (aset this "onmessage" val))

