(ns web.resize.ResizeObserver
  "The ResizeObserver interface reports changes to the dimensions
  an `web.Element`'s content or border box, or the bounding box
  an `web.svg.SVGElement`."
  (:refer-clojure :exclude []))

(defn constructor
  "Constructor.

  The ResizeObserver constructor creates a new `web.resize.ResizeObserver` object, which can be used to report changes to the content or border box of an `web.Element` or the bounding box of an `web.svg.SVGElement`.

  callback
  The function called whenever an observed resize occurs. The function is called with two parameters:

  entries
  An array of `web.resize.ResizeObserverEntry` objects that can be used to access the new dimensions of the element after each change.
  observer
  A reference to the ResizeObserver itself, so it will definitely be accessible from inside the callback, should you need it. This could be used for example to automatically unobserve the observer when a certain condition is reached, but you can omit it if you don't need it.


  The callback will generally follow a pattern along the lines of:



  function(entries, observer) {
  for (let entry of entries) {
  // Do something to each entry
  // and possibly something to the observer itself
  }
  }

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver/ResizeObserver`"
  [& args]
  (new (js/Function.prototype.bind.apply js/ResizeObserver (clj->js args))))

(defn disconnect
  "Method.

  The disconnect() method of the `web.resize.ResizeObserver` interface
  all observed `web.Element` or `web.svg.SVGElement` targets.

  `resizeObserver.disconnect();`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver/disconnect`"
  [this ]
  (-> this (.disconnect)))

(defn observe
  "Method.

  The observe() method of the `web.resize.ResizeObserver` interface
  observing the specified `web.Element` or `web.svg.SVGElement`.

  `resizeObserver.observe(target, options);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver/observe`"
  [this target options]
  (-> this (.observe target options)))

(defn unobserve
  "Method.

  The unobserve() method of the `web.resize.ResizeObserver` interface
  the observing of a specified `web.Element` or `web.svg.SVGElement`.

  `void unobserve(target);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver/unobserve`"
  [this target]
  (-> this (.unobserve target)))

