(ns web.media.AudioTrack
  "The AudioTrack interface represents a single audio track from
  of the HTML media elements, `<audio>` or `<video>`."
  (:refer-clojure :exclude []))

(defn enabled
  "Property.

  The `web.media.AudioTrack` property enabled specifies whether
  not the described audio track is currently enabled for use. If
  track is disabled by setting enabled to false, the track is muted
  does not produce audio.

  `isAudioEnabled = AudioTrack.enabled;

  AudioTrack.enabled = true | false;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/enabled`"
  [this]
  (-> this (.-enabled)))

(defn set-enabled!
  "Property.

  The `web.media.AudioTrack` property enabled specifies whether
  not the described audio track is currently enabled for use. If
  track is disabled by setting enabled to false, the track is muted
  does not produce audio.

  `isAudioEnabled = AudioTrack.enabled;

  AudioTrack.enabled = true | false;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/enabled`"
  [this val]
  (aset this "enabled" val))

(defn id
  "Property.

  [Read Only]

  The id property contains a string which uniquely identifies the
  represented by the `web.media.AudioTrack`.

  `var trackID = AudioTrack.id;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/id`"
  [this]
  (-> this (.-id)))

(defn kind
  "Property.

  [Read Only]

  The kind property contains a string indicating the category of
  contained in the `web.media.AudioTrack`.

  `var trackKind = AudioTrack.kind;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/kind`"
  [this]
  (-> this (.-kind)))

(defn label
  "Property.

  [Read Only]

  The read-only `web.media.AudioTrack` property label returns a
  specifying the audio track's human-readable label, if one is
  otherwise, it returns an empty string.

  `var audioTrackLabel = AudioTrack.label;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/label`"
  [this]
  (-> this (.-label)))

(defn language
  "Property.

  [Read Only]

  The read-only `web.media.AudioTrack` property language returns
  string identifying the language used in the audio track.

  `var audioTrackLanguage = AudioTrack.language;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/language`"
  [this]
  (-> this (.-language)))

(defn source-buffer
  "Property.

  [Read Only]

  The read-only `web.media.AudioTrack` property sourceBuffer returns
  `web.video.SourceBuffer` that created the track, or null if the
  was not created by a `web.video.SourceBuffer` or the `web.video.SourceBuffer`
  been removed from the `MediaSource.sourceBuffers` attribute of
  parent media source.

  `var sourceBuffer = AudioTrack.sourceBuffer;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/AudioTrack/sourceBuffer`"
  [this]
  (-> this (.-sourceBuffer)))

