(ns web.DOMException
  "The DOMException interface represents an abnormal event (called
  exception) which occurs as a result of calling a method or accessing
  property of a web API."
  (:refer-clojure :exclude [name]))

(defn constructor
  "Constructor.

  The DOMException() constructor returns a DOMException object with a specified message and name.

  message Optional
  A description of the exception. If not present, the empty string '' is used.
  name Optional
  Returns a `web.DOMString` that contains one of the strings associated with an error constant.

  Return value

  `web.DOMException`
  A newly created `web.DOMException` object.

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/DOMException/DOMException`"
  [& args]
  (new (js/Function.prototype.bind.apply js/DOMException (clj->js args))))

(defn code
  "Property.

  [Read Only]

  The code read-only property of the `web.DOMException` interface
  a short that contains one of the error code constants, or 0 if
  match. This field is used for historical reasons. New DOM exceptions
  use this anymore: they put this info in the `DOMException.name`

  `var domExceptionCode = domExceptionInstance.code;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/DOMException/code`"
  [this]
  (-> this (.-code)))

(defn message
  "Property.

  [Read Only]

  The message read-only property of the `web.DOMException` interface
  a `web.DOMString` representing a message or description associated
  the given error name.

  `var domExceptionMessage = domExceptionInstance.message;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/DOMException/message`"
  [this]
  (-> this (.-message)))

(defn name
  "Property.

  [Read Only]

  The name read-only property of the `web.DOMException` interface
  a `web.DOMString` that contains one of the strings associated
  an error name.

  `var domExceptionName = domExceptionInstance.name;`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/DOMException/name`"
  [this]
  (-> this (.-name)))

