/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.widget.ImageView;
import com.cjt2325.cameralibrary.listener.ErrorListener;
import com.cjt2325.cameralibrary.util.AngleUtil;
import com.cjt2325.cameralibrary.util.CameraParamUtil;
import com.cjt2325.cameralibrary.util.CheckPermission;
import com.cjt2325.cameralibrary.util.DeviceUtil;
import com.cjt2325.cameralibrary.util.FileUtil;
import com.cjt2325.cameralibrary.util.LogUtil;
import com.cjt2325.cameralibrary.util.ScreenUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CameraInterface
implements Camera.PreviewCallback {
    private static final String TAG = "CJT";
    private static volatile CameraInterface mCameraInterface;
    private Camera mCamera;
    private Camera.Parameters mParams;
    private boolean isPreviewing = false;
    private int SELECTED_CAMERA = -1;
    private int CAMERA_POST_POSITION = -1;
    private int CAMERA_FRONT_POSITION = -1;
    private SurfaceHolder mHolder = null;
    private float screenProp = -1.0f;
    private boolean isRecorder = false;
    private MediaRecorder mediaRecorder;
    private String videoFileName;
    private String saveVideoPath;
    private String videoFileAbsPath;
    private Bitmap videoFirstFrame = null;
    private ErrorListener errorLisenter;
    private ImageView mSwitchView;
    private ImageView mFlashLamp;
    private int preview_width;
    private int preview_height;
    private int angle = 0;
    private int cameraAngle = 90;
    private int rotation = 0;
    private byte[] firstFrame_data;
    public static final int TYPE_RECORDER = 144;
    public static final int TYPE_CAPTURE = 145;
    private int nowScaleRate = 0;
    private int recordScleRate = 0;
    private int mediaQuality = 1600000;
    private SensorManager sm = null;
    private SensorEventListener sensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (1 != event.sensor.getType()) {
                return;
            }
            float[] values = event.values;
            CameraInterface.this.angle = AngleUtil.getSensorAngle(values[0], values[1]);
            CameraInterface.this.rotationAnimation();
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private int nowAngle;
    int handlerTime = 0;

    public static void destroyCameraInterface() {
        if (mCameraInterface != null) {
            mCameraInterface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CameraInterface getInstance() {
        if (mCameraInterface != null) return mCameraInterface;
        Class<CameraInterface> clazz = CameraInterface.class;
        synchronized (CameraInterface.class) {
            if (mCameraInterface != null) return mCameraInterface;
            mCameraInterface = new CameraInterface();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mCameraInterface;
        }
    }

    public void setSwitchView(ImageView mSwitchView, ImageView mFlashLamp) {
        this.mSwitchView = mSwitchView;
        this.mFlashLamp = mFlashLamp;
        if (mSwitchView != null) {
            this.cameraAngle = CameraParamUtil.getInstance().getCameraDisplayOrientation(mSwitchView.getContext(), this.SELECTED_CAMERA);
        }
    }

    private void rotationAnimation() {
        if (this.mSwitchView == null) {
            return;
        }
        if (this.rotation != this.angle) {
            int start_rotaion = 0;
            int end_rotation = 0;
            block0 : switch (this.rotation) {
                case 0: {
                    start_rotaion = 0;
                    switch (this.angle) {
                        case 90: {
                            end_rotation = -90;
                            break;
                        }
                        case 270: {
                            end_rotation = 90;
                        }
                    }
                    break;
                }
                case 90: {
                    start_rotaion = -90;
                    switch (this.angle) {
                        case 0: {
                            end_rotation = 0;
                            break;
                        }
                        case 180: {
                            end_rotation = -180;
                        }
                    }
                    break;
                }
                case 180: {
                    start_rotaion = 180;
                    switch (this.angle) {
                        case 90: {
                            end_rotation = 270;
                            break;
                        }
                        case 270: {
                            end_rotation = 90;
                        }
                    }
                    break;
                }
                case 270: {
                    start_rotaion = 90;
                    switch (this.angle) {
                        case 0: {
                            end_rotation = 0;
                            break block0;
                        }
                        case 180: {
                            end_rotation = 180;
                        }
                    }
                }
            }
            ObjectAnimator animC = ObjectAnimator.ofFloat((Object)this.mSwitchView, (String)"rotation", (float[])new float[]{start_rotaion, end_rotation});
            ObjectAnimator animF = ObjectAnimator.ofFloat((Object)this.mFlashLamp, (String)"rotation", (float[])new float[]{start_rotaion, end_rotation});
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{animC, animF});
            set.setDuration(500L);
            set.start();
            this.rotation = this.angle;
        }
    }

    void setSaveVideoPath(String saveVideoPath) {
        this.saveVideoPath = saveVideoPath;
        File file = new File(saveVideoPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void setZoom(float zoom, int type) {
        if (this.mCamera == null) {
            return;
        }
        if (this.mParams == null) {
            this.mParams = this.mCamera.getParameters();
        }
        if (!this.mParams.isZoomSupported() || !this.mParams.isSmoothZoomSupported()) {
            return;
        }
        switch (type) {
            case 144: {
                int scaleRate;
                if (!this.isRecorder) {
                    return;
                }
                if (!(zoom >= 0.0f) || (scaleRate = (int)(zoom / 40.0f)) > this.mParams.getMaxZoom() || scaleRate < this.nowScaleRate || this.recordScleRate == scaleRate) break;
                this.mParams.setZoom(scaleRate);
                this.mCamera.setParameters(this.mParams);
                this.recordScleRate = scaleRate;
                break;
            }
            case 145: {
                if (this.isRecorder) {
                    return;
                }
                int scaleRate = (int)(zoom / 50.0f);
                if (scaleRate < this.mParams.getMaxZoom()) {
                    this.nowScaleRate += scaleRate;
                    if (this.nowScaleRate < 0) {
                        this.nowScaleRate = 0;
                    } else if (this.nowScaleRate > this.mParams.getMaxZoom()) {
                        this.nowScaleRate = this.mParams.getMaxZoom();
                    }
                    this.mParams.setZoom(this.nowScaleRate);
                    this.mCamera.setParameters(this.mParams);
                }
                LogUtil.i("setZoom = " + this.nowScaleRate);
            }
        }
    }

    void setMediaQuality(int quality) {
        this.mediaQuality = quality;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.firstFrame_data = data;
    }

    public void setFlashMode(String flashMode) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        params.setFlashMode(flashMode);
        this.mCamera.setParameters(params);
    }

    private CameraInterface() {
        this.findAvailableCameras();
        this.SELECTED_CAMERA = this.CAMERA_POST_POSITION;
        this.saveVideoPath = "";
    }

    void doOpenCamera(CameraOpenOverCallback callback) {
        if (Build.VERSION.SDK_INT < 23 && !CheckPermission.isCameraUseable(this.SELECTED_CAMERA) && this.errorLisenter != null) {
            this.errorLisenter.onError();
            return;
        }
        if (this.mCamera == null) {
            this.openCamera(this.SELECTED_CAMERA);
        }
        callback.cameraHasOpened();
    }

    private void setFlashModel() {
        this.mParams = this.mCamera.getParameters();
        this.mParams.setFlashMode("torch");
        this.mCamera.setParameters(this.mParams);
    }

    private synchronized void openCamera(int id) {
        block5: {
            try {
                this.mCamera = Camera.open((int)id);
            }
            catch (Exception var3) {
                var3.printStackTrace();
                if (this.errorLisenter == null) break block5;
                this.errorLisenter.onError();
            }
        }
        if (Build.VERSION.SDK_INT > 17 && this.mCamera != null) {
            try {
                this.mCamera.enableShutterSound(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"enable shutter sound faild");
            }
        }
    }

    public synchronized void switchCamera(SurfaceHolder holder, float screenProp) {
        this.SELECTED_CAMERA = this.SELECTED_CAMERA == this.CAMERA_POST_POSITION ? this.CAMERA_FRONT_POSITION : this.CAMERA_POST_POSITION;
        this.doDestroyCamera();
        LogUtil.i("open start");
        this.openCamera(this.SELECTED_CAMERA);
        if (Build.VERSION.SDK_INT > 17 && this.mCamera != null) {
            try {
                this.mCamera.enableShutterSound(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LogUtil.i("open end");
        this.doStartPreview(holder, screenProp);
    }

    public void doStartPreview(SurfaceHolder holder, float screenProp) {
        if (this.isPreviewing) {
            LogUtil.i("doStartPreview isPreviewing");
        }
        if (this.screenProp < 0.0f) {
            this.screenProp = screenProp;
        }
        if (holder == null) {
            return;
        }
        this.mHolder = holder;
        if (this.mCamera != null) {
            try {
                this.mParams = this.mCamera.getParameters();
                Camera.Size previewSize = CameraParamUtil.getInstance().getPreviewSize(this.mParams.getSupportedPreviewSizes(), 1000, screenProp);
                Camera.Size pictureSize = CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedPictureSizes(), 1200, screenProp);
                this.mParams.setPreviewSize(previewSize.width, previewSize.height);
                this.preview_width = previewSize.width;
                this.preview_height = previewSize.height;
                this.mParams.setPictureSize(pictureSize.width, pictureSize.height);
                if (CameraParamUtil.getInstance().isSupportedFocusMode(this.mParams.getSupportedFocusModes(), "auto")) {
                    this.mParams.setFocusMode("auto");
                }
                if (CameraParamUtil.getInstance().isSupportedPictureFormats(this.mParams.getSupportedPictureFormats(), 256)) {
                    this.mParams.setPictureFormat(256);
                    this.mParams.setJpegQuality(100);
                }
                this.mCamera.setParameters(this.mParams);
                this.mParams = this.mCamera.getParameters();
                this.mCamera.setPreviewDisplay(holder);
                this.mCamera.setDisplayOrientation(this.cameraAngle);
                this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
                this.mCamera.startPreview();
                this.isPreviewing = true;
                Log.i((String)TAG, (String)"=== Start Preview ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doStopPreview() {
        if (null != this.mCamera) {
            try {
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
                this.isPreviewing = false;
                Log.i((String)TAG, (String)"=== Stop Preview ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void doDestroyCamera() {
        this.errorLisenter = null;
        if (null != this.mCamera) {
            try {
                this.mCamera.setPreviewCallback(null);
                this.mSwitchView = null;
                this.mFlashLamp = null;
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
                this.mHolder = null;
                this.isPreviewing = false;
                this.mCamera.release();
                this.mCamera = null;
                Log.i((String)TAG, (String)"=== Destroy Camera ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.i((String)TAG, (String)"=== Camera  Null===");
        }
    }

    public void takePicture(final TakePictureCallback callback) {
        if (this.mCamera == null) {
            return;
        }
        switch (this.cameraAngle) {
            case 90: {
                this.nowAngle = Math.abs(this.angle + this.cameraAngle) % 360;
                break;
            }
            case 270: {
                this.nowAngle = Math.abs(this.cameraAngle - this.angle);
            }
        }
        Log.i((String)TAG, (String)(this.angle + " = " + this.cameraAngle + " = " + this.nowAngle));
        this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                Matrix matrix = new Matrix();
                if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_POST_POSITION) {
                    matrix.setRotate((float)CameraInterface.this.nowAngle);
                } else if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_FRONT_POSITION) {
                    matrix.setRotate((float)(360 - CameraInterface.this.nowAngle));
                    matrix.postScale(-1.0f, 1.0f);
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (callback != null) {
                    if (CameraInterface.this.nowAngle == 90 || CameraInterface.this.nowAngle == 270) {
                        callback.captureResult(bitmap, true);
                    } else {
                        callback.captureResult(bitmap, false);
                    }
                }
            }
        });
    }

    public void startRecord(Surface surface, float screenProp, ErrorCallback callback) {
        List focusModes;
        this.mCamera.setPreviewCallback(null);
        int nowAngle = (this.angle + 90) % 360;
        Camera.Parameters parameters = this.mCamera.getParameters();
        int width = parameters.getPreviewSize().width;
        int height = parameters.getPreviewSize().height;
        YuvImage yuv = new YuvImage(this.firstFrame_data, parameters.getPreviewFormat(), width, height, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuv.compressToJpeg(new Rect(0, 0, width, height), 50, (OutputStream)out);
        byte[] bytes = out.toByteArray();
        this.videoFirstFrame = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        Matrix matrix = new Matrix();
        if (this.SELECTED_CAMERA == this.CAMERA_POST_POSITION) {
            matrix.setRotate((float)nowAngle);
        } else if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            matrix.setRotate(270.0f);
        }
        this.videoFirstFrame = Bitmap.createBitmap((Bitmap)this.videoFirstFrame, (int)0, (int)0, (int)this.videoFirstFrame.getWidth(), (int)this.videoFirstFrame.getHeight(), (Matrix)matrix, (boolean)true);
        if (this.isRecorder) {
            return;
        }
        if (this.mCamera == null) {
            this.openCamera(this.SELECTED_CAMERA);
        }
        if (this.mediaRecorder == null) {
            this.mediaRecorder = new MediaRecorder();
        }
        if (this.mParams == null) {
            this.mParams = this.mCamera.getParameters();
        }
        if ((focusModes = this.mParams.getSupportedFocusModes()).contains("continuous-video")) {
            this.mParams.setFocusMode("continuous-video");
        }
        this.mCamera.setParameters(this.mParams);
        this.mCamera.unlock();
        this.mediaRecorder.reset();
        this.mediaRecorder.setCamera(this.mCamera);
        this.mediaRecorder.setVideoSource(1);
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(2);
        this.mediaRecorder.setVideoEncoder(2);
        this.mediaRecorder.setAudioEncoder(3);
        Camera.Size videoSize = this.mParams.getSupportedVideoSizes() == null ? CameraParamUtil.getInstance().getPreviewSize(this.mParams.getSupportedPreviewSizes(), 600, screenProp) : CameraParamUtil.getInstance().getPreviewSize(this.mParams.getSupportedVideoSizes(), 600, screenProp);
        Log.i((String)TAG, (String)("setVideoSize    width = " + videoSize.width + "height = " + videoSize.height));
        if (videoSize.width == videoSize.height) {
            this.mediaRecorder.setVideoSize(this.preview_width, this.preview_height);
        } else {
            this.mediaRecorder.setVideoSize(videoSize.width, videoSize.height);
        }
        if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            if (this.cameraAngle == 270) {
                if (nowAngle == 0) {
                    this.mediaRecorder.setOrientationHint(180);
                } else if (nowAngle == 270) {
                    this.mediaRecorder.setOrientationHint(270);
                } else {
                    this.mediaRecorder.setOrientationHint(90);
                }
            } else if (nowAngle == 90) {
                this.mediaRecorder.setOrientationHint(270);
            } else if (nowAngle == 270) {
                this.mediaRecorder.setOrientationHint(90);
            } else {
                this.mediaRecorder.setOrientationHint(nowAngle);
            }
        } else {
            this.mediaRecorder.setOrientationHint(nowAngle);
        }
        if (DeviceUtil.isHuaWeiRongyao()) {
            this.mediaRecorder.setVideoEncodingBitRate(400000);
        } else {
            this.mediaRecorder.setVideoEncodingBitRate(this.mediaQuality);
        }
        this.mediaRecorder.setPreviewDisplay(surface);
        this.videoFileName = "video_" + System.currentTimeMillis() + ".mp4";
        if (this.saveVideoPath.equals("")) {
            this.saveVideoPath = Environment.getExternalStorageDirectory().getPath();
        }
        this.videoFileAbsPath = this.saveVideoPath + File.separator + this.videoFileName;
        this.mediaRecorder.setOutputFile(this.videoFileAbsPath);
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.isRecorder = true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)"startRecord IllegalStateException");
            if (this.errorLisenter != null) {
                this.errorLisenter.onError();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)"startRecord IOException");
            if (this.errorLisenter != null) {
                this.errorLisenter.onError();
            }
        }
        catch (RuntimeException e) {
            Log.i((String)TAG, (String)"startRecord RuntimeException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecord(boolean isShort, StopRecordCallback callback) {
        if (!this.isRecorder) {
            return;
        }
        if (this.mediaRecorder != null) {
            this.mediaRecorder.setOnErrorListener(null);
            this.mediaRecorder.setOnInfoListener(null);
            this.mediaRecorder.setPreviewDisplay(null);
            try {
                this.mediaRecorder.stop();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.mediaRecorder = null;
                this.mediaRecorder = new MediaRecorder();
            }
            finally {
                if (this.mediaRecorder != null) {
                    this.mediaRecorder.release();
                }
                this.mediaRecorder = null;
                this.isRecorder = false;
            }
            if (isShort) {
                if (FileUtil.deleteFile(this.videoFileAbsPath)) {
                    callback.recordResult(null, null);
                }
                return;
            }
            this.doStopPreview();
            String fileName = this.saveVideoPath + File.separator + this.videoFileName;
            callback.recordResult(fileName, this.videoFirstFrame);
        }
    }

    private void findAvailableCameras() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int cameraNum = Camera.getNumberOfCameras();
        block4: for (int i = 0; i < cameraNum; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            switch (info.facing) {
                case 1: {
                    this.CAMERA_FRONT_POSITION = info.facing;
                    continue block4;
                }
                case 0: {
                    this.CAMERA_POST_POSITION = info.facing;
                }
            }
        }
    }

    public void handleFocus(final Context context, final float x, final float y, final FocusCallback callback) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        Rect focusRect = CameraInterface.calculateTapArea(x, y, 1.0f, context);
        this.mCamera.cancelAutoFocus();
        if (params.getMaxNumFocusAreas() <= 0) {
            Log.i((String)TAG, (String)"focus areas not supported");
            callback.focusSuccess();
            return;
        }
        ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
        focusAreas.add(new Camera.Area(focusRect, 800));
        params.setFocusAreas(focusAreas);
        final String currentFocusMode = params.getFocusMode();
        try {
            params.setFocusMode("auto");
            this.mCamera.setParameters(params);
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    if (success || CameraInterface.this.handlerTime > 10) {
                        Camera.Parameters params = camera.getParameters();
                        params.setFocusMode(currentFocusMode);
                        camera.setParameters(params);
                        CameraInterface.this.handlerTime = 0;
                        callback.focusSuccess();
                    } else {
                        ++CameraInterface.this.handlerTime;
                        CameraInterface.this.handleFocus(context, x, y, callback);
                    }
                }
            });
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"autoFocus failer");
        }
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, Context context) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)ScreenUtils.getScreenWidth(context) * 2000.0f - 1000.0f);
        int centerY = (int)(y / (float)ScreenUtils.getScreenHeight(context) * 2000.0f - 1000.0f);
        int left = CameraInterface.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = CameraInterface.clamp(centerY - areaSize / 2, -1000, 1000);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    void setErrorLinsenter(ErrorListener errorLisenter) {
        this.errorLisenter = errorLisenter;
    }

    void registerSensorManager(Context context) {
        if (this.sm == null) {
            this.sm = (SensorManager)context.getSystemService("sensor");
        }
        this.sm.registerListener(this.sensorEventListener, this.sm.getDefaultSensor(1), 3);
    }

    void unregisterSensorManager(Context context) {
        if (this.sm == null) {
            this.sm = (SensorManager)context.getSystemService("sensor");
        }
        this.sm.unregisterListener(this.sensorEventListener);
    }

    void isPreview(boolean res) {
        this.isPreviewing = res;
    }

    public static interface FocusCallback {
        public void focusSuccess();
    }

    public static interface TakePictureCallback {
        public void captureResult(Bitmap var1, boolean var2);
    }

    static interface ErrorCallback {
        public void onError();
    }

    public static interface StopRecordCallback {
        public void recordResult(String var1, Bitmap var2);
    }

    public static interface CameraOpenOverCallback {
        public void cameraHasOpened();
    }
}

