/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.cjt2325.cameralibrary.util.ScreenUtils;

public class FoucsView
extends View {
    private int size;
    private int center_x;
    private int center_y;
    private int length;
    private Paint mPaint;

    public FoucsView(Context context) {
        this(context, null);
    }

    public FoucsView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoucsView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.size = ScreenUtils.getScreenWidth(context) / 6;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(-300503530);
        this.mPaint.setStrokeWidth(4.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.center_x = (int)((double)this.size / 2.0);
        this.center_y = (int)((double)this.size / 2.0);
        this.length = (int)((double)this.size / 2.0) - 2;
        this.setMeasuredDimension(this.size, this.size);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect((float)(this.center_x - this.length), (float)(this.center_y - this.length), (float)(this.center_x + this.length), (float)(this.center_y + this.length), this.mPaint);
        canvas.drawLine(2.0f, (float)(this.getHeight() / 2), (float)(this.size / 10), (float)(this.getHeight() / 2), this.mPaint);
        canvas.drawLine((float)(this.getWidth() - 2), (float)(this.getHeight() / 2), (float)(this.getWidth() - this.size / 10), (float)(this.getHeight() / 2), this.mPaint);
        canvas.drawLine((float)(this.getWidth() / 2), 2.0f, (float)(this.getWidth() / 2), (float)(this.size / 10), this.mPaint);
        canvas.drawLine((float)(this.getWidth() / 2), (float)(this.getHeight() - 2), (float)(this.getWidth() / 2), (float)(this.getHeight() - this.size / 10), this.mPaint);
    }
}

