/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary.util;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.WindowManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraParamUtil {
    private static final String TAG = "JCameraView";
    private CameraSizeComparator sizeComparator = new CameraSizeComparator();
    private static CameraParamUtil cameraParamUtil = null;

    private CameraParamUtil() {
    }

    public static CameraParamUtil getInstance() {
        if (cameraParamUtil == null) {
            cameraParamUtil = new CameraParamUtil();
            return cameraParamUtil;
        }
        return cameraParamUtil;
    }

    public Camera.Size getPreviewSize(List<Camera.Size> list, int th, float rate) {
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Preview :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        if (i == list.size()) {
            return this.getBestSize(list, rate);
        }
        return list.get(i);
    }

    public Camera.Size getPictureSize(List<Camera.Size> list, int th, float rate) {
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Picture :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        if (i == list.size()) {
            return this.getBestSize(list, rate);
        }
        return list.get(i);
    }

    private Camera.Size getBestSize(List<Camera.Size> list, float rate) {
        float previewDisparity = 100.0f;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            Camera.Size cur = list.get(i);
            float prop = (float)cur.width / (float)cur.height;
            if (!(Math.abs(rate - prop) < previewDisparity)) continue;
            previewDisparity = Math.abs(rate - prop);
            index = i;
        }
        return list.get(index);
    }

    private boolean equalRate(Camera.Size s, float rate) {
        float r = (float)s.width / (float)s.height;
        return (double)Math.abs(r - rate) <= 0.2;
    }

    public boolean isSupportedFocusMode(List<String> focusList, String focusMode) {
        for (int i = 0; i < focusList.size(); ++i) {
            if (!focusMode.equals(focusList.get(i))) continue;
            Log.i((String)TAG, (String)("FocusMode supported " + focusMode));
            return true;
        }
        Log.i((String)TAG, (String)("FocusMode not supported " + focusMode));
        return false;
    }

    public boolean isSupportedPictureFormats(List<Integer> supportedPictureFormats, int jpeg) {
        for (int i = 0; i < supportedPictureFormats.size(); ++i) {
            if (jpeg != supportedPictureFormats.get(i)) continue;
            Log.i((String)TAG, (String)("Formats supported " + jpeg));
            return true;
        }
        Log.i((String)TAG, (String)("Formats not supported " + jpeg));
        return false;
    }

    public int getCameraDisplayOrientation(Context context, int cameraId) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int rotation = wm.getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private class CameraSizeComparator
    implements Comparator<Camera.Size> {
        private CameraSizeComparator() {
        }

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            if (lhs.width == rhs.width) {
                return 0;
            }
            if (lhs.width > rhs.width) {
                return 1;
            }
            return -1;
        }
    }
}

