/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.CountDownTimer;
import android.view.MotionEvent;
import android.view.View;
import com.cjt2325.cameralibrary.lisenter.CaptureLisenter;
import com.cjt2325.cameralibrary.util.CheckPermission;
import com.cjt2325.cameralibrary.util.LogUtil;

public class CaptureButton
extends View {
    private int state;
    private int button_state;
    public static final int STATE_IDLE = 1;
    public static final int STATE_PRESS = 2;
    public static final int STATE_LONG_PRESS = 3;
    public static final int STATE_RECORDERING = 4;
    public static final int STATE_BAN = 5;
    private int progress_color = -300503530;
    private int outside_color = -287515428;
    private int inside_color = -1;
    private float event_Y;
    private Paint mPaint;
    private float strokeWidth;
    private int outside_add_size;
    private int inside_reduce_size;
    private float center_X;
    private float center_Y;
    private float button_radius;
    private float button_outside_radius;
    private float button_inside_radius;
    private int button_size;
    private float progress;
    private int duration;
    private int min_duration;
    private int recorded_time;
    private RectF rectF;
    private LongPressRunnable longPressRunnable;
    private CaptureLisenter captureLisenter;
    private RecordCountDownTimer timer;

    public CaptureButton(Context context) {
        super(context);
    }

    public CaptureButton(Context context, int size) {
        super(context);
        this.button_size = size;
        this.button_outside_radius = this.button_radius = (float)size / 2.0f;
        this.button_inside_radius = this.button_radius * 0.75f;
        this.strokeWidth = size / 15;
        this.outside_add_size = size / 5;
        this.inside_reduce_size = size / 8;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.progress = 0.0f;
        this.longPressRunnable = new LongPressRunnable();
        this.state = 1;
        this.button_state = 259;
        this.duration = 10000;
        this.min_duration = 1500;
        this.center_X = (this.button_size + this.outside_add_size * 2) / 2;
        this.center_Y = (this.button_size + this.outside_add_size * 2) / 2;
        this.rectF = new RectF(this.center_X - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_Y - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_X + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_Y + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f));
        this.timer = new RecordCountDownTimer(this.duration, this.duration / 360);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.button_size + this.outside_add_size * 2, this.button_size + this.outside_add_size * 2);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.outside_color);
        canvas.drawCircle(this.center_X, this.center_Y, this.button_outside_radius, this.mPaint);
        this.mPaint.setColor(this.inside_color);
        canvas.drawCircle(this.center_X, this.center_Y, this.button_inside_radius, this.mPaint);
        if (this.state == 4) {
            this.mPaint.setColor(this.progress_color);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.strokeWidth);
            canvas.drawArc(this.rectF, -90.0f, this.progress, false, this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                LogUtil.i("state = " + this.state);
                if (event.getPointerCount() > 1 || this.state != 1) break;
                this.event_Y = event.getY();
                this.state = 2;
                if (this.button_state != 258 && this.button_state != 259) break;
                this.postDelayed(this.longPressRunnable, 500L);
                break;
            }
            case 2: {
                if (this.captureLisenter == null || this.state != 4 || this.button_state != 258 && this.button_state != 259) break;
                this.captureLisenter.recordZoom(this.event_Y - event.getY());
                break;
            }
            case 1: {
                this.handlerUnpressByState();
            }
        }
        return true;
    }

    private void handlerUnpressByState() {
        this.removeCallbacks(this.longPressRunnable);
        switch (this.state) {
            case 2: {
                if (this.captureLisenter == null || this.button_state != 257 && this.button_state != 259) break;
                this.startCaptureAnimation(this.button_inside_radius);
                break;
            }
            case 4: {
                this.timer.cancel();
                this.recordEnd();
            }
        }
    }

    private void recordEnd() {
        if (this.captureLisenter != null) {
            if (this.recorded_time < this.min_duration) {
                this.captureLisenter.recordShort(this.recorded_time);
            } else {
                this.captureLisenter.recordEnd(this.recorded_time);
            }
        }
        this.resetRecordAnim();
    }

    private void resetRecordAnim() {
        this.state = 5;
        this.progress = 0.0f;
        this.invalidate();
        this.startRecordAnimation(this.button_outside_radius, this.button_radius, this.button_inside_radius, this.button_radius * 0.75f);
    }

    private void startCaptureAnimation(float inside_start) {
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_start * 0.75f, inside_start});
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.button_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        inside_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CaptureButton.this.captureLisenter.takePictures();
                CaptureButton.this.state = 5;
            }
        });
        inside_anim.setDuration(100L);
        inside_anim.start();
    }

    private void startRecordAnimation(float outside_start, float outside_end, float inside_start, float inside_end) {
        ValueAnimator outside_anim = ValueAnimator.ofFloat((float[])new float[]{outside_start, outside_end});
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_end});
        outside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.button_outside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.button_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (CaptureButton.this.state == 3) {
                    if (CaptureButton.this.captureLisenter != null) {
                        CaptureButton.this.captureLisenter.recordStart();
                    }
                    CaptureButton.this.state = 4;
                    CaptureButton.this.timer.start();
                }
            }
        });
        set.playTogether(new Animator[]{outside_anim, inside_anim});
        set.setDuration(100L);
        set.start();
    }

    private void updateProgress(long millisUntilFinished) {
        this.recorded_time = (int)((long)this.duration - millisUntilFinished);
        this.progress = 360.0f - (float)millisUntilFinished / (float)this.duration * 360.0f;
        this.invalidate();
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setMinDuration(int duration) {
        this.min_duration = duration;
    }

    public void setCaptureLisenter(CaptureLisenter captureLisenter) {
        this.captureLisenter = captureLisenter;
    }

    public void setButtonFeatures(int state) {
        this.button_state = state;
    }

    public boolean isIdle() {
        return this.state == 1;
    }

    public void resetState() {
        this.state = 1;
    }

    private class LongPressRunnable
    implements Runnable {
        private LongPressRunnable() {
        }

        @Override
        public void run() {
            CaptureButton.this.state = 3;
            if (CheckPermission.getRecordState() != 1) {
                CaptureButton.this.state = 1;
                if (CaptureButton.this.captureLisenter != null) {
                    CaptureButton.this.captureLisenter.recordError();
                    return;
                }
            }
            CaptureButton.this.startRecordAnimation(CaptureButton.this.button_outside_radius, CaptureButton.this.button_outside_radius + (float)CaptureButton.this.outside_add_size, CaptureButton.this.button_inside_radius, CaptureButton.this.button_inside_radius - (float)CaptureButton.this.inside_reduce_size);
        }
    }

    private class RecordCountDownTimer
    extends CountDownTimer {
        RecordCountDownTimer(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }

        public void onTick(long millisUntilFinished) {
            CaptureButton.this.updateProgress(millisUntilFinished);
        }

        public void onFinish() {
            CaptureButton.this.updateProgress(0L);
            CaptureButton.this.recordEnd();
        }
    }
}

