/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.VideoView;
import com.cjt2325.cameralibrary.CameraInterface;
import com.cjt2325.cameralibrary.CaptureLayout;
import com.cjt2325.cameralibrary.FoucsView;
import com.cjt2325.cameralibrary.R;
import com.cjt2325.cameralibrary.lisenter.CaptureLisenter;
import com.cjt2325.cameralibrary.lisenter.ErrorLisenter;
import com.cjt2325.cameralibrary.lisenter.JCameraLisenter;
import com.cjt2325.cameralibrary.lisenter.ReturnLisenter;
import com.cjt2325.cameralibrary.lisenter.TypeLisenter;
import java.io.File;
import java.io.IOException;

public class JCameraView
extends FrameLayout
implements CameraInterface.CamOpenOverCallback,
SurfaceHolder.Callback {
    private static final String TAG = "CJT";
    private static final int TYPE_PICTURE = 1;
    private static final int TYPE_VIDEO = 2;
    public static final int MEDIA_QUALITY_HIGH = 2000000;
    public static final int MEDIA_QUALITY_MIDDLE = 1600000;
    public static final int MEDIA_QUALITY_LOW = 1200000;
    public static final int MEDIA_QUALITY_POOR = 800000;
    public static final int MEDIA_QUALITY_FUNNY = 400000;
    public static final int MEDIA_QUALITY_DESPAIR = 200000;
    public static final int MEDIA_QUALITY_SORRY = 80000;
    public static final int MEDIA_QUALITY_SORRY_YOU_ARE_GOOD_MAN = 10000;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private JCameraLisenter jCameraLisenter;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private CaptureLayout mCaptureLayout;
    private FoucsView mFoucsView;
    private MediaPlayer mMediaPlayer;
    private int layout_width;
    private int fouce_size;
    private float screenProp;
    private Bitmap captureBitmap;
    private String videoUrl;
    private int type = -1;
    private boolean onlyPause = false;
    private int CAMERA_STATE = -1;
    private static final int STATE_IDLE = 16;
    private static final int STATE_RUNNING = 32;
    private static final int STATE_WAIT = 48;
    private boolean stopping = false;
    private boolean isBorrow = false;
    private boolean takePictureing = false;
    private boolean forbiddenSwitch = false;
    private int iconSize = 0;
    private int iconMargin = 0;
    private int iconSrc = 0;
    private int duration = 0;
    private boolean switching = false;
    private boolean firstTouch = true;
    private float firstTouchLength = 0.0f;
    private int zoomScale = 0;
    private ErrorLisenter errorLisenter;

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.JCameraView, defStyleAttr, 0);
        this.iconSize = a.getDimensionPixelSize(R.styleable.JCameraView_iconSize, (int)TypedValue.applyDimension((int)2, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconMargin = a.getDimensionPixelSize(R.styleable.JCameraView_iconMargin, (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconSrc = a.getResourceId(R.styleable.JCameraView_iconSrc, R.drawable.ic_sync_black_24dp);
        this.duration = a.getInteger(R.styleable.JCameraView_duration_max, 10000);
        a.recycle();
        this.initData();
        this.initView();
    }

    private void initData() {
        WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        this.layout_width = outMetrics.widthPixels;
        this.fouce_size = this.layout_width / 4;
        this.CAMERA_STATE = 16;
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setBackgroundColor(-16777216);
        this.mVideoView = new VideoView(this.mContext);
        FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, -1);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        this.mPhoto = new ImageView(this.mContext);
        FrameLayout.LayoutParams photoParam = new FrameLayout.LayoutParams(-1, -1);
        this.mPhoto.setLayoutParams((ViewGroup.LayoutParams)photoParam);
        this.mPhoto.setBackgroundColor(-16777216);
        this.mPhoto.setVisibility(4);
        this.mSwitchCamera = new ImageView(this.mContext);
        FrameLayout.LayoutParams imageViewParam = new FrameLayout.LayoutParams(this.iconSize + 2 * this.iconMargin, this.iconSize + 2 * this.iconMargin);
        imageViewParam.gravity = 5;
        this.mSwitchCamera.setPadding(this.iconMargin, this.iconMargin, this.iconMargin, this.iconMargin);
        this.mSwitchCamera.setLayoutParams((ViewGroup.LayoutParams)imageViewParam);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JCameraView.this.isBorrow || JCameraView.this.switching || JCameraView.this.forbiddenSwitch) {
                    return;
                }
                JCameraView.this.switching = true;
                new Thread(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().switchCamera(JCameraView.this);
                    }
                }.start();
            }
        });
        this.mCaptureLayout = new CaptureLayout(this.mContext);
        FrameLayout.LayoutParams layout_param = new FrameLayout.LayoutParams(-2, -2);
        layout_param.gravity = 81;
        this.mCaptureLayout.setLayoutParams((ViewGroup.LayoutParams)layout_param);
        this.mCaptureLayout.setDuration(this.duration);
        this.mFoucsView = new FoucsView(this.mContext, this.fouce_size);
        FrameLayout.LayoutParams foucs_param = new FrameLayout.LayoutParams(-2, -2);
        foucs_param.gravity = 17;
        this.mFoucsView.setLayoutParams((ViewGroup.LayoutParams)foucs_param);
        this.mFoucsView.setVisibility(0);
        this.addView((View)this.mVideoView);
        this.addView((View)this.mPhoto);
        this.addView((View)this.mSwitchCamera);
        this.addView((View)this.mCaptureLayout);
        this.addView(this.mFoucsView);
        this.mCaptureLayout.setCaptureLisenter(new CaptureLisenter(){

            @Override
            public void takePictures() {
                if (JCameraView.this.CAMERA_STATE != 16 || JCameraView.this.takePictureing) {
                    return;
                }
                JCameraView.this.CAMERA_STATE = 32;
                JCameraView.this.takePictureing = true;
                JCameraView.this.mFoucsView.setVisibility(4);
                CameraInterface.getInstance().takePicture(new CameraInterface.TakePictureCallback(){

                    @Override
                    public void captureResult(Bitmap bitmap, boolean isVertical) {
                        JCameraView.this.captureBitmap = bitmap;
                        CameraInterface.getInstance().doStopCamera();
                        JCameraView.this.type = 1;
                        JCameraView.this.isBorrow = true;
                        JCameraView.this.CAMERA_STATE = 48;
                        if (isVertical) {
                            JCameraView.this.mPhoto.setScaleType(ImageView.ScaleType.FIT_XY);
                        } else {
                            JCameraView.this.mPhoto.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        }
                        JCameraView.this.mPhoto.setImageBitmap(bitmap);
                        JCameraView.this.mPhoto.setVisibility(0);
                        JCameraView.this.mCaptureLayout.startAlphaAnimation();
                        JCameraView.this.mCaptureLayout.startTypeBtnAnimator();
                        JCameraView.this.takePictureing = false;
                        JCameraView.this.mSwitchCamera.setVisibility(4);
                        CameraInterface.getInstance().doOpenCamera(JCameraView.this);
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                if (JCameraView.this.CAMERA_STATE != 32 && JCameraView.this.stopping) {
                    return;
                }
                JCameraView.this.stopping = true;
                JCameraView.this.mCaptureLayout.setTextWithAnimation("\u5f55\u5236\u65f6\u95f4\u8fc7\u77ed");
                JCameraView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().stopRecord(true, new CameraInterface.StopRecordCallback(){

                            @Override
                            public void recordResult(String url) {
                                Log.i((String)JCameraView.TAG, (String)"Record Stopping ...");
                                JCameraView.this.mCaptureLayout.isRecord(false);
                                JCameraView.this.CAMERA_STATE = 16;
                                JCameraView.this.stopping = false;
                                JCameraView.this.isBorrow = false;
                            }
                        });
                    }
                }, 1500L - time);
            }

            @Override
            public void recordStart() {
                if (JCameraView.this.CAMERA_STATE != 16 && JCameraView.this.stopping) {
                    return;
                }
                JCameraView.this.mCaptureLayout.isRecord(true);
                JCameraView.this.isBorrow = true;
                JCameraView.this.CAMERA_STATE = 32;
                JCameraView.this.mFoucsView.setVisibility(4);
                CameraInterface.getInstance().startRecord(JCameraView.this.mVideoView.getHolder().getSurface(), new CameraInterface.ErrorCallback(){

                    @Override
                    public void onError() {
                        Log.i((String)JCameraView.TAG, (String)"startRecorder error");
                        JCameraView.this.mCaptureLayout.isRecord(false);
                        JCameraView.this.CAMERA_STATE = 48;
                        JCameraView.this.stopping = false;
                        JCameraView.this.isBorrow = false;
                    }
                });
            }

            @Override
            public void recordEnd(long time) {
                CameraInterface.getInstance().stopRecord(false, new CameraInterface.StopRecordCallback(){

                    @Override
                    public void recordResult(final String url) {
                        JCameraView.this.CAMERA_STATE = 48;
                        JCameraView.this.videoUrl = url;
                        JCameraView.this.type = 2;
                        new Thread(new Runnable(){

                            @Override
                            @RequiresApi(api=16)
                            public void run() {
                                try {
                                    if (JCameraView.this.mMediaPlayer == null) {
                                        JCameraView.this.mMediaPlayer = new MediaPlayer();
                                    } else {
                                        JCameraView.this.mMediaPlayer.reset();
                                    }
                                    Log.i((String)JCameraView.TAG, (String)("URL = " + url));
                                    JCameraView.this.mMediaPlayer.setDataSource(url);
                                    JCameraView.this.mMediaPlayer.setSurface(JCameraView.this.mVideoView.getHolder().getSurface());
                                    JCameraView.this.mMediaPlayer.setVideoScalingMode(1);
                                    JCameraView.this.mMediaPlayer.setAudioStreamType(3);
                                    JCameraView.this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                                        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                                            JCameraView.this.updateVideoViewSize(JCameraView.this.mMediaPlayer.getVideoWidth(), JCameraView.this.mMediaPlayer.getVideoHeight());
                                        }
                                    });
                                    JCameraView.this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                                        public void onPrepared(MediaPlayer mp) {
                                            JCameraView.this.mMediaPlayer.start();
                                        }
                                    });
                                    JCameraView.this.mMediaPlayer.setLooping(true);
                                    JCameraView.this.mMediaPlayer.prepare();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                });
            }

            @Override
            public void recordZoom(float zoom) {
                CameraInterface.getInstance().setZoom(zoom, 144);
            }

            @Override
            public void recordError() {
                if (JCameraView.this.errorLisenter != null) {
                    JCameraView.this.errorLisenter.AudioPermissionError();
                }
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeLisenter(){

            @Override
            public void cancel() {
                if (JCameraView.this.CAMERA_STATE == 48) {
                    if (JCameraView.this.mMediaPlayer != null && JCameraView.this.mMediaPlayer.isPlaying()) {
                        JCameraView.this.mMediaPlayer.stop();
                        JCameraView.this.mMediaPlayer.release();
                        JCameraView.this.mMediaPlayer = null;
                    }
                    JCameraView.this.handlerPictureOrVideo(JCameraView.this.type, false);
                }
            }

            @Override
            public void confirm() {
                if (JCameraView.this.CAMERA_STATE == 48) {
                    if (JCameraView.this.mMediaPlayer != null && JCameraView.this.mMediaPlayer.isPlaying()) {
                        JCameraView.this.mMediaPlayer.stop();
                        JCameraView.this.mMediaPlayer.release();
                        JCameraView.this.mMediaPlayer = null;
                    }
                    JCameraView.this.handlerPictureOrVideo(JCameraView.this.type, true);
                }
            }
        });
        this.mCaptureLayout.setReturnLisenter(new ReturnLisenter(){

            @Override
            public void onReturn() {
                if (JCameraView.this.jCameraLisenter != null && !JCameraView.this.takePictureing) {
                    JCameraView.this.jCameraLisenter.quit();
                }
            }
        });
        this.mVideoView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.screenProp = heightSize / widthSize;
    }

    @Override
    public void cameraHasOpened() {
        CameraInterface.getInstance().doStartPreview(this.mVideoView.getHolder(), this.screenProp);
    }

    @Override
    public void cameraSwitchSuccess() {
        this.switching = false;
    }

    public void onResume() {
        CameraInterface.getInstance().registerSensorManager(this.mContext);
        CameraInterface.getInstance().setSwitchView(this.mSwitchCamera);
        if (this.onlyPause) {
            new Thread(){

                @Override
                public void run() {
                    CameraInterface.getInstance().doOpenCamera(JCameraView.this);
                }
            }.start();
        }
        this.mFoucsView.setVisibility(4);
    }

    public void onPause() {
        this.onlyPause = true;
        CameraInterface.getInstance().unregisterSensorManager(this.mContext);
        CameraInterface.getInstance().doStopCamera();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getPointerCount() == 1) {
                    this.setFocusViewWidthAnimation(event.getX(), event.getY());
                }
                if (event.getPointerCount() != 2) break;
                Log.i((String)TAG, (String)"ACTION_DOWN = 2");
                break;
            }
            case 2: {
                if (event.getPointerCount() == 1) {
                    this.firstTouch = true;
                }
                if (event.getPointerCount() != 2) break;
                float point_1_X = event.getX(0);
                float point_1_Y = event.getY(0);
                float point_2_X = event.getX(1);
                float point_2_Y = event.getY(1);
                float result = (float)Math.sqrt(Math.pow(point_1_X - point_2_X, 2.0) + Math.pow(point_1_Y - point_2_Y, 2.0));
                if (this.firstTouch) {
                    this.firstTouchLength = result;
                    this.firstTouch = false;
                }
                if ((int)(result - this.firstTouchLength) / 50 != 0) {
                    this.firstTouch = true;
                    CameraInterface.getInstance().setZoom(result - this.firstTouchLength, 145);
                }
                Log.i((String)TAG, (String)("result = " + (result - this.firstTouchLength)));
                break;
            }
            case 1: {
                this.firstTouch = true;
            }
        }
        return true;
    }

    private void setFocusViewWidthAnimation(float x, float y) {
        if (this.isBorrow) {
            return;
        }
        if (y > (float)this.mCaptureLayout.getTop()) {
            return;
        }
        this.mFoucsView.setVisibility(0);
        if (x < (float)(this.mFoucsView.getWidth() / 2)) {
            x = this.mFoucsView.getWidth() / 2;
        }
        if (x > (float)(this.layout_width - this.mFoucsView.getWidth() / 2)) {
            x = this.layout_width - this.mFoucsView.getWidth() / 2;
        }
        if (y < (float)(this.mFoucsView.getWidth() / 2)) {
            y = this.mFoucsView.getWidth() / 2;
        }
        if (y > (float)(this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2)) {
            y = this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2;
        }
        CameraInterface.getInstance().handleFocus(this.mContext, x, y, new CameraInterface.FocusCallback(){

            @Override
            public void focusSuccess() {
                JCameraView.this.mFoucsView.setVisibility(4);
            }
        });
        this.mFoucsView.setX(x - (float)(this.mFoucsView.getWidth() / 2));
        this.mFoucsView.setY(y - (float)(this.mFoucsView.getHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleX", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleY", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"alpha", (float[])new float[]{1.0f, 0.3f, 1.0f, 0.3f, 1.0f, 0.3f, 1.0f});
        AnimatorSet animSet = new AnimatorSet();
        animSet.play((Animator)scaleX).with((Animator)scaleY).before((Animator)alpha);
        animSet.setDuration(400L);
        animSet.start();
    }

    public void setJCameraLisenter(JCameraLisenter jCameraLisenter) {
        this.jCameraLisenter = jCameraLisenter;
    }

    private void handlerPictureOrVideo(int type, boolean confirm) {
        if (this.jCameraLisenter == null || type == -1) {
            return;
        }
        switch (type) {
            case 1: {
                this.mPhoto.setVisibility(4);
                if (confirm && this.captureBitmap != null) {
                    this.jCameraLisenter.captureSuccess(this.captureBitmap);
                    break;
                }
                if (this.captureBitmap != null) {
                    this.captureBitmap.recycle();
                }
                this.captureBitmap = null;
                break;
            }
            case 2: {
                if (confirm) {
                    this.jCameraLisenter.recordSuccess(this.videoUrl);
                } else {
                    File file = new File(this.videoUrl);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                this.mCaptureLayout.isRecord(false);
                FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, -1);
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
                CameraInterface.getInstance().doOpenCamera(this);
            }
        }
        this.isBorrow = false;
        this.mSwitchCamera.setVisibility(0);
        this.CAMERA_STATE = 16;
    }

    public void setSaveVideoPath(String path) {
        CameraInterface.getInstance().setSaveVideoPath(path);
    }

    public void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, height);
            videoViewParam.gravity = 17;
            this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void enableshutterSound(boolean enable) {
    }

    public void forbiddenSwitchCamera(boolean forbiddenSwitch) {
        this.forbiddenSwitch = forbiddenSwitch;
    }

    public void setErrorLisenter(ErrorLisenter errorLisenter) {
        this.errorLisenter = errorLisenter;
        CameraInterface.getInstance().setErrorLinsenter(errorLisenter);
    }

    public void setFeatures(int state) {
        this.mCaptureLayout.setButtonFeatures(state);
    }

    public void setMediaQuality(int quality) {
        CameraInterface.getInstance().setMediaQuality(quality);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.i((String)TAG, (String)"surfaceCreated");
        new Thread(){

            @Override
            public void run() {
                CameraInterface.getInstance().doOpenCamera(JCameraView.this);
            }
        }.start();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.onlyPause = false;
        Log.i((String)TAG, (String)"surfaceDestroyed");
        CameraInterface.getInstance().doDestroyCamera();
    }
}

