/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.widget.ImageView;
import com.cjt2325.cameralibrary.util.AngleUtil;
import com.cjt2325.cameralibrary.util.CameraParamUtil;
import com.cjt2325.cameralibrary.util.ScreenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CameraInterface {
    private static final String TAG = "CJT";
    private Camera mCamera;
    private Camera.Parameters mParams;
    private boolean isPreviewing = false;
    private static CameraInterface mCameraInterface;
    private int SELECTED_CAMERA = -1;
    private int CAMERA_POST_POSITION = -1;
    private int CAMERA_FRONT_POSITION = -1;
    private SurfaceHolder mHolder = null;
    private float screenProp = -1.0f;
    private boolean isRecorder = false;
    private MediaRecorder mediaRecorder;
    private String videoFileName;
    private String saveVideoPath;
    private String videoFileAbsPath;
    private ImageView mSwitchView;
    private int preview_width;
    private int preview_height;
    private int angle = 0;
    private int rotation = 0;
    private boolean error = false;
    private SensorManager sm = null;
    private SensorEventListener sensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (1 != event.sensor.getType()) {
                return;
            }
            float[] values = event.values;
            CameraInterface.this.angle = AngleUtil.getSensorAngle(values[0], values[1]);
            CameraInterface.this.rotationAnimation();
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    public static final int TYPE_RECORDER = 144;
    public static final int TYPE_CAPTURE = 145;
    private int nowScaleRate = 0;
    private int recordScleRate = 0;

    boolean isPreviewing() {
        return this.isPreviewing;
    }

    public void setSwitchView(ImageView mSwitchView) {
        this.mSwitchView = mSwitchView;
    }

    private void rotationAnimation() {
        if (this.mSwitchView == null) {
            return;
        }
        if (this.rotation != this.angle) {
            int start_rotaion = 0;
            int end_rotation = 0;
            block0 : switch (this.rotation) {
                case 0: {
                    start_rotaion = 0;
                    switch (this.angle) {
                        case 90: {
                            end_rotation = -90;
                            break;
                        }
                        case 270: {
                            end_rotation = 90;
                        }
                    }
                    break;
                }
                case 90: {
                    start_rotaion = -90;
                    switch (this.angle) {
                        case 0: {
                            end_rotation = 0;
                            break;
                        }
                        case 180: {
                            end_rotation = -180;
                        }
                    }
                    break;
                }
                case 180: {
                    start_rotaion = 180;
                    switch (this.angle) {
                        case 90: {
                            end_rotation = 270;
                            break;
                        }
                        case 270: {
                            end_rotation = 90;
                        }
                    }
                    break;
                }
                case 270: {
                    start_rotaion = 90;
                    switch (this.angle) {
                        case 0: {
                            end_rotation = 0;
                            break block0;
                        }
                        case 180: {
                            end_rotation = 180;
                        }
                    }
                }
            }
            ObjectAnimator anim = ObjectAnimator.ofFloat((Object)this.mSwitchView, (String)"rotation", (float[])new float[]{start_rotaion, end_rotation});
            anim.setDuration(500L);
            anim.start();
            this.rotation = this.angle;
        }
    }

    public void setSaveVideoPath(String saveVideoPath) {
        this.saveVideoPath = saveVideoPath;
        File file = new File(saveVideoPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void setZoom(float zoom, int type) {
        if (this.mCamera == null) {
            return;
        }
        if (this.mParams == null) {
            this.mParams = this.mCamera.getParameters();
        }
        if (!this.mParams.isZoomSupported() || !this.mParams.isSmoothZoomSupported()) {
            return;
        }
        switch (type) {
            case 144: {
                int scaleRate;
                if (!this.isRecorder) {
                    return;
                }
                if (!(zoom >= 0.0f) || (scaleRate = (int)(zoom / 50.0f)) > this.mParams.getMaxZoom() || scaleRate < this.nowScaleRate || this.recordScleRate == scaleRate) break;
                this.mParams.setZoom(scaleRate);
                this.mCamera.setParameters(this.mParams);
                this.recordScleRate = scaleRate;
                break;
            }
            case 145: {
                if (this.isRecorder) {
                    return;
                }
                int scaleRate = (int)(zoom / 50.0f);
                if (scaleRate < this.mParams.getMaxZoom()) {
                    this.nowScaleRate += scaleRate;
                    if (this.nowScaleRate < 0) {
                        this.nowScaleRate = 0;
                    } else if (this.nowScaleRate > this.mParams.getMaxZoom()) {
                        this.nowScaleRate = this.mParams.getMaxZoom();
                    }
                    this.mParams.setZoom(this.nowScaleRate);
                    this.mCamera.setParameters(this.mParams);
                }
                Log.i((String)TAG, (String)("nowScaleRate = " + this.nowScaleRate));
            }
        }
    }

    private CameraInterface() {
        this.findAvailableCameras();
        this.SELECTED_CAMERA = this.CAMERA_POST_POSITION;
        this.saveVideoPath = "";
    }

    public static synchronized CameraInterface getInstance() {
        if (mCameraInterface == null) {
            mCameraInterface = new CameraInterface();
        }
        return mCameraInterface;
    }

    void doOpenCamera(CamOpenOverCallback callback) {
        if (this.mCamera == null) {
            this.openCamera(this.SELECTED_CAMERA);
        }
        callback.cameraHasOpened();
    }

    private void openCamera(int id) {
        this.mCamera = Camera.open((int)id);
        if (Build.VERSION.SDK_INT > 17) {
            this.mCamera.enableShutterSound(false);
        }
    }

    public synchronized void switchCamera(CamOpenOverCallback callback) {
        this.SELECTED_CAMERA = this.SELECTED_CAMERA == this.CAMERA_POST_POSITION ? this.CAMERA_FRONT_POSITION : this.CAMERA_POST_POSITION;
        this.doStopCamera();
        this.mCamera = Camera.open((int)this.SELECTED_CAMERA);
        this.doStartPreview(this.mHolder, this.screenProp);
        callback.cameraSwitchSuccess();
    }

    void doStartPreview(SurfaceHolder holder, float screenProp) {
        if (this.screenProp < 0.0f) {
            this.screenProp = screenProp;
        }
        if (holder == null) {
            return;
        }
        this.mHolder = holder;
        if (this.mCamera != null) {
            try {
                this.mParams = this.mCamera.getParameters();
                Camera.Size previewSize = CameraParamUtil.getInstance().getPreviewSize(this.mParams.getSupportedPreviewSizes(), 1000, screenProp);
                Camera.Size pictureSize = CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedPictureSizes(), 1200, screenProp);
                this.mParams.setPreviewSize(previewSize.width, previewSize.height);
                this.preview_width = previewSize.width;
                this.preview_height = previewSize.height;
                this.mParams.setPictureSize(pictureSize.width, pictureSize.height);
                if (CameraParamUtil.getInstance().isSupportedFocusMode(this.mParams.getSupportedFocusModes(), "auto")) {
                    this.mParams.setFocusMode("auto");
                }
                if (CameraParamUtil.getInstance().isSupportedPictureFormats(this.mParams.getSupportedPictureFormats(), 256)) {
                    this.mParams.setPictureFormat(256);
                    this.mParams.setJpegQuality(100);
                }
                this.mCamera.setParameters(this.mParams);
                this.mParams = this.mCamera.getParameters();
                this.mCamera.setPreviewDisplay(holder);
                this.mCamera.setDisplayOrientation(90);
                this.mCamera.startPreview();
                this.isPreviewing = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.mCamera.stopPreview();
            }
        }
        Log.i((String)TAG, (String)"=== Start Preview ===");
    }

    public void doStopCamera() {
        if (null != this.mCamera) {
            try {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
                this.isPreviewing = false;
                this.mCamera.release();
                this.mCamera = null;
                Log.i((String)TAG, (String)"=== Stop Camera ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doDestroyCamera() {
        if (null != this.mCamera) {
            try {
                this.mSwitchView = null;
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
                this.mHolder = null;
                this.isPreviewing = false;
                this.mCamera.release();
                this.mCamera = null;
                Log.i((String)TAG, (String)"=== Destroy Camera ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void takePicture(final TakePictureCallback callback) {
        final int nowAngle = (this.angle + 90) % 360;
        this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                Matrix matrix = new Matrix();
                if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_POST_POSITION) {
                    matrix.setRotate((float)nowAngle);
                } else if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_FRONT_POSITION) {
                    matrix.setRotate(270.0f);
                    matrix.postScale(-1.0f, 1.0f);
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (callback != null) {
                    callback.captureResult(bitmap);
                }
            }
        });
    }

    void startRecord(Surface surface, ErrorCallback callback) {
        List focusModes;
        if (this.isRecorder) {
            return;
        }
        int nowAngle = (this.angle + 90) % 360;
        if (this.mCamera == null) {
            this.openCamera(this.SELECTED_CAMERA);
        }
        if (this.mediaRecorder == null) {
            this.mediaRecorder = new MediaRecorder();
        }
        if (this.mParams == null) {
            this.mParams = this.mCamera.getParameters();
        }
        if ((focusModes = this.mParams.getSupportedFocusModes()).contains("continuous-video")) {
            this.mParams.setFocusMode("continuous-video");
        }
        this.mCamera.setParameters(this.mParams);
        this.mCamera.unlock();
        this.mediaRecorder.reset();
        this.mediaRecorder.setCamera(this.mCamera);
        this.mediaRecorder.setVideoSource(1);
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(2);
        this.mediaRecorder.setVideoEncoder(2);
        this.mediaRecorder.setAudioEncoder(3);
        Camera.Size videoSize = null;
        videoSize = this.mParams.getSupportedVideoSizes() == null ? CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedPreviewSizes(), 1000, this.screenProp) : CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedVideoSizes(), 1000, this.screenProp);
        if (videoSize.width == videoSize.height) {
            this.mediaRecorder.setVideoSize(this.preview_width, this.preview_height);
        } else {
            this.mediaRecorder.setVideoSize(videoSize.width, videoSize.height);
        }
        if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            this.mediaRecorder.setOrientationHint(270);
        } else {
            this.mediaRecorder.setOrientationHint(nowAngle);
        }
        this.mediaRecorder.setVideoEncodingBitRate(1600000);
        this.mediaRecorder.setPreviewDisplay(surface);
        this.videoFileName = "video_" + System.currentTimeMillis() + ".mp4";
        if (this.saveVideoPath.equals("")) {
            this.saveVideoPath = Environment.getExternalStorageDirectory().getPath();
        }
        this.videoFileAbsPath = this.saveVideoPath + File.separator + this.videoFileName;
        this.mediaRecorder.setOutputFile(this.videoFileAbsPath);
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.isRecorder = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            callback.onError();
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.onError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRecord(boolean isShort, StopRecordCallback callback) {
        if (!this.isRecorder) {
            return;
        }
        if (this.mediaRecorder != null && this.isRecorder) {
            this.mediaRecorder.setOnErrorListener(null);
            this.mediaRecorder.setOnInfoListener(null);
            this.mediaRecorder.setPreviewDisplay(null);
            try {
                this.mediaRecorder.stop();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.mediaRecorder = null;
                this.mediaRecorder = new MediaRecorder();
                Log.i((String)TAG, (String)"stop RuntimeException");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mediaRecorder = null;
                this.mediaRecorder = new MediaRecorder();
                Log.i((String)TAG, (String)"stop Exception");
            }
            finally {
                this.mediaRecorder.release();
                this.mediaRecorder = null;
                this.isRecorder = false;
            }
            if (isShort) {
                File file = new File(this.videoFileAbsPath);
                if (file.exists()) {
                    file.delete();
                }
                callback.recordResult(null);
                return;
            }
            this.doStopCamera();
            String fileName = this.saveVideoPath + File.separator + this.videoFileName;
            callback.recordResult(fileName);
        }
    }

    private void findAvailableCameras() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int cameraNum = Camera.getNumberOfCameras();
        block4: for (int i = 0; i < cameraNum; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            switch (info.facing) {
                case 1: {
                    this.CAMERA_FRONT_POSITION = info.facing;
                    continue block4;
                }
                case 0: {
                    this.CAMERA_POST_POSITION = info.facing;
                }
            }
        }
    }

    public void handleFocus(final Context context, final float x, final float y, final FocusCallback callback) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        Rect focusRect = CameraInterface.calculateTapArea(x, y, 1.0f, context);
        this.mCamera.cancelAutoFocus();
        if (params.getMaxNumFocusAreas() <= 0) {
            Log.i((String)TAG, (String)"focus areas not supported");
            callback.focusSuccess();
            return;
        }
        ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
        focusAreas.add(new Camera.Area(focusRect, 800));
        params.setFocusAreas(focusAreas);
        final String currentFocusMode = params.getFocusMode();
        params.setFocusMode("auto");
        this.mCamera.setParameters(params);
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                if (success) {
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    camera.setParameters(params);
                    callback.focusSuccess();
                } else {
                    CameraInterface.this.handleFocus(context, x, y, callback);
                }
            }
        });
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, Context context) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)ScreenUtils.getScreenHeight(context) * 2000.0f - 1000.0f);
        int centerY = (int)(y / (float)ScreenUtils.getScreenWidth(context) * 2000.0f - 1000.0f);
        int left = CameraInterface.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = CameraInterface.clamp(centerY - areaSize / 2, -1000, 1000);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public void registerSensorManager(Context context) {
        if (this.sm == null) {
            this.sm = (SensorManager)context.getSystemService("sensor");
        }
        this.sm.registerListener(this.sensorEventListener, this.sm.getDefaultSensor(1), 3);
    }

    public void unregisterSensorManager(Context context) {
        if (this.sm == null) {
            this.sm = (SensorManager)context.getSystemService("sensor");
        }
        this.sm.unregisterListener(this.sensorEventListener);
    }

    static interface FocusCallback {
        public void focusSuccess();
    }

    static interface TakePictureCallback {
        public void captureResult(Bitmap var1);
    }

    static interface ErrorCallback {
        public void onError();
    }

    static interface StopRecordCallback {
        public void recordResult(String var1);
    }

    static interface CamOpenOverCallback {
        public void cameraHasOpened();

        public void cameraSwitchSuccess();
    }
}

