/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cjt2325.cameralibrary.CaptureButton;
import com.cjt2325.cameralibrary.ReturnButton;
import com.cjt2325.cameralibrary.TypeButton;
import com.cjt2325.cameralibrary.lisenter.CaptureLisenter;
import com.cjt2325.cameralibrary.lisenter.ReturnLisenter;
import com.cjt2325.cameralibrary.lisenter.TypeLisenter;

public class CaptureLayout
extends RelativeLayout {
    private CaptureLisenter captureLisenter;
    private TypeLisenter typeLisenter;
    private ReturnLisenter returnLisenter;
    private CaptureButton btn_capture;
    private TypeButton btn_confirm;
    private TypeButton btn_cancel;
    private ReturnButton btn_return;
    private TextView txt_tip;
    private int layout_width;
    private int layout_height;
    private int button_size;
    private boolean isFirst = true;

    public void setTypeLisenter(TypeLisenter typeLisenter) {
        this.typeLisenter = typeLisenter;
    }

    public void setCaptureLisenter(CaptureLisenter captureLisenter) {
        this.captureLisenter = captureLisenter;
    }

    public void setReturnLisenter(ReturnLisenter returnLisenter) {
        this.returnLisenter = returnLisenter;
    }

    public CaptureLayout(Context context) {
        this(context, null);
    }

    public CaptureLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CaptureLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        WindowManager manager = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        this.layout_width = this.getResources().getConfiguration().orientation == 1 ? outMetrics.widthPixels : outMetrics.widthPixels / 2;
        this.button_size = (int)((float)this.layout_width / 4.5f);
        this.layout_height = this.button_size + this.button_size / 5 * 2 + 80;
        this.initView();
        this.initEvent();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.layout_width, this.layout_height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void initEvent() {
        this.btn_cancel.setVisibility(4);
        this.btn_confirm.setVisibility(4);
    }

    public void startTypeBtnAnimator() {
        this.btn_capture.setVisibility(4);
        this.btn_return.setVisibility(4);
        this.btn_cancel.setVisibility(0);
        this.btn_confirm.setVisibility(0);
        this.btn_cancel.setClickable(false);
        this.btn_confirm.setClickable(false);
        ObjectAnimator animator_cancel = ObjectAnimator.ofFloat((Object)((Object)this.btn_cancel), (String)"translationX", (float[])new float[]{this.layout_width / 4, 0.0f});
        animator_cancel.setDuration(200L);
        animator_cancel.start();
        ObjectAnimator animator_confirm = ObjectAnimator.ofFloat((Object)((Object)this.btn_confirm), (String)"translationX", (float[])new float[]{-this.layout_width / 4, 0.0f});
        animator_confirm.setDuration(200L);
        animator_confirm.start();
        animator_confirm.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CaptureLayout.this.btn_cancel.setClickable(true);
                CaptureLayout.this.btn_confirm.setClickable(true);
            }
        });
    }

    public void startAlphaAnimation() {
        if (this.isFirst) {
            ObjectAnimator animator_txt_tip = ObjectAnimator.ofFloat((Object)this.txt_tip, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            animator_txt_tip.setDuration(500L);
            animator_txt_tip.start();
            this.isFirst = false;
        }
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.btn_capture = new CaptureButton(this.getContext(), this.button_size);
        RelativeLayout.LayoutParams btn_capture_param = new RelativeLayout.LayoutParams(-1, -1);
        btn_capture_param.addRule(13, -1);
        btn_capture_param.setMargins(0, 152, 0, 0);
        this.btn_capture.setLayoutParams((ViewGroup.LayoutParams)btn_capture_param);
        this.btn_capture.setDuration(5000);
        this.btn_capture.setCaptureLisenter(new CaptureLisenter(){

            @Override
            public void takePictures() {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.takePictures();
                }
            }

            @Override
            public void recordShort(long time) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordShort(time);
                }
                CaptureLayout.this.startAlphaAnimation();
            }

            @Override
            public void recordStart() {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordStart();
                }
                CaptureLayout.this.startAlphaAnimation();
            }

            @Override
            public void recordEnd(long time) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordEnd(time);
                }
                CaptureLayout.this.startAlphaAnimation();
                CaptureLayout.this.startTypeBtnAnimator();
            }

            @Override
            public void recordZoom(float zoom) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordZoom(zoom);
                }
            }
        });
        this.btn_cancel = new TypeButton(this.getContext(), 1, this.button_size);
        RelativeLayout.LayoutParams btn_cancel_param = new RelativeLayout.LayoutParams(-1, -1);
        btn_cancel_param.addRule(15, -1);
        btn_cancel_param.addRule(9, -1);
        btn_cancel_param.setMargins(this.layout_width / 4 - this.button_size / 2, 0, 0, 0);
        this.btn_cancel.setLayoutParams((ViewGroup.LayoutParams)btn_cancel_param);
        this.btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CaptureLayout.this.typeLisenter != null) {
                    CaptureLayout.this.typeLisenter.cancel();
                }
                CaptureLayout.this.startAlphaAnimation();
                CaptureLayout.this.btn_cancel.setVisibility(4);
                CaptureLayout.this.btn_confirm.setVisibility(4);
                CaptureLayout.this.btn_capture.setVisibility(0);
                CaptureLayout.this.btn_return.setVisibility(0);
            }
        });
        this.btn_confirm = new TypeButton(this.getContext(), 2, this.button_size);
        RelativeLayout.LayoutParams btn_confirm_param = new RelativeLayout.LayoutParams(-1, -1);
        btn_confirm_param.addRule(15, -1);
        btn_confirm_param.addRule(11, -1);
        btn_confirm_param.setMargins(0, 0, this.layout_width / 4 - this.button_size / 2, 0);
        this.btn_confirm.setLayoutParams((ViewGroup.LayoutParams)btn_confirm_param);
        this.btn_confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CaptureLayout.this.typeLisenter != null) {
                    CaptureLayout.this.typeLisenter.confirm();
                }
                CaptureLayout.this.startAlphaAnimation();
                CaptureLayout.this.btn_cancel.setVisibility(4);
                CaptureLayout.this.btn_confirm.setVisibility(4);
                CaptureLayout.this.btn_capture.setVisibility(0);
                CaptureLayout.this.btn_return.setVisibility(0);
            }
        });
        this.btn_return = new ReturnButton(this.getContext(), this.button_size / 2);
        RelativeLayout.LayoutParams btn_return_param = new RelativeLayout.LayoutParams(-2, -2);
        btn_return_param.addRule(15, -1);
        btn_return_param.setMargins(this.layout_width / 6, 0, 0, 0);
        this.btn_return.setLayoutParams((ViewGroup.LayoutParams)btn_return_param);
        this.btn_return.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CaptureLayout.this.captureLisenter != null && CaptureLayout.this.returnLisenter != null) {
                    CaptureLayout.this.returnLisenter.onReturn();
                }
            }
        });
        this.txt_tip = new TextView(this.getContext());
        RelativeLayout.LayoutParams txt_param = new RelativeLayout.LayoutParams(-1, -2);
        txt_param.setMargins(0, 0, 0, 0);
        this.txt_tip.setText((CharSequence)"\u8f7b\u89e6\u62cd\u7167\uff0c\u957f\u6309\u6444\u50cf");
        this.txt_tip.setTextColor(-1);
        this.txt_tip.setGravity(17);
        this.txt_tip.setLayoutParams((ViewGroup.LayoutParams)txt_param);
        this.addView(this.btn_capture);
        this.addView(this.btn_cancel);
        this.addView(this.btn_confirm);
        this.addView(this.btn_return);
        this.addView((View)this.txt_tip);
    }

    public void setTextWithAnimation() {
        this.txt_tip.setText((CharSequence)"\u5f55\u5236\u65f6\u95f4\u8fc7\u77ed");
        ObjectAnimator animator_txt_tip = ObjectAnimator.ofFloat((Object)this.txt_tip, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 0.0f});
        animator_txt_tip.setDuration(2500L);
        animator_txt_tip.start();
    }

    public void setDuration(int duration) {
        this.btn_capture.setDuration(duration);
    }

    public void isRecord(boolean record) {
        this.btn_capture.isRecord(record);
    }
}

