/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary.util;

import android.graphics.Bitmap;
import android.os.Environment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";
    private static final File parentPath = Environment.getExternalStorageDirectory();
    private static String storagePath = "";
    private static String DST_FOLDER_NAME = "PlayCamera";

    private static String initPath() {
        File f;
        if (storagePath.equals("") && !(f = new File(storagePath = parentPath.getAbsolutePath() + File.separator + DST_FOLDER_NAME)).exists()) {
            f.mkdir();
        }
        return storagePath;
    }

    public static void saveBitmap(Bitmap b) {
        String path = FileUtil.initPath();
        long dataTake = System.currentTimeMillis();
        String jpegName = path + File.separator + dataTake + ".jpg";
        try {
            FileOutputStream fout = new FileOutputStream(jpegName);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }
}

