/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.cjt2325.cameralibrary.CameraInterface;
import com.cjt2325.cameralibrary.CaptureLayout;
import com.cjt2325.cameralibrary.FoucsView;
import com.cjt2325.cameralibrary.R;
import com.cjt2325.cameralibrary.lisenter.CaptureLisenter;
import com.cjt2325.cameralibrary.lisenter.JCameraLisenter;
import com.cjt2325.cameralibrary.lisenter.ReturnLisenter;
import com.cjt2325.cameralibrary.lisenter.TypeLisenter;
import com.cjt2325.cameralibrary.util.AudioUtil;
import java.io.File;
import java.io.IOException;

public class JCameraView
extends RelativeLayout
implements CameraInterface.CamOpenOverCallback,
SurfaceHolder.Callback {
    private static final String TAG = "CJT";
    private static final int TYPE_PICTURE = 1;
    private static final int TYPE_VIDEO = 2;
    private JCameraLisenter jCameraLisenter;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private CaptureLayout mCaptureLayout;
    private FoucsView mFoucsView;
    private MediaPlayer mMediaPlayer;
    private int layout_width;
    private int fouce_size;
    private float screenProp;
    private Bitmap captureBitmap;
    private String videoUrl;
    private int type = -1;
    private int CAMERA_STATE = -1;
    private static final int STATE_IDLE = 16;
    private static final int STATE_RUNNING = 32;
    private static final int STATE_WAIT = 48;
    private boolean stopping = false;
    private boolean isBorrow = false;
    private int iconSize = 0;
    private int iconMargin = 0;
    private int iconSrc = 0;
    private int duration = 0;

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.JCameraView, defStyleAttr, 0);
        this.iconSize = a.getDimensionPixelSize(R.styleable.JCameraView_iconSize, (int)TypedValue.applyDimension((int)2, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconMargin = a.getDimensionPixelSize(R.styleable.JCameraView_iconMargin, (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconSrc = a.getResourceId(R.styleable.JCameraView_iconSrc, R.drawable.ic_sync_black_24dp);
        this.duration = a.getInteger(R.styleable.JCameraView_duration_max, 10000);
        a.recycle();
        this.initData();
        this.initView();
    }

    private void initData() {
        WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        this.layout_width = outMetrics.widthPixels;
        this.fouce_size = this.layout_width / 4;
        this.CAMERA_STATE = 16;
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setBackgroundColor(-16777216);
        this.mVideoView = new VideoView(this.mContext);
        RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, -2);
        videoViewParam.addRule(13, -1);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        this.mPhoto = new ImageView(this.mContext);
        RelativeLayout.LayoutParams photoParam = new RelativeLayout.LayoutParams(-1, -1);
        photoParam.addRule(11, -1);
        this.mPhoto.setLayoutParams((ViewGroup.LayoutParams)photoParam);
        this.mPhoto.setBackgroundColor(-16777216);
        this.mPhoto.setVisibility(4);
        this.mSwitchCamera = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewParam = new RelativeLayout.LayoutParams(this.iconSize, this.iconSize);
        imageViewParam.addRule(11, -1);
        imageViewParam.setMargins(0, this.iconMargin, this.iconMargin, 0);
        this.mSwitchCamera.setLayoutParams((ViewGroup.LayoutParams)imageViewParam);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JCameraView.this.isBorrow) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().switchCamera();
                    }
                }.start();
            }
        });
        this.mCaptureLayout = new CaptureLayout(this.mContext);
        RelativeLayout.LayoutParams layout_param = new RelativeLayout.LayoutParams(-2, -2);
        layout_param.addRule(12);
        layout_param.setMargins(0, 0, 0, 40);
        this.mCaptureLayout.setLayoutParams((ViewGroup.LayoutParams)layout_param);
        this.mCaptureLayout.setDuration(this.duration);
        this.mFoucsView = new FoucsView(this.mContext, this.fouce_size);
        RelativeLayout.LayoutParams foucs_param = new RelativeLayout.LayoutParams(-2, -2);
        this.mFoucsView.setLayoutParams((ViewGroup.LayoutParams)foucs_param);
        this.mFoucsView.setVisibility(4);
        this.addView((View)this.mVideoView);
        this.addView((View)this.mPhoto);
        this.addView((View)this.mSwitchCamera);
        this.addView((View)this.mCaptureLayout);
        this.addView(this.mFoucsView);
        this.mCaptureLayout.setCaptureLisenter(new CaptureLisenter(){

            @Override
            public void takePictures() {
                if (JCameraView.this.CAMERA_STATE != 16) {
                    return;
                }
                JCameraView.this.CAMERA_STATE = 32;
                CameraInterface.getInstance().takePicture(new CameraInterface.TakePictureCallback(){

                    @Override
                    public void captureResult(Bitmap bitmap) {
                        JCameraView.this.captureBitmap = bitmap;
                        CameraInterface.getInstance().doStopCamera();
                        JCameraView.this.type = 1;
                        JCameraView.this.isBorrow = true;
                        JCameraView.this.CAMERA_STATE = 48;
                        JCameraView.this.mPhoto.setImageBitmap(bitmap);
                        JCameraView.this.mPhoto.setVisibility(0);
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                if (JCameraView.this.CAMERA_STATE != 32 && JCameraView.this.stopping) {
                    return;
                }
                JCameraView.this.stopping = true;
                JCameraView.this.mCaptureLayout.setTextWithAnimation();
                JCameraView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().stopRecord(true, new CameraInterface.StopRecordCallback(){

                            @Override
                            public void recordResult(String url) {
                                Log.i((String)JCameraView.TAG, (String)"stopping ...");
                                JCameraView.this.CAMERA_STATE = 16;
                                JCameraView.this.stopping = false;
                                JCameraView.this.isBorrow = false;
                            }
                        });
                    }
                }, 1500L - time);
            }

            @Override
            public void recordStart() {
                if (JCameraView.this.CAMERA_STATE != 16 && JCameraView.this.stopping) {
                    return;
                }
                JCameraView.this.isBorrow = true;
                JCameraView.this.CAMERA_STATE = 32;
                CameraInterface.getInstance().startRecord(JCameraView.this.mVideoView.getHolder().getSurface());
            }

            @Override
            public void recordEnd(long time) {
                CameraInterface.getInstance().stopRecord(false, new CameraInterface.StopRecordCallback(){

                    @Override
                    public void recordResult(final String url) {
                        JCameraView.this.CAMERA_STATE = 48;
                        JCameraView.this.videoUrl = url;
                        JCameraView.this.type = 2;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (JCameraView.this.mMediaPlayer == null) {
                                        JCameraView.this.mMediaPlayer = new MediaPlayer();
                                    } else {
                                        JCameraView.this.mMediaPlayer.reset();
                                    }
                                    Log.i((String)JCameraView.TAG, (String)("URL = " + url));
                                    JCameraView.this.mMediaPlayer.setDataSource(url);
                                    JCameraView.this.mMediaPlayer.setSurface(JCameraView.this.mVideoView.getHolder().getSurface());
                                    JCameraView.this.mMediaPlayer.setVideoScalingMode(1);
                                    JCameraView.this.mMediaPlayer.setAudioStreamType(3);
                                    JCameraView.this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                                        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                                            JCameraView.this.updateVideoViewSize(JCameraView.this.mMediaPlayer.getVideoWidth(), JCameraView.this.mMediaPlayer.getVideoHeight());
                                        }
                                    });
                                    JCameraView.this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                                        public void onPrepared(MediaPlayer mp) {
                                            JCameraView.this.mMediaPlayer.start();
                                        }
                                    });
                                    JCameraView.this.mMediaPlayer.setLooping(true);
                                    JCameraView.this.mMediaPlayer.prepare();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                });
            }

            @Override
            public void recordZoom(float zoom) {
                CameraInterface.getInstance().setZoom(zoom);
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeLisenter(){

            @Override
            public void cancel() {
                if (JCameraView.this.CAMERA_STATE == 48) {
                    if (JCameraView.this.mMediaPlayer != null && JCameraView.this.mMediaPlayer.isPlaying()) {
                        JCameraView.this.mMediaPlayer.stop();
                        JCameraView.this.mMediaPlayer.release();
                        JCameraView.this.mMediaPlayer = null;
                    }
                    CameraInterface.getInstance().doOpenCamera(JCameraView.this);
                    JCameraView.this.handlerPictureOrVideo(JCameraView.this.type, false);
                }
            }

            @Override
            public void confirm() {
                if (JCameraView.this.CAMERA_STATE == 48) {
                    if (JCameraView.this.mMediaPlayer != null && JCameraView.this.mMediaPlayer.isPlaying()) {
                        JCameraView.this.mMediaPlayer.stop();
                        JCameraView.this.mMediaPlayer.release();
                        JCameraView.this.mMediaPlayer = null;
                    }
                    CameraInterface.getInstance().doOpenCamera(JCameraView.this);
                    JCameraView.this.handlerPictureOrVideo(JCameraView.this.type, true);
                }
            }
        });
        this.mCaptureLayout.setReturnLisenter(new ReturnLisenter(){

            @Override
            public void onReturn() {
                if (JCameraView.this.jCameraLisenter != null) {
                    JCameraView.this.jCameraLisenter.quit();
                }
            }
        });
        this.mVideoView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.screenProp = heightSize / widthSize;
    }

    @Override
    public void cameraHasOpened() {
        CameraInterface.getInstance().doStartPreview(this.mVideoView.getHolder(), this.screenProp);
    }

    public void onResume() {
        CameraInterface.getInstance().registerSensorManager(this.mContext);
        if (!CameraInterface.getInstance().isPreviewing()) {
            new Thread(){

                @Override
                public void run() {
                    CameraInterface.getInstance().doOpenCamera(JCameraView.this);
                }
            }.start();
        }
    }

    public void onPause() {
        CameraInterface.getInstance().unregisterSensorManager(this.mContext);
        CameraInterface.getInstance().doStopCamera();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getPointerCount() != 1) break;
                this.setFocusViewWidthAnimation(event.getX(), event.getY());
            }
        }
        return super.onTouchEvent(event);
    }

    private void setFocusViewWidthAnimation(float x, float y) {
        if (this.isBorrow) {
            return;
        }
        if (y > (float)this.mCaptureLayout.getTop()) {
            return;
        }
        this.mFoucsView.setVisibility(0);
        if (x < (float)(this.mFoucsView.getWidth() / 2)) {
            x = this.mFoucsView.getWidth() / 2;
        }
        if (x > (float)(this.layout_width - this.mFoucsView.getWidth() / 2)) {
            x = this.layout_width - this.mFoucsView.getWidth() / 2;
        }
        if (y < (float)(this.mFoucsView.getWidth() / 2)) {
            y = this.mFoucsView.getWidth() / 2;
        }
        if (y > (float)(this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2)) {
            y = this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2;
        }
        CameraInterface.getInstance().handleFocus(x, y, new CameraInterface.FocusCallback(){

            @Override
            public void focusSuccess() {
                JCameraView.this.mFoucsView.setVisibility(4);
            }
        });
        this.mFoucsView.setX(x - (float)(this.mFoucsView.getWidth() / 2));
        this.mFoucsView.setY(y - (float)(this.mFoucsView.getHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleX", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleY", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"alpha", (float[])new float[]{1.0f, 0.3f, 1.0f, 0.3f, 1.0f, 0.3f, 1.0f});
        AnimatorSet animSet = new AnimatorSet();
        animSet.play((Animator)scaleX).with((Animator)scaleY).before((Animator)alpha);
        animSet.setDuration(400L);
        animSet.start();
    }

    public void setJCameraLisenter(JCameraLisenter jCameraLisenter) {
        this.jCameraLisenter = jCameraLisenter;
    }

    private void handlerPictureOrVideo(int type, boolean confirm) {
        if (this.jCameraLisenter == null || type == -1) {
            return;
        }
        switch (type) {
            case 1: {
                this.mPhoto.setVisibility(4);
                if (confirm && this.captureBitmap != null) {
                    this.jCameraLisenter.captureSuccess(this.captureBitmap);
                    break;
                }
                if (this.captureBitmap != null) {
                    this.captureBitmap.recycle();
                }
                this.captureBitmap = null;
                break;
            }
            case 2: {
                if (confirm) {
                    this.jCameraLisenter.recordSuccess(this.videoUrl);
                } else {
                    File file = new File(this.videoUrl);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, -1);
                videoViewParam.addRule(13, -1);
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
            }
        }
        this.isBorrow = false;
        this.CAMERA_STATE = 16;
    }

    public void setSaveVideoPath(String path) {
        CameraInterface.getInstance().setSaveVideoPath(path);
    }

    public void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, height);
            videoViewParam.addRule(13, -1);
            this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void forbiddenAudio(boolean forbidden) {
        if (forbidden) {
            AudioUtil.setAudioManage(this.mContext);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }
}

