/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.view.Surface;
import com.cjt2325.cameralibrary.util.CameraParamUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class CameraInterface {
    private static final String TAG = "CJT";
    private Camera mCamera;
    private Camera.Parameters mParams;
    private boolean isPreviewing = false;
    private static CameraInterface mCameraInterface;
    private int SELECTED_CAMERA = -1;
    private int CAMERA_POST_POSITION = -1;
    private int CAMERA_FRONT_POSITION = -1;
    private SurfaceTexture mSurface = null;
    private float screenProp = -1.0f;
    private boolean isRecorder = false;
    private MediaRecorder mediaRecorder;
    private String videoFileName;
    private String saveVideoPath;
    private String videoFileAbsPath;
    private int preview_width;
    private int preview_height;

    boolean isPreviewing() {
        return this.isPreviewing;
    }

    public void setSaveVideoPath(String saveVideoPath) {
        this.saveVideoPath = saveVideoPath;
        File file = new File(saveVideoPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private CameraInterface() {
        this.findAvailableCameras();
        this.SELECTED_CAMERA = this.CAMERA_POST_POSITION;
        this.saveVideoPath = "";
    }

    static synchronized CameraInterface getInstance() {
        if (mCameraInterface == null) {
            mCameraInterface = new CameraInterface();
        }
        return mCameraInterface;
    }

    void doOpenCamera(CamOpenOverCallback callback) {
        if (this.mCamera == null) {
            this.mCamera = Camera.open((int)this.SELECTED_CAMERA);
            if (Build.VERSION.SDK_INT > 17) {
                this.mCamera.enableShutterSound(false);
            }
        }
        callback.cameraHasOpened();
    }

    public synchronized void switchCamera() {
        this.SELECTED_CAMERA = this.SELECTED_CAMERA == this.CAMERA_POST_POSITION ? this.CAMERA_FRONT_POSITION : this.CAMERA_POST_POSITION;
        this.doStopCamera();
        this.mCamera = Camera.open((int)this.SELECTED_CAMERA);
        this.doStartPreview(this.mSurface, this.screenProp);
    }

    void doStartPreview(SurfaceTexture surface, float screenProp) {
        if (this.screenProp < 0.0f) {
            this.screenProp = screenProp;
        }
        if (surface == null) {
            return;
        }
        this.mSurface = surface;
        if (this.isPreviewing) {
            this.mCamera.stopPreview();
            return;
        }
        if (this.mCamera != null) {
            try {
                this.mParams = this.mCamera.getParameters();
                Camera.Size previewSize = CameraParamUtil.getInstance().getPreviewSize(this.mParams.getSupportedPreviewSizes(), 1000, screenProp);
                Camera.Size pictureSize = CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedPictureSizes(), 1200, screenProp);
                this.mParams.setPreviewSize(previewSize.width, previewSize.height);
                this.preview_width = previewSize.width;
                this.preview_height = previewSize.height;
                this.mParams.setPictureSize(pictureSize.width, pictureSize.height);
                if (CameraParamUtil.getInstance().isSupportedFocusMode(this.mParams.getSupportedFocusModes(), "auto")) {
                    this.mParams.setFocusMode("auto");
                }
                if (CameraParamUtil.getInstance().isSupportedPictureFormats(this.mParams.getSupportedPictureFormats(), 256)) {
                    this.mParams.setPictureFormat(256);
                    this.mParams.setJpegQuality(100);
                }
                this.mCamera.setParameters(this.mParams);
                this.mParams = this.mCamera.getParameters();
                surface.setDefaultBufferSize(previewSize.width, previewSize.height);
                this.mCamera.setPreviewTexture(surface);
                this.mCamera.setDisplayOrientation(90);
                this.mCamera.startPreview();
                this.isPreviewing = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Log.i((String)TAG, (String)"=== Start Preview ===");
    }

    void doStopCamera() {
        if (null != this.mCamera) {
            try {
                this.mCamera.setPreviewTexture(null);
                this.mCamera.stopPreview();
                this.isPreviewing = false;
                this.mCamera.release();
                this.mCamera = null;
                Log.i((String)TAG, (String)"=== Stop Camera ===");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void takePicture(final TakePictureCallback callback) {
        this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                Matrix matrix = new Matrix();
                if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_POST_POSITION) {
                    matrix.setRotate(90.0f);
                } else if (CameraInterface.this.SELECTED_CAMERA == CameraInterface.this.CAMERA_FRONT_POSITION) {
                    matrix.setRotate(270.0f);
                    matrix.postScale(-1.0f, 1.0f);
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (callback != null) {
                    callback.captureResult(bitmap);
                }
            }
        });
    }

    void startRecord() {
        if (this.mCamera == null) {
            return;
        }
        this.mCamera.unlock();
        if (this.mediaRecorder == null) {
            this.mediaRecorder = new MediaRecorder();
        }
        if (this.isRecorder) {
            return;
        }
        this.mediaRecorder.reset();
        this.mediaRecorder.setCamera(this.mCamera);
        this.mediaRecorder.setVideoSource(1);
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(2);
        this.mediaRecorder.setVideoEncoder(2);
        this.mediaRecorder.setAudioEncoder(3);
        if (this.mParams == null) {
            this.mParams = this.mCamera.getParameters();
        }
        Camera.Size videoSize = null;
        videoSize = this.mParams.getSupportedVideoSizes() == null ? CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedPreviewSizes(), 1000, this.screenProp) : CameraParamUtil.getInstance().getPictureSize(this.mParams.getSupportedVideoSizes(), 1000, this.screenProp);
        List focusModes = this.mParams.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            this.mParams.setFocusMode("continuous-video");
        }
        Log.i((String)TAG, (String)("setVideoSize    width = " + videoSize.width + "height = " + videoSize.height));
        if (videoSize.width == videoSize.height) {
            this.mediaRecorder.setVideoSize(this.preview_width, this.preview_height);
        } else {
            this.mediaRecorder.setVideoSize(videoSize.width, videoSize.height);
        }
        if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            this.mediaRecorder.setOrientationHint(270);
        } else {
            this.mediaRecorder.setOrientationHint(90);
        }
        this.mediaRecorder.setVideoEncodingBitRate(0x500000);
        this.mediaRecorder.setPreviewDisplay(new Surface(this.mSurface));
        this.videoFileName = "video_" + System.currentTimeMillis() + ".mp4";
        if (this.saveVideoPath.equals("")) {
            this.saveVideoPath = Environment.getExternalStorageDirectory().getPath();
        }
        this.videoFileAbsPath = this.saveVideoPath + File.separator + this.videoFileName;
        this.mediaRecorder.setOutputFile(this.videoFileAbsPath);
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.isRecorder = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void stopRecord(boolean isShort, StopRecordCallback callback) {
        if (!this.isRecorder) {
            return;
        }
        if (this.mediaRecorder != null && this.isRecorder) {
            try {
                this.mediaRecorder.stop();
                this.isRecorder = false;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.mediaRecorder.release();
            this.mediaRecorder = null;
            if (isShort) {
                File file = new File(this.videoFileAbsPath);
                if (file.exists()) {
                    file.delete();
                }
                callback.recordResult(null);
                return;
            }
            this.doStopCamera();
            String fileName = this.saveVideoPath + "/" + this.videoFileName;
            callback.recordResult(fileName);
        }
    }

    private void findAvailableCameras() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int cameraNum = Camera.getNumberOfCameras();
        block4: for (int i = 0; i < cameraNum; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            switch (info.facing) {
                case 1: {
                    this.CAMERA_FRONT_POSITION = info.facing;
                    continue block4;
                }
                case 0: {
                    this.CAMERA_POST_POSITION = info.facing;
                }
            }
        }
    }

    public void handleFocus(final float x, final float y, final FocusCallback callback) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        Camera.Size previewSize = params.getPreviewSize();
        Rect focusRect = CameraInterface.calculateTapArea(x, y, 1.0f, previewSize);
        this.mCamera.cancelAutoFocus();
        if (params.getMaxNumFocusAreas() <= 0) {
            Log.i((String)TAG, (String)"focus areas not supported");
            callback.focusSuccess();
            return;
        }
        ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
        focusAreas.add(new Camera.Area(focusRect, 800));
        params.setFocusAreas(focusAreas);
        final String currentFocusMode = params.getFocusMode();
        params.setFocusMode("auto");
        Log.i((String)TAG, (String)("width = " + params.getPreviewSize().width + "height = " + params.getPreviewSize().height));
        this.mCamera.setParameters(params);
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                if (success) {
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    camera.setParameters(params);
                    callback.focusSuccess();
                } else {
                    CameraInterface.this.handleFocus(x, y, callback);
                }
            }
        });
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, Camera.Size previewSize) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)previewSize.width - 1000.0f);
        int centerY = (int)(y / (float)previewSize.height - 1000.0f);
        int left = CameraInterface.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = CameraInterface.clamp(centerY - areaSize / 2, -1000, 1000);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    static interface FocusCallback {
        public void focusSuccess();
    }

    static interface TakePictureCallback {
        public void captureResult(Bitmap var1);
    }

    static interface StopRecordCallback {
        public void recordResult(String var1);
    }

    static interface CamOpenOverCallback {
        public void cameraHasOpened();
    }
}

