/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.util.Log;

public class CheckPermissionsUtil {
    public static final String TAG = "CheckPermissionsUtil";
    Context mContext;
    private String[] needPermissions = new String[]{"android.permission.RECORD_AUDIO", "android.permission.WAKE_LOCK", "android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WRITE_SETTINGS"};

    public CheckPermissionsUtil(Context mContext) {
        this.mContext = mContext;
    }

    private boolean checkPermission(String ... needPermissions) {
        for (String permission2 : needPermissions) {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void requestPermission(Activity activity, int code, String ... needPermissions) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])needPermissions, (int)code);
        Log.i((String)TAG, (String)"request Permission...");
    }

    public void requestAllPermission(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            Log.i((String)TAG, (String)"request All Permission...");
            for (String permission2 : this.needPermissions) {
                if (this.checkPermission(permission2)) continue;
                this.requestPermission(activity, 0, permission2);
            }
        }
    }
}

