/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.hardware.Camera;
import android.util.Log;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraParamUtil {
    private static final String TAG = "JCameraView";
    private CameraSizeComparator sizeComparator = new CameraSizeComparator();
    private static CameraParamUtil cameraParamUtil = null;

    private CameraParamUtil() {
    }

    public static CameraParamUtil getInstance() {
        if (cameraParamUtil == null) {
            cameraParamUtil = new CameraParamUtil();
            return cameraParamUtil;
        }
        return cameraParamUtil;
    }

    public Camera.Size getPreviewSize(List<Camera.Size> list, int th, float rate) {
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Preview :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        return list.get(i);
    }

    public Camera.Size getPictureSize(List<Camera.Size> list, int th, float rate) {
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Picture :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        return list.get(i);
    }

    public boolean equalRate(Camera.Size s, float rate) {
        float r = (float)s.width / (float)s.height;
        return (double)Math.abs(r - rate) <= 0.2;
    }

    public class CameraSizeComparator
    implements Comparator<Camera.Size> {
        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            if (lhs.width == rhs.width) {
                return 0;
            }
            if (lhs.width > rhs.width) {
                return 1;
            }
            return -1;
        }
    }
}

