/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.os.PowerManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.cjt2325.cameralibrary.AudioUtil;
import com.cjt2325.cameralibrary.CameraFocusListener;
import com.cjt2325.cameralibrary.CaptureButton;
import com.cjt2325.cameralibrary.FoucsView;
import com.cjt2325.cameralibrary.R;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JCameraView
extends RelativeLayout
implements SurfaceHolder.Callback,
Camera.AutoFocusCallback,
CameraFocusListener {
    public final String TAG = "JCameraView";
    private PowerManager powerManager = null;
    private PowerManager.WakeLock wakeLock = null;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mImageView;
    private FoucsView mFoucsView;
    private CaptureButton mCaptureButtom;
    private int iconWidth = 0;
    private int iconMargin = 0;
    private int iconSrc = 0;
    private String saveVideoPath = "";
    private String videoFileName = "";
    private MediaRecorder mediaRecorder;
    private SurfaceHolder mHolder = null;
    private Camera mCamera;
    private Camera.Parameters mParam;
    private int previewWidth;
    private int previewHeight;
    private int pictureWidth;
    private int pictureHeight;
    private boolean autoFoucs;
    private boolean isPlay = false;
    private boolean isRecorder = false;
    private float screenProp;
    private String fileName;
    private Bitmap pictureBitmap;
    private int SELECTED_CAMERA = -1;
    private int CAMERA_POST_POSITION = -1;
    private int CAMERA_FRONT_POSITION = -1;
    private CameraViewListener cameraViewListener;

    public void setCameraViewListener(CameraViewListener cameraViewListener) {
        this.cameraViewListener = cameraViewListener;
    }

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = this.powerManager.newWakeLock(26, "My Lock");
        AudioUtil.setAudioManage(this.mContext);
        this.findAvailableCameras();
        this.SELECTED_CAMERA = this.CAMERA_POST_POSITION;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.JCameraView, defStyleAttr, 0);
        this.iconWidth = a.getDimensionPixelSize(R.styleable.JCameraView_iconWidth, (int)TypedValue.applyDimension((int)2, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconMargin = a.getDimensionPixelSize(R.styleable.JCameraView_iconMargin, (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconSrc = a.getResourceId(R.styleable.JCameraView_iconSrc, R.drawable.ic_repeat_black_24dp);
        this.initView();
        this.mHolder = this.mVideoView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mCaptureButtom.setCaptureListener(new CaptureButton.CaptureListener(){

            @Override
            public void capture() {
                JCameraView.this.capture();
            }

            @Override
            public void cancel() {
                JCameraView.this.mImageView.setVisibility(0);
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void determine() {
                if (JCameraView.this.cameraViewListener != null) {
                    JCameraView.this.cameraViewListener.captureSuccess(JCameraView.this.pictureBitmap);
                }
                JCameraView.this.mImageView.setVisibility(0);
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void quit() {
                if (JCameraView.this.cameraViewListener != null) {
                    JCameraView.this.cameraViewListener.quit();
                }
            }

            @Override
            public void record() {
                JCameraView.this.startRecord();
            }

            @Override
            public void rencodEnd() {
                JCameraView.this.stopRecord();
            }

            @Override
            public void getRecordResult() {
                if (JCameraView.this.cameraViewListener != null) {
                    JCameraView.this.cameraViewListener.recordSuccess(JCameraView.this.fileName);
                }
                JCameraView.this.mVideoView.stopPlayback();
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
                JCameraView.this.isPlay = false;
            }

            @Override
            public void deleteRecordResult() {
                File file = new File(JCameraView.this.fileName);
                if (file.exists()) {
                    file.delete();
                }
                JCameraView.this.mVideoView.stopPlayback();
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
                JCameraView.this.isPlay = false;
            }

            @Override
            public void scale(float scaleValue) {
                if (scaleValue >= 0.0f) {
                    int scaleRate = (int)(scaleValue / 50.0f);
                    if (scaleRate < 10 && scaleRate >= 0 && JCameraView.this.mParam.isSmoothZoomSupported()) {
                        JCameraView.this.mParam.setZoom(scaleRate);
                        JCameraView.this.mCamera.setParameters(JCameraView.this.mParam);
                    }
                    Log.i((String)"JCameraView", (String)("scaleValue = " + (int)scaleValue + " = scaleRate" + scaleRate));
                }
            }
        });
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setBackgroundColor(-16777216);
        this.mVideoView = new VideoView(this.mContext);
        RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, -2);
        videoViewParam.addRule(13, -1);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        RelativeLayout.LayoutParams btnParams = new RelativeLayout.LayoutParams(-2, -2);
        btnParams.addRule(14, -1);
        btnParams.addRule(12, -1);
        this.mCaptureButtom = new CaptureButton(this.mContext);
        this.mCaptureButtom.setLayoutParams((ViewGroup.LayoutParams)btnParams);
        this.mImageView = new ImageView(this.mContext);
        Log.i((String)"CJT", (String)(this.getMeasuredWidth() + " =================================="));
        RelativeLayout.LayoutParams imageViewParam = new RelativeLayout.LayoutParams(this.iconWidth, this.iconWidth);
        imageViewParam.addRule(11, -1);
        imageViewParam.setMargins(0, this.iconMargin, this.iconMargin, 0);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imageViewParam);
        this.mImageView.setImageResource(this.iconSrc);
        this.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JCameraView.this.mCamera != null) {
                    JCameraView.this.releaseCamera();
                    if (JCameraView.this.SELECTED_CAMERA == JCameraView.this.CAMERA_POST_POSITION) {
                        JCameraView.this.SELECTED_CAMERA = JCameraView.this.CAMERA_FRONT_POSITION;
                    } else {
                        JCameraView.this.SELECTED_CAMERA = JCameraView.this.CAMERA_POST_POSITION;
                    }
                    JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                    JCameraView.this.previewWidth = (JCameraView.this.previewHeight = 0);
                    JCameraView.this.pictureWidth = (JCameraView.this.pictureHeight = 0);
                    JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
                }
            }
        });
        this.mFoucsView = new FoucsView(this.mContext, 120);
        this.mFoucsView.setVisibility(4);
        this.addView((View)this.mVideoView);
        this.addView(this.mCaptureButtom);
        this.addView((View)this.mImageView);
        this.addView(this.mFoucsView);
        this.mVideoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                JCameraView.this.mCamera.autoFocus((Camera.AutoFocusCallback)JCameraView.this);
                Log.i((String)"JCameraView", (String)"Touch To Focus");
            }
        });
        this.autoFoucs = true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    private Camera getCamera(int position) {
        Camera camera;
        try {
            camera = Camera.open((int)position);
        }
        catch (Exception e) {
            camera = null;
            e.printStackTrace();
        }
        return camera;
    }

    public void btnReturn() {
        this.setStartPreview(this.mCamera, this.mHolder);
    }

    private void setStartPreview(Camera camera, SurfaceHolder holder) {
        if (camera == null) {
            Log.i((String)"JCameraView", (String)"Camera is null");
            return;
        }
        try {
            float prop;
            Camera.Size cur;
            this.mParam = camera.getParameters();
            this.mParam.setPictureFormat(256);
            List sizeList = this.mParam.getSupportedPreviewSizes();
            List previewSizes = this.mParam.getSupportedPictureSizes();
            Iterator itor = sizeList.iterator();
            Iterator previewItor = previewSizes.iterator();
            float previewDisparity = 1000.0f;
            float pictureDisparity = 1000.0f;
            while (itor.hasNext()) {
                cur = (Camera.Size)itor.next();
                if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION && Math.abs(this.screenProp - (prop = (float)cur.height / (float)cur.width)) < previewDisparity) {
                    previewDisparity = Math.abs(this.screenProp - prop);
                    this.previewWidth = cur.width;
                    this.previewHeight = cur.height;
                }
                if (this.SELECTED_CAMERA == this.CAMERA_POST_POSITION && cur.width >= this.previewWidth && cur.height >= this.previewHeight) {
                    this.previewWidth = cur.width;
                    this.previewHeight = cur.height;
                }
                Log.i((String)"JCameraView", (String)("preview width = " + cur.width + " height = " + cur.height));
            }
            while (previewItor.hasNext()) {
                cur = (Camera.Size)previewItor.next();
                prop = (float)cur.height / (float)cur.width;
                if (Math.abs(this.screenProp - prop) < pictureDisparity) {
                    pictureDisparity = Math.abs(this.screenProp - prop);
                    this.pictureWidth = cur.width;
                    this.pictureHeight = cur.height;
                }
                Log.i((String)"JCameraView", (String)("picture width = " + cur.width + " height = " + cur.height));
            }
            Log.i((String)"JCameraView", (String)("Mmkesure priviewSize width = " + this.previewWidth + " height = " + this.previewHeight));
            Log.i((String)"JCameraView", (String)("Mmkesure pictureSize width = " + this.pictureWidth + " height = " + this.pictureHeight));
            this.mParam.setPreviewSize(this.previewWidth, this.previewHeight);
            this.mParam.setPictureSize(this.pictureWidth, this.pictureHeight);
            this.mParam.setJpegQuality(100);
            this.mParam.setFocusMode("auto");
            camera.setParameters(this.mParam);
            this.mParam = camera.getParameters();
            camera.setPreviewDisplay(holder);
            camera.setDisplayOrientation(90);
            camera.startPreview();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void capture() {
        if (this.autoFoucs) {
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
        } else if (this.SELECTED_CAMERA == this.CAMERA_POST_POSITION) {
            this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix matrix = new Matrix();
                    matrix.setRotate(90.0f);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    JCameraView.this.pictureBitmap = bitmap;
                    JCameraView.this.mImageView.setVisibility(4);
                    JCameraView.this.mCaptureButtom.captureSuccess();
                }
            });
        } else if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix matrix = new Matrix();
                    matrix.setRotate(270.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    JCameraView.this.pictureBitmap = bitmap;
                    JCameraView.this.mImageView.setVisibility(4);
                    JCameraView.this.mCaptureButtom.captureSuccess();
                }
            });
        }
    }

    public void onAutoFocus(boolean success, Camera camera) {
        if (this.autoFoucs) {
            if (this.SELECTED_CAMERA == this.CAMERA_POST_POSITION && success) {
                this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        Matrix matrix = new Matrix();
                        matrix.setRotate(90.0f);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        JCameraView.this.pictureBitmap = bitmap;
                        JCameraView.this.mImageView.setVisibility(4);
                        JCameraView.this.mCaptureButtom.captureSuccess();
                    }
                });
            } else if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
                this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        Matrix matrix = new Matrix();
                        matrix.setRotate(270.0f);
                        matrix.postScale(-1.0f, 1.0f);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        JCameraView.this.pictureBitmap = bitmap;
                        JCameraView.this.mImageView.setVisibility(4);
                        JCameraView.this.mCaptureButtom.captureSuccess();
                    }
                });
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.screenProp = widthSize / heightSize;
        Log.i((String)"JCameraView", (String)("ScreenProp = " + this.screenProp + " " + widthSize + " " + heightSize));
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.setStartPreview(this.mCamera, holder);
        Log.i((String)"Camera", (String)"surfaceCreated");
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.releaseCamera();
        Log.i((String)"Camera", (String)"surfaceDestroyed");
    }

    public void onResume() {
        this.mCamera = this.getCamera(this.SELECTED_CAMERA);
        if (this.mCamera == null) {
            Log.i((String)"JCameraView", (String)"Camera is null!");
        }
        this.wakeLock.acquire();
    }

    public void onPause() {
        this.releaseCamera();
        this.wakeLock.release();
    }

    private void startRecord() {
        if (this.isRecorder) {
            this.mediaRecorder.stop();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
        if (this.mCamera == null) {
            Log.i((String)"JCameraView", (String)"Camera is null");
            this.stopRecord();
            return;
        }
        this.mCamera.unlock();
        if (this.mediaRecorder == null) {
            this.mediaRecorder = new MediaRecorder();
        }
        this.mediaRecorder.reset();
        this.mediaRecorder.setCamera(this.mCamera);
        this.mediaRecorder.setVideoSource(1);
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(2);
        this.mediaRecorder.setVideoEncoder(2);
        this.mediaRecorder.setAudioEncoder(1);
        int vedioSizeWidth = 0;
        int vedioSizeHeight = 0;
        if (this.mParam == null) {
            this.mParam = this.mCamera.getParameters();
        }
        List sizeList = this.mParam.getSupportedVideoSizes();
        Iterator itor = sizeList.iterator();
        float previewDisparity = 1000.0f;
        while (itor.hasNext()) {
            float prop;
            Camera.Size cur = (Camera.Size)itor.next();
            if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION && Math.abs(this.screenProp - (prop = (float)cur.height / (float)cur.width)) < previewDisparity) {
                previewDisparity = Math.abs(this.screenProp - prop);
                vedioSizeWidth = cur.width;
                vedioSizeHeight = cur.height;
            }
            if (this.SELECTED_CAMERA == this.CAMERA_POST_POSITION && cur.width >= vedioSizeWidth && cur.height >= vedioSizeHeight) {
                vedioSizeWidth = cur.width;
                vedioSizeHeight = cur.height;
            }
            Log.i((String)"JCameraView", (String)("preview width = " + cur.width + " height = " + cur.height));
        }
        this.mediaRecorder.setVideoSize(vedioSizeWidth, vedioSizeHeight);
        if (this.SELECTED_CAMERA == this.CAMERA_FRONT_POSITION) {
            this.mediaRecorder.setOrientationHint(270);
        } else {
            this.mediaRecorder.setOrientationHint(90);
        }
        this.mediaRecorder.setMaxDuration(10000);
        this.mediaRecorder.setVideoEncodingBitRate(0x500000);
        this.mediaRecorder.setPreviewDisplay(this.mHolder.getSurface());
        this.videoFileName = "video_" + System.currentTimeMillis() + ".mp4";
        if (this.saveVideoPath.equals("")) {
            this.saveVideoPath = Environment.getExternalStorageDirectory().getPath();
        }
        this.mediaRecorder.setOutputFile(this.saveVideoPath + "/" + this.videoFileName);
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.isRecorder = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopRecord() {
        if (this.mediaRecorder != null) {
            this.mediaRecorder.setOnErrorListener(null);
            this.mediaRecorder.setOnInfoListener(null);
            this.mediaRecorder.setPreviewDisplay(null);
            try {
                this.mediaRecorder.stop();
                this.isRecorder = false;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.mediaRecorder.release();
            this.mediaRecorder = null;
            this.releaseCamera();
            this.fileName = this.saveVideoPath + "/" + this.videoFileName;
            this.mVideoView.setVideoPath(this.fileName);
            this.mVideoView.start();
            this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    JCameraView.this.isPlay = true;
                    mp.start();
                    mp.setLooping(true);
                }
            });
            this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    JCameraView.this.mVideoView.setVideoPath(JCameraView.this.fileName);
                    JCameraView.this.mVideoView.start();
                }
            });
        }
    }

    public void setSaveVideoPath(String saveVideoPath) {
        this.saveVideoPath = saveVideoPath;
    }

    private void findAvailableCameras() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int numCamera = Camera.getNumberOfCameras();
        for (int i = 0; i < numCamera; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                this.CAMERA_FRONT_POSITION = info.facing;
                Log.i((String)"JCameraView", (String)("POSITION = " + this.CAMERA_FRONT_POSITION));
            }
            if (info.facing != 0) continue;
            this.CAMERA_POST_POSITION = info.facing;
            Log.i((String)"JCameraView", (String)("POSITION = " + this.CAMERA_POST_POSITION));
        }
    }

    public void setAutoFoucs(boolean autoFoucs) {
        this.autoFoucs = autoFoucs;
    }

    @Override
    public void onFocusBegin(float x, float y) {
        this.mFoucsView.setVisibility(0);
        this.mFoucsView.setX(x - (float)(this.mFoucsView.getWidth() / 2));
        this.mFoucsView.setY(y - (float)(this.mFoucsView.getHeight() / 2));
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                if (success) {
                    JCameraView.this.mCamera.cancelAutoFocus();
                    JCameraView.this.onFocusEnd();
                }
            }
        });
    }

    @Override
    public void onFocusEnd() {
        this.mFoucsView.setVisibility(4);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.autoFoucs && event.getAction() == 0 && this.SELECTED_CAMERA == this.CAMERA_POST_POSITION && !this.isPlay) {
            this.onFocusBegin(event.getX(), event.getY());
        }
        return super.onTouchEvent(event);
    }

    public static interface CameraViewListener {
        public void quit();

        public void captureSuccess(Bitmap var1);

        public void recordSuccess(String var1);
    }
}

