/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class CaptureButton
extends View {
    public final String TAG = "CaptureButtom";
    private Paint mPaint;
    private Context mContext;
    private float btn_center_Y;
    private float btn_center_X;
    private float btn_inside_radius;
    private float btn_outside_radius;
    private float btn_before_inside_radius;
    private float btn_before_outside_radius;
    private float btn_after_inside_radius;
    private float btn_after_outside_radius;
    private float btn_return_length;
    private float btn_return_X;
    private float btn_return_Y;
    private float btn_left_X;
    private float btn_right_X;
    private float btn_result_radius;
    private int STATE_SELECTED;
    private final int STATE_LESSNESS = 0;
    private final int STATE_KEY_DOWN = 1;
    private final int STATE_CAPTURED = 2;
    private final int STATE_RECORD = 3;
    private final int STATE_PICTURE_BROWSE = 4;
    private final int STATE_RECORD_BROWSE = 5;
    private final int STATE_READYQUIT = 6;
    private final int STATE_RECORDED = 7;
    private float key_down_Y;
    private RectF rectF;
    private float progress = 0.0f;
    private LongPressRunnable longPressRunnable = new LongPressRunnable();
    private RecordRunnable recordRunnable = new RecordRunnable();
    private ValueAnimator record_anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
    private CaptureListener mCaptureListener;

    public CaptureButton(Context context) {
        this(context, null);
    }

    public CaptureButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CaptureButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.STATE_SELECTED = 0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthSize;
        Log.i((String)"CaptureButtom", (String)("measureWidth = " + width));
        int height = width / 9 * 4;
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.btn_center_X = this.getWidth() / 2;
        this.btn_center_Y = this.getHeight() / 2;
        this.btn_outside_radius = this.getWidth() / 9;
        this.btn_inside_radius = (float)((double)this.btn_outside_radius * 0.75);
        this.btn_before_outside_radius = this.getWidth() / 9;
        this.btn_before_inside_radius = (float)((double)this.btn_outside_radius * 0.75);
        this.btn_after_outside_radius = this.getWidth() / 6;
        this.btn_after_inside_radius = (float)((double)this.btn_outside_radius * 0.6);
        this.btn_return_length = (float)((double)this.btn_outside_radius * 0.35);
        this.btn_result_radius = this.getWidth() / 9;
        this.btn_left_X = this.getWidth() / 2;
        this.btn_right_X = this.getWidth() / 2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.STATE_SELECTED == 0 || this.STATE_SELECTED == 3) {
            this.mPaint.setColor(-1118482);
            canvas.drawCircle(this.btn_center_X, this.btn_center_Y, this.btn_outside_radius, this.mPaint);
            this.mPaint.setColor(-1);
            canvas.drawCircle(this.btn_center_X, this.btn_center_Y, this.btn_inside_radius, this.mPaint);
            Paint paintArc = new Paint();
            paintArc.setAntiAlias(true);
            paintArc.setColor(-16724992);
            paintArc.setStyle(Paint.Style.STROKE);
            paintArc.setStrokeWidth(10.0f);
            this.rectF = new RectF(this.btn_center_X - (this.btn_after_outside_radius - 5.0f), this.btn_center_Y - (this.btn_after_outside_radius - 5.0f), this.btn_center_X + (this.btn_after_outside_radius - 5.0f), this.btn_center_Y + (this.btn_after_outside_radius - 5.0f));
            canvas.drawArc(this.rectF, -90.0f, this.progress, false, paintArc);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-1);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(4.0f);
            Path path = new Path();
            this.btn_return_X = ((float)(this.getWidth() / 2) - this.btn_outside_radius) / 2.0f;
            this.btn_return_Y = this.getHeight() / 2 + 10;
            path.moveTo(this.btn_return_X - this.btn_return_length, this.btn_return_Y - this.btn_return_length);
            path.lineTo(this.btn_return_X, this.btn_return_Y);
            path.lineTo(this.btn_return_X + this.btn_return_length, this.btn_return_Y - this.btn_return_length);
            canvas.drawPath(path, paint);
        } else if (this.STATE_SELECTED == 5 || this.STATE_SELECTED == 4) {
            this.mPaint.setColor(-1118482);
            canvas.drawCircle(this.btn_left_X, this.btn_center_Y, this.btn_result_radius, this.mPaint);
            this.mPaint.setColor(-1);
            canvas.drawCircle(this.btn_right_X, this.btn_center_Y, this.btn_result_radius, this.mPaint);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(3.0f);
            Path path = new Path();
            path.moveTo(this.btn_left_X - 2.0f, this.btn_center_Y + 14.0f);
            path.lineTo(this.btn_left_X + 14.0f, this.btn_center_Y + 14.0f);
            path.arcTo(new RectF(this.btn_left_X, this.btn_center_Y - 14.0f, this.btn_left_X + 28.0f, this.btn_center_Y + 14.0f), 90.0f, -180.0f);
            path.lineTo(this.btn_left_X - 14.0f, this.btn_center_Y - 14.0f);
            canvas.drawPath(path, paint);
            paint.setStyle(Paint.Style.FILL);
            path.reset();
            path.moveTo(this.btn_left_X - 14.0f, this.btn_center_Y - 22.0f);
            path.lineTo(this.btn_left_X - 14.0f, this.btn_center_Y - 6.0f);
            path.lineTo(this.btn_left_X - 23.0f, this.btn_center_Y - 14.0f);
            path.close();
            canvas.drawPath(path, paint);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16724992);
            paint.setStrokeWidth(4.0f);
            path.reset();
            path.moveTo(this.btn_right_X - 28.0f, this.btn_center_Y);
            path.lineTo(this.btn_right_X - 8.0f, this.btn_center_Y + 22.0f);
            path.lineTo(this.btn_right_X + 30.0f, this.btn_center_Y - 20.0f);
            path.lineTo(this.btn_right_X - 8.0f, this.btn_center_Y + 18.0f);
            path.close();
            canvas.drawPath(path, paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this.STATE_SELECTED == 0) {
                    if (event.getY() > this.btn_return_Y - 37.0f && event.getY() < this.btn_return_Y + 10.0f && event.getX() > this.btn_return_X - 37.0f && event.getX() < this.btn_return_X + 37.0f) {
                        this.STATE_SELECTED = 6;
                        break;
                    }
                    if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || !(event.getX() < this.btn_center_X + this.btn_outside_radius) || event.getPointerCount() != 1) break;
                    this.key_down_Y = event.getY();
                    this.STATE_SELECTED = 1;
                    this.postCheckForLongTouch(event.getX(), event.getY());
                    break;
                }
                if (this.STATE_SELECTED != 5 && this.STATE_SELECTED != 4) break;
                if (event.getY() > this.btn_center_Y - this.btn_result_radius && event.getY() < this.btn_center_Y + this.btn_result_radius && event.getX() > this.btn_left_X - this.btn_result_radius && event.getX() < this.btn_left_X + this.btn_result_radius && event.getPointerCount() == 1) {
                    if (this.mCaptureListener != null) {
                        if (this.STATE_SELECTED == 5) {
                            this.mCaptureListener.deleteRecordResult();
                        } else if (this.STATE_SELECTED == 4) {
                            this.mCaptureListener.cancel();
                        }
                    }
                    this.STATE_SELECTED = 0;
                    this.btn_left_X = this.btn_center_X;
                    this.btn_right_X = this.btn_center_X;
                    this.invalidate();
                    break;
                }
                if (!(event.getY() > this.btn_center_Y - this.btn_result_radius) || !(event.getY() < this.btn_center_Y + this.btn_result_radius) || !(event.getX() > this.btn_right_X - this.btn_result_radius) || !(event.getX() < this.btn_right_X + this.btn_result_radius) || event.getPointerCount() != 1) break;
                if (this.mCaptureListener != null) {
                    if (this.STATE_SELECTED == 5) {
                        this.mCaptureListener.getRecordResult();
                    } else if (this.STATE_SELECTED == 4) {
                        this.mCaptureListener.determine();
                    }
                }
                this.STATE_SELECTED = 0;
                this.btn_left_X = this.btn_center_X;
                this.btn_right_X = this.btn_center_X;
                this.invalidate();
                break;
            }
            case 2: {
                if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || event.getX() < this.btn_center_X + this.btn_outside_radius) {
                    // empty if block
                }
                if (this.mCaptureListener == null) break;
                this.mCaptureListener.scale(this.key_down_Y - event.getY());
                break;
            }
            case 1: {
                this.removeCallbacks(this.longPressRunnable);
                if (this.STATE_SELECTED == 6) {
                    if (!(event.getY() > this.btn_return_Y - 37.0f) || !(event.getY() < this.btn_return_Y + 10.0f) || !(event.getX() > this.btn_return_X - 37.0f) || !(event.getX() < this.btn_return_X + 37.0f)) break;
                    this.STATE_SELECTED = 0;
                    if (this.mCaptureListener == null) break;
                    this.mCaptureListener.quit();
                    break;
                }
                if (this.STATE_SELECTED == 1) {
                    if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || !(event.getX() < this.btn_center_X + this.btn_outside_radius)) break;
                    if (this.mCaptureListener != null) {
                        this.mCaptureListener.capture();
                    }
                    this.STATE_SELECTED = 4;
                    break;
                }
                if (this.STATE_SELECTED != 3) break;
                if (this.record_anim.getCurrentPlayTime() < 500L) {
                    this.STATE_SELECTED = 0;
                    this.progress = 0.0f;
                    this.invalidate();
                    this.record_anim.cancel();
                } else {
                    this.STATE_SELECTED = 5;
                    this.removeCallbacks(this.recordRunnable);
                    this.captureAnimation(this.getWidth() / 5, this.getWidth() / 5 * 4);
                    this.record_anim.cancel();
                    this.progress = 0.0f;
                    this.invalidate();
                    if (this.mCaptureListener != null) {
                        this.mCaptureListener.rencodEnd();
                    }
                }
                if (this.btn_outside_radius == this.btn_after_outside_radius && this.btn_inside_radius == this.btn_after_inside_radius) {
                    this.startAnimation(this.btn_after_outside_radius, this.btn_before_outside_radius, this.btn_after_inside_radius, this.btn_before_inside_radius);
                    break;
                }
                this.startAnimation(this.btn_after_outside_radius, this.btn_before_outside_radius, this.btn_after_inside_radius, this.btn_before_inside_radius);
            }
        }
        return true;
    }

    public void captureSuccess() {
        this.captureAnimation(this.getWidth() / 5, this.getWidth() / 5 * 4);
    }

    private void postCheckForLongTouch(float x, float y) {
        this.longPressRunnable.setPressLocation(x, y);
        this.postDelayed(this.longPressRunnable, 500L);
    }

    private void startAnimation(float outside_start, float outside_end, float inside_start, float inside_end) {
        ValueAnimator outside_anim = ValueAnimator.ofFloat((float[])new float[]{outside_start, outside_end});
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_end});
        outside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_outside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        outside_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (CaptureButton.this.STATE_SELECTED == 3) {
                    CaptureButton.this.postDelayed(CaptureButton.this.recordRunnable, 100L);
                }
            }
        });
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        outside_anim.setDuration(100L);
        inside_anim.setDuration(100L);
        outside_anim.start();
        inside_anim.start();
    }

    private void captureAnimation(float left, float right) {
        Log.i((String)"CaptureButtom", (String)(left + "==" + right));
        ValueAnimator left_anim = ValueAnimator.ofFloat((float[])new float[]{this.btn_left_X, left});
        ValueAnimator right_anim = ValueAnimator.ofFloat((float[])new float[]{this.btn_right_X, right});
        left_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_left_X = ((Float)animation.getAnimatedValue()).floatValue();
                Log.i((String)"CJT", (String)(CaptureButton.this.btn_left_X + "====="));
                CaptureButton.this.invalidate();
            }
        });
        right_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_right_X = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        left_anim.setDuration(200L);
        right_anim.setDuration(200L);
        left_anim.start();
        right_anim.start();
    }

    public void setCaptureListener(CaptureListener mCaptureListener) {
        this.mCaptureListener = mCaptureListener;
    }

    public static interface CaptureListener {
        public void capture();

        public void cancel();

        public void determine();

        public void quit();

        public void record();

        public void rencodEnd();

        public void getRecordResult();

        public void deleteRecordResult();

        public void scale(float var1);
    }

    private class RecordRunnable
    implements Runnable {
        private RecordRunnable() {
        }

        @Override
        public void run() {
            if (CaptureButton.this.mCaptureListener != null) {
                CaptureButton.this.mCaptureListener.record();
            }
            CaptureButton.this.record_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    if (CaptureButton.this.STATE_SELECTED == 3) {
                        CaptureButton.this.progress = ((Float)animation.getAnimatedValue()).floatValue();
                    }
                    CaptureButton.this.invalidate();
                }
            });
            CaptureButton.this.record_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (CaptureButton.this.STATE_SELECTED == 3) {
                        CaptureButton.this.STATE_SELECTED = 5;
                        CaptureButton.this.progress = 0.0f;
                        CaptureButton.this.invalidate();
                        CaptureButton.this.captureAnimation(CaptureButton.this.getWidth() / 5, CaptureButton.this.getWidth() / 5 * 4);
                        if (CaptureButton.this.btn_outside_radius == CaptureButton.this.btn_after_outside_radius && CaptureButton.this.btn_inside_radius == CaptureButton.this.btn_after_inside_radius) {
                            CaptureButton.this.startAnimation(CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_inside_radius, CaptureButton.this.btn_before_inside_radius);
                        } else {
                            CaptureButton.this.startAnimation(CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_inside_radius, CaptureButton.this.btn_before_inside_radius);
                        }
                        if (CaptureButton.this.mCaptureListener != null) {
                            CaptureButton.this.mCaptureListener.rencodEnd();
                        }
                    }
                }
            });
            CaptureButton.this.record_anim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            CaptureButton.this.record_anim.setDuration(10000L);
            CaptureButton.this.record_anim.start();
        }
    }

    private class LongPressRunnable
    implements Runnable {
        private int x;
        private int y;

        private LongPressRunnable() {
        }

        public void setPressLocation(float x, float y) {
            this.x = (int)x;
            this.y = (int)y;
        }

        @Override
        public void run() {
            CaptureButton.this.startAnimation(CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_inside_radius, CaptureButton.this.btn_after_inside_radius);
            CaptureButton.this.STATE_SELECTED = 3;
        }
    }
}

