/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.cjt2325.cameralibrary.AudioUtil;
import com.cjt2325.cameralibrary.CaptureButtom;
import com.cjt2325.cameralibrary.FileUtil;
import com.cjt2325.cameralibrary.R;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JCameraView
extends RelativeLayout
implements SurfaceHolder.Callback {
    public final String TAG = "JCameraView";
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mImageView;
    private ImageView photoImageView;
    private CaptureButtom mCaptureButtom;
    private MediaRecorder mediaRecorder;
    private SurfaceHolder mHolder = null;
    private Camera mCamera;
    private int width;
    private int height;
    private String fileName;
    private Bitmap pictureBitmap;
    private int SELECTED_CAMERA = 0;
    private final int CAMERA_POST_POSITION = 0;
    private final int CAMERA_FRONT_POSITION = 1;
    private CameraViewListener cameraViewListener;

    public void setCameraViewListener(CameraViewListener cameraViewListener) {
        this.cameraViewListener = cameraViewListener;
    }

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        AudioUtil.setAudioManage(this.mContext);
        this.SELECTED_CAMERA = 0;
        this.setBackgroundColor(-16777216);
        this.mVideoView = new VideoView(context);
        RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, -1);
        videoViewParam.addRule(13, -1);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        RelativeLayout.LayoutParams btnParams = new RelativeLayout.LayoutParams(-2, -2);
        btnParams.addRule(14, -1);
        btnParams.addRule(12, -1);
        this.mCaptureButtom = new CaptureButtom(context);
        this.mCaptureButtom.setLayoutParams((ViewGroup.LayoutParams)btnParams);
        this.photoImageView = new ImageView(context);
        RelativeLayout.LayoutParams photoImageViewParam = new RelativeLayout.LayoutParams(-1, -1);
        this.photoImageView.setLayoutParams((ViewGroup.LayoutParams)photoImageViewParam);
        this.photoImageView.setBackgroundColor(-16777216);
        this.photoImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.photoImageView.setVisibility(4);
        this.mImageView = new ImageView(context);
        RelativeLayout.LayoutParams imageViewParam = new RelativeLayout.LayoutParams(60, 60);
        imageViewParam.addRule(11, -1);
        imageViewParam.setMargins(0, 40, 40, 0);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imageViewParam);
        this.mImageView.setImageResource(R.drawable.ic_repeat_black_24dp);
        this.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JCameraView.this.mCamera != null) {
                    JCameraView.this.releaseCamera();
                    if (JCameraView.this.SELECTED_CAMERA == 0) {
                        JCameraView.this.SELECTED_CAMERA = 1;
                    } else {
                        JCameraView.this.SELECTED_CAMERA = 0;
                    }
                    JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                    JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
                }
            }
        });
        this.addView((View)this.mVideoView);
        this.addView((View)this.photoImageView);
        this.addView(this.mCaptureButtom);
        this.addView((View)this.mImageView);
        this.mHolder = this.mVideoView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mCaptureButtom.setCaptureListener(new CaptureButtom.CaptureListener(){

            @Override
            public void capture() {
                JCameraView.this.capture();
            }

            @Override
            public void cancel() {
                JCameraView.this.photoImageView.setVisibility(4);
                JCameraView.this.mImageView.setVisibility(0);
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void determine() {
                if (JCameraView.this.cameraViewListener != null) {
                    FileUtil.saveBitmap(JCameraView.this.pictureBitmap);
                    JCameraView.this.cameraViewListener.captureSuccess(JCameraView.this.pictureBitmap);
                }
                JCameraView.this.photoImageView.setVisibility(4);
                JCameraView.this.mImageView.setVisibility(0);
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void quit() {
                if (JCameraView.this.cameraViewListener != null) {
                    JCameraView.this.cameraViewListener.quit();
                }
            }

            @Override
            public void record() {
                JCameraView.this.startRecord();
            }

            @Override
            public void rencodEnd() {
                JCameraView.this.stopRecord();
            }

            @Override
            public void getRecordResult() {
                if (JCameraView.this.cameraViewListener != null) {
                    JCameraView.this.cameraViewListener.recordSuccess(JCameraView.this.fileName);
                }
                JCameraView.this.mVideoView.stopPlayback();
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void deleteRecordResult() {
                File file = new File(JCameraView.this.fileName);
                if (file.exists()) {
                    file.delete();
                }
                JCameraView.this.mVideoView.stopPlayback();
                JCameraView.this.releaseCamera();
                JCameraView.this.mCamera = JCameraView.this.getCamera(JCameraView.this.SELECTED_CAMERA);
                JCameraView.this.setStartPreview(JCameraView.this.mCamera, JCameraView.this.mHolder);
            }

            @Override
            public void scale(float scaleValue) {
                Log.i((String)"JCameraView", (String)("scaleValue = " + scaleValue));
            }
        });
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    private Camera getCamera(int position) {
        Camera camera;
        try {
            camera = Camera.open((int)position);
        }
        catch (Exception e) {
            camera = null;
            e.printStackTrace();
        }
        return camera;
    }

    public void btnReturn() {
        this.setStartPreview(this.mCamera, this.mHolder);
    }

    private void setStartPreview(Camera camera, SurfaceHolder holder) {
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            parameters.setPictureFormat(256);
            List sizeList = parameters.getSupportedPreviewSizes();
            for (Camera.Size cur : sizeList) {
                if (cur.width < this.width || cur.height < this.height) continue;
                this.width = cur.width;
                this.height = cur.height;
            }
            Log.i((String)"size", (String)("width : height" + this.width + " : " + this.height + " ==== " + this.getWidth() + " : " + this.getHeight()));
            parameters.setPreviewSize(this.width, this.height);
            parameters.setPictureSize(this.width, this.height);
            parameters.setFocusMode("auto");
            camera.setParameters(parameters);
            camera.setPreviewDisplay(holder);
            camera.setDisplayOrientation(90);
            camera.startPreview();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void capture() {
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                if (success) {
                    JCameraView.this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                        public void onPictureTaken(byte[] data, Camera camera) {
                            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                            Matrix matrix = new Matrix();
                            matrix.setRotate(90.0f);
                            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                            JCameraView.this.pictureBitmap = bitmap;
                            JCameraView.this.photoImageView.setImageBitmap(bitmap);
                            JCameraView.this.photoImageView.setVisibility(0);
                            JCameraView.this.mImageView.setVisibility(4);
                            JCameraView.this.mCaptureButtom.captureSuccess();
                        }
                    });
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.setStartPreview(this.mCamera, holder);
        Log.i((String)"Camera", (String)"surfaceCreated");
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mHolder = holder;
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.setStartPreview(this.mCamera, holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.releaseCamera();
        Log.i((String)"Camera", (String)"surfaceDestroyed");
    }

    public void onResume() {
        this.mCamera = this.getCamera(this.SELECTED_CAMERA);
        this.setStartPreview(this.mCamera, this.mHolder);
    }

    public void onPause() {
        this.releaseCamera();
    }

    private void startRecord() {
        this.mediaRecorder = new MediaRecorder();
        this.mediaRecorder.reset();
        this.mCamera.unlock();
        this.mediaRecorder.setCamera(this.mCamera);
        this.mediaRecorder.setVideoSource(1);
        this.mediaRecorder.setAudioSource(1);
        this.mediaRecorder.setOutputFormat(2);
        this.mediaRecorder.setVideoEncoder(2);
        this.mediaRecorder.setAudioEncoder(1);
        this.mediaRecorder.setVideoSize(this.width, this.height);
        if (this.SELECTED_CAMERA == 1) {
            this.mediaRecorder.setOrientationHint(270);
        } else {
            this.mediaRecorder.setOrientationHint(90);
        }
        this.mediaRecorder.setMaxDuration(10000);
        this.mediaRecorder.setVideoEncodingBitRate(0x500000);
        this.mediaRecorder.setVideoFrameRate(20);
        this.mediaRecorder.setPreviewDisplay(this.mHolder.getSurface());
        this.mediaRecorder.setOutputFile("/sdcard/love.mp4");
        try {
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopRecord() {
        if (this.mediaRecorder != null) {
            this.mediaRecorder.stop();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
            this.releaseCamera();
            this.fileName = "/sdcard/love.mp4";
            this.mVideoView.setVideoPath(this.fileName);
            this.mVideoView.start();
            this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    mp.start();
                    mp.setLooping(true);
                }
            });
            this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    JCameraView.this.mVideoView.setVideoPath(JCameraView.this.fileName);
                    JCameraView.this.mVideoView.start();
                }
            });
        }
    }

    public static interface CameraViewListener {
        public void quit();

        public void captureSuccess(Bitmap var1);

        public void recordSuccess(String var1);
    }
}

