/*
 * Decompiled with CFR 0.152.
 */
package cidernrepl0532.difflib;

import cidernrepl0532.difflib.Chunk;
import cidernrepl0532.difflib.Delta;
import cidernrepl0532.difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertDelta<T>
extends Delta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        List lines = this.getRevised().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.INSERT;
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getRevised().getLines() + "]";
    }
}

