/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv.values;

import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt32Data;

public class Value32
extends UInt32Data
implements Value {
    public static final Value32 ZERO = Value32.from(UInt32Data.ZERO);

    public Value32(UInt32Data data) {
        super((ByteArray)data, data.value, data.endian);
    }

    public Value32(ByteArray data, long value, IntegerData.Endian endian) {
        super(data, value, endian);
    }

    public static Value32 from(Value32 value) {
        return value;
    }

    public static Value32 from(UInt32Data data) {
        return new Value32((ByteArray)data, data.value, data.endian);
    }

    public static Value32 from(ByteArray data) {
        if (data.getSize() < 4) {
            return null;
        }
        if (data.getSize() > 4) {
            data = data.slice(0, 4);
        }
        return new Value32(IntegerData.getUInt32Data((ByteArray)data));
    }

    public static Value32 from(int value) {
        return new Value32(IntegerData.getUInt32Data((long)value));
    }

    public static Value32 from(long value) {
        return new Value32(IntegerData.getUInt32Data((long)value));
    }

    public static Value32 from(Integer value) {
        return new Value32(IntegerData.getUInt32Data((long)value.intValue()));
    }

    public static Value32 from(Long value) {
        return new Value32(IntegerData.getUInt32Data((long)value));
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return Value32.from(data);
    }
}

