/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv.values;

import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import java.nio.charset.Charset;

public class StringValue
extends Data
implements Value {
    public static final StringValue ZERO = StringValue.from((ByteArray)Data.ZERO);
    public final String string;

    public StringValue(ByteArray data, String string) {
        super(data);
        this.string = string;
    }

    public StringValue(byte[] buffer, int offset, int size, String string) {
        super(buffer, offset, size);
        this.string = string;
    }

    public StringValue(byte[] bytes, String string) {
        super(bytes);
        this.string = string;
    }

    public static StringValue from(StringValue value) {
        return value;
    }

    public static StringValue from(ByteArray data) {
        String string = new String(data.getBytes(), Charset.forName("UTF-8"));
        return new StringValue(data, string);
    }

    public static StringValue from(String string) {
        byte[] bytes = string.getBytes(Charset.forName("UTF-8"));
        return new StringValue(bytes, 0, bytes.length, string);
    }

    public static StringValue from(byte[] bytes) {
        String string = new String(bytes, Charset.forName("UTF-8"));
        return new StringValue(bytes, 0, bytes.length, string);
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return StringValue.from(data);
    }
}

